'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIC:\DotNetNuke\DesktopModules\Bring2mind\IWork\_Installation\M, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports System
Imports System.Data
Imports Bring2mind.DNN.Modules.IWork.Data
Imports DotNetNuke.Services.Search
Imports System.Configuration
Imports DotNetNuke
Imports System.XML
Imports DotNetNuke.Common.Utilities

Namespace Bring2mind.DNN.Modules.IWork.Business

#Region "AccountsInfo"
 Public Class AccountsInfo

  ' local property declarations
  Dim _accountId As Integer
  Dim _accountName As String
  Dim _accountType As String
  Dim _billedThrough As Integer
  Dim _billingCity As String
  Dim _billingCountry As String
  Dim _billingPostalCode As String
  Dim _billingStreet As String
  Dim _contactEmail As String
  Dim _contactMobile As String
  Dim _contactName As String
  Dim _contactPhone As String
  Dim _defaultCurrency As String
  Dim _defaultTariff As Decimal
  Dim _deleted As Boolean
  Dim _portalId As Integer
  Dim _userId As Integer

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal accountId As Integer, ByVal accountName As String, ByVal accountType As String, ByVal billedThrough As Integer, ByVal billingCity As String, ByVal billingCountry As String, ByVal billingPostalCode As String, ByVal billingStreet As String, ByVal contactEmail As String, ByVal contactMobile As String, ByVal contactName As String, ByVal contactPhone As String, ByVal defaultCurrency As String, ByVal defaultTariff As Decimal, ByVal deleted As Boolean, ByVal portalId As Integer, ByVal userId As Integer)
   Me.AccountId = AccountId
   Me.AccountName = AccountName
   Me.AccountType = AccountType
   Me.BilledThrough = BilledThrough
   Me.BillingCity = BillingCity
   Me.BillingCountry = BillingCountry
   Me.BillingPostalCode = BillingPostalCode
   Me.BillingStreet = BillingStreet
   Me.ContactEmail = ContactEmail
   Me.ContactMobile = ContactMobile
   Me.ContactName = ContactName
   Me.ContactPhone = ContactPhone
   Me.DefaultCurrency = DefaultCurrency
   Me.DefaultTariff = DefaultTariff
   Me.Deleted = Deleted
   Me.PortalId = PortalId
   Me.UserId = UserId
  End Sub
#End Region

#Region "Public Properties"
  Public Property AccountId() As Integer
   Get
    Return _accountId
   End Get
   Set(ByVal Value As Integer)
    _accountId = Value
   End Set
  End Property

  Public Property AccountName() As String
   Get
    Return _accountName
   End Get
   Set(ByVal Value As String)
    _accountName = Value
   End Set
  End Property

  Public Property AccountType() As String
   Get
    Return _accountType
   End Get
   Set(ByVal Value As String)
    _accountType = Value
   End Set
  End Property

  Public Property BilledThrough() As Integer
   Get
    Return _billedThrough
   End Get
   Set(ByVal Value As Integer)
    _billedThrough = Value
   End Set
  End Property

  Public Property BillingCity() As String
   Get
    Return _billingCity
   End Get
   Set(ByVal Value As String)
    _billingCity = Value
   End Set
  End Property

  Public Property BillingCountry() As String
   Get
    Return _billingCountry
   End Get
   Set(ByVal Value As String)
    _billingCountry = Value
   End Set
  End Property

  Public Property BillingPostalCode() As String
   Get
    Return _billingPostalCode
   End Get
   Set(ByVal Value As String)
    _billingPostalCode = Value
   End Set
  End Property

  Public Property BillingStreet() As String
   Get
    Return _billingStreet
   End Get
   Set(ByVal Value As String)
    _billingStreet = Value
   End Set
  End Property

  Public Property ContactEmail() As String
   Get
    Return _contactEmail
   End Get
   Set(ByVal Value As String)
    _contactEmail = Value
   End Set
  End Property

  Public Property ContactMobile() As String
   Get
    Return _contactMobile
   End Get
   Set(ByVal Value As String)
    _contactMobile = Value
   End Set
  End Property

  Public Property ContactName() As String
   Get
    Return _contactName
   End Get
   Set(ByVal Value As String)
    _contactName = Value
   End Set
  End Property

  Public Property ContactPhone() As String
   Get
    Return _contactPhone
   End Get
   Set(ByVal Value As String)
    _contactPhone = Value
   End Set
  End Property

  Public Property DefaultCurrency() As String
   Get
    Return _defaultCurrency
   End Get
   Set(ByVal Value As String)
    _defaultCurrency = Value
   End Set
  End Property

  Public Property DefaultTariff() As Decimal
   Get
    Return _defaultTariff
   End Get
   Set(ByVal Value As Decimal)
    _defaultTariff = Value
   End Set
  End Property

  Public Property Deleted() As Boolean
   Get
    Return _deleted
   End Get
   Set(ByVal Value As Boolean)
    _deleted = Value
   End Set
  End Property

  Public Property PortalId() As Integer
   Get
    Return _portalId
   End Get
   Set(ByVal Value As Integer)
    _portalId = Value
   End Set
  End Property

  Public Property UserId() As Integer
   Get
    Return _userId
   End Get
   Set(ByVal Value As Integer)
    _userId = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "AccountsController"
 Public Class AccountsController

  Public Function GetAccounts(ByVal accountId As Integer, ByVal portalId As Integer) As AccountsInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetAccounts(accountId, portalId), GetType(AccountsInfo)), AccountsInfo)

  End Function


  Public Function GetAccountsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetAccountsByPortal(PortalId, IncludeDeleted), GetType(AccountsInfo))

  End Function

  Public Function GetAccountsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetAccountsByUser(UserId, IncludeDeleted), GetType(AccountsInfo))

  End Function

  Public Function AddAccounts(ByVal objAccounts As AccountsInfo) As Integer

   Return CType(DataProvider.Instance().AddAccounts(objAccounts.AccountName, objAccounts.AccountType, objAccounts.BilledThrough, objAccounts.BillingCity, objAccounts.BillingCountry, objAccounts.BillingPostalCode, objAccounts.BillingStreet, objAccounts.ContactEmail, objAccounts.ContactMobile, objAccounts.ContactName, objAccounts.ContactPhone, objAccounts.DefaultCurrency, objAccounts.DefaultTariff, objAccounts.Deleted, objAccounts.PortalId, objAccounts.UserId), Integer)

  End Function

  Public Sub UpdateAccounts(ByVal objAccounts As AccountsInfo)

   DataProvider.Instance().UpdateAccounts(objAccounts.AccountId, objAccounts.AccountName, objAccounts.AccountType, objAccounts.BilledThrough, objAccounts.BillingCity, objAccounts.BillingCountry, objAccounts.BillingPostalCode, objAccounts.BillingStreet, objAccounts.ContactEmail, objAccounts.ContactMobile, objAccounts.ContactName, objAccounts.ContactPhone, objAccounts.DefaultCurrency, objAccounts.DefaultTariff, objAccounts.Deleted, objAccounts.PortalId, objAccounts.UserId)

  End Sub

  Public Sub DeleteAccounts(ByVal accountId As Integer)

   DataProvider.Instance().DeleteAccounts(accountId)

  End Sub

 End Class
#End Region


#Region "InvoicesInfo"
 Public Class InvoicesInfo

  ' local property declarations
  Dim _invoiceId As Integer
  Dim _accountId As Integer
  Dim _currency As String
  Dim _datePaid As Date
  Dim _dateSent As Date
  Dim _invoiceCode As String
  Dim _paid As Boolean
  Dim _reference As String
  Dim _sent As Boolean
  Dim _subject As String
  Dim _subtotal As Decimal
  Dim _total As Decimal
  Dim _vAT As Decimal

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal invoiceId As Integer, ByVal accountId As Integer, ByVal currency As String, ByVal datePaid As Date, ByVal dateSent As Date, ByVal invoiceCode As String, ByVal paid As Boolean, ByVal reference As String, ByVal sent As Boolean, ByVal subject As String, ByVal subtotal As Decimal, ByVal total As Decimal, ByVal vAT As Decimal)
   Me.AccountId = accountId
   Me.Currency = currency
   Me.DatePaid = datePaid
   Me.DateSent = dateSent
   Me.InvoiceCode = invoiceCode
   Me.InvoiceId = invoiceId
   Me.Paid = paid
   Me.Reference = reference
   Me.Sent = sent
   Me.Subject = subject
   Me.Subtotal = subtotal
   Me.Total = total
   Me.VAT = vAT
  End Sub
#End Region

#Region "Public Properties"
  Public Property InvoiceId() As Integer
   Get
    Return _invoiceId
   End Get
   Set(ByVal Value As Integer)
    _invoiceId = Value
   End Set
  End Property

  Public Property AccountId() As Integer
   Get
    Return _accountId
   End Get
   Set(ByVal Value As Integer)
    _accountId = Value
   End Set
  End Property

  Public Property Currency() As String
   Get
    Return _currency
   End Get
   Set(ByVal Value As String)
    _currency = Value
   End Set
  End Property

  Public Property DatePaid() As Date
   Get
    Return _datePaid
   End Get
   Set(ByVal Value As Date)
    _datePaid = Value
   End Set
  End Property

  Public Property DateSent() As Date
   Get
    Return _dateSent
   End Get
   Set(ByVal Value As Date)
    _dateSent = Value
   End Set
  End Property

  Public Property InvoiceCode() As String
   Get
    Return _invoiceCode
   End Get
   Set(ByVal Value As String)
    _invoiceCode = Value
   End Set
  End Property

  Public Property Paid() As Boolean
   Get
    Return _paid
   End Get
   Set(ByVal Value As Boolean)
    _paid = Value
   End Set
  End Property

  Public Property Reference() As String
   Get
    Return _reference
   End Get
   Set(ByVal Value As String)
    _reference = Value
   End Set
  End Property

  Public Property Sent() As Boolean
   Get
    Return _sent
   End Get
   Set(ByVal Value As Boolean)
    _sent = Value
   End Set
  End Property

  Public Property Subject() As String
   Get
    Return _subject
   End Get
   Set(ByVal Value As String)
    _subject = Value
   End Set
  End Property

  Public Property Subtotal() As Decimal
   Get
    Return _subtotal
   End Get
   Set(ByVal Value As Decimal)
    _subtotal = Value
   End Set
  End Property

  Public Property Total() As Decimal
   Get
    Return _total
   End Get
   Set(ByVal Value As Decimal)
    _total = Value
   End Set
  End Property

  Public Property VAT() As Decimal
   Get
    Return _vAT
   End Get
   Set(ByVal Value As Decimal)
    _vAT = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "InvoicesController"
 Public Class InvoicesController

  Public Function GetInvoices(ByVal invoiceId As Integer) As InvoicesInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetInvoices(invoiceId), GetType(InvoicesInfo)), InvoicesInfo)

  End Function


  Public Function GetInvoicesByAccounts(ByVal accountId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetInvoicesByAccounts(accountId), GetType(InvoicesInfo))

  End Function

  Public Function GetInvoicesByPortal(ByVal PortalId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetInvoicesByPortal(PortalId), GetType(InvoicesInfo))

  End Function

  Public Function GetInvoicesByUser(ByVal UserId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetInvoicesByUser(UserId), GetType(InvoicesInfo))

  End Function

  Public Function AddInvoices(ByVal objInvoices As InvoicesInfo) As Integer

   Return CType(DataProvider.Instance().AddInvoices(objInvoices.AccountId, objInvoices.Currency, objInvoices.DatePaid, objInvoices.DateSent, objInvoices.InvoiceCode, objInvoices.Paid, objInvoices.Reference, objInvoices.Sent, objInvoices.Subject, objInvoices.Subtotal, objInvoices.Total, objInvoices.VAT), Integer)

  End Function

  Public Sub UpdateInvoices(ByVal objInvoices As InvoicesInfo)

   DataProvider.Instance().UpdateInvoices(objInvoices.InvoiceId, objInvoices.AccountId, objInvoices.Currency, objInvoices.DatePaid, objInvoices.DateSent, objInvoices.InvoiceCode, objInvoices.Paid, objInvoices.Reference, objInvoices.Sent, objInvoices.Subject, objInvoices.Subtotal, objInvoices.Total, objInvoices.VAT)

  End Sub

  Public Sub DeleteInvoices(ByVal invoiceId As Integer)

   DataProvider.Instance().DeleteInvoices(invoiceId)

  End Sub

 End Class
#End Region


#Region "IssuesInfo"
 Public Class IssuesInfo

  ' local property declarations
  Dim _issueId As Integer
  Dim _discourse As String
  Dim _issueDate As Date
  Dim _issueHeading As String
  Dim _issueUrgency As Integer
  Dim _projectId As Integer
  Dim _resolved As Boolean
  Dim _resolvedByTask As Integer
  Dim _resolvedDate As Date

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal issueId As Integer, ByVal discourse As String, ByVal issueDate As Date, ByVal issueHeading As String, ByVal issueUrgency As Integer, ByVal projectId As Integer, ByVal resolved As Boolean, ByVal resolvedByTask As Integer, ByVal resolvedDate As Date)
   Me.Discourse = discourse
   Me.IssueDate = issueDate
   Me.IssueHeading = issueHeading
   Me.IssueId = issueId
   Me.IssueUrgency = issueUrgency
   Me.ProjectId = projectId
   Me.Resolved = resolved
   Me.ResolvedByTask = resolvedByTask
   Me.ResolvedDate = resolvedDate
  End Sub
#End Region

#Region "Public Properties"
  Public Property IssueId() As Integer
   Get
    Return _issueId
   End Get
   Set(ByVal Value As Integer)
    _issueId = Value
   End Set
  End Property

  Public Property Discourse() As String
   Get
    Return _discourse
   End Get
   Set(ByVal Value As String)
    _discourse = Value
   End Set
  End Property

  Public Property IssueDate() As Date
   Get
    Return _issueDate
   End Get
   Set(ByVal Value As Date)
    _issueDate = Value
   End Set
  End Property

  Public Property IssueHeading() As String
   Get
    Return _issueHeading
   End Get
   Set(ByVal Value As String)
    _issueHeading = Value
   End Set
  End Property

  Public Property IssueUrgency() As Integer
   Get
    Return _issueUrgency
   End Get
   Set(ByVal Value As Integer)
    _issueUrgency = Value
   End Set
  End Property

  Public Property ProjectId() As Integer
   Get
    Return _projectId
   End Get
   Set(ByVal Value As Integer)
    _projectId = Value
   End Set
  End Property

  Public Property Resolved() As Boolean
   Get
    Return _resolved
   End Get
   Set(ByVal Value As Boolean)
    _resolved = Value
   End Set
  End Property

  Public Property ResolvedByTask() As Integer
   Get
    Return _resolvedByTask
   End Get
   Set(ByVal Value As Integer)
    _resolvedByTask = Value
   End Set
  End Property

  Public Property ResolvedDate() As Date
   Get
    Return _resolvedDate
   End Get
   Set(ByVal Value As Date)
    _resolvedDate = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "IssuesController"
 Public Class IssuesController

  Public Function GetIssues(ByVal issueId As Integer) As IssuesInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetIssues(issueId), GetType(IssuesInfo)), IssuesInfo)

  End Function


  Public Function GetIssuesByProjects(ByVal projectId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetIssuesByProjects(projectId), GetType(IssuesInfo))

  End Function

  Public Function GetIssuesByAccounts(ByVal accountId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetIssuesByAccounts(accountId), GetType(IssuesInfo))

  End Function

  Public Function GetIssuesByPortal(ByVal PortalId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetIssuesByPortal(PortalId), GetType(IssuesInfo))

  End Function

  Public Function GetIssuesByUser(ByVal UserId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetIssuesByUser(UserId), GetType(IssuesInfo))

  End Function

  Public Function GetIssuesByTasks(ByVal taskId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetIssuesByTasks(taskId), GetType(IssuesInfo))

  End Function

  Public Function AddIssues(ByVal objIssues As IssuesInfo) As Integer

   Return CType(DataProvider.Instance().AddIssues(objIssues.Discourse, objIssues.IssueDate, objIssues.IssueHeading, objIssues.IssueUrgency, objIssues.ProjectId, objIssues.Resolved, objIssues.ResolvedByTask, objIssues.ResolvedDate), Integer)

  End Function

  Public Sub UpdateIssues(ByVal objIssues As IssuesInfo)

   DataProvider.Instance().UpdateIssues(objIssues.IssueId, objIssues.Discourse, objIssues.IssueDate, objIssues.IssueHeading, objIssues.IssueUrgency, objIssues.ProjectId, objIssues.Resolved, objIssues.ResolvedByTask, objIssues.ResolvedDate)

  End Sub

  Public Sub DeleteIssues(ByVal issueId As Integer)

   DataProvider.Instance().DeleteIssues(issueId)

  End Sub

 End Class
#End Region


#Region "ProductsInfo"
 Public Class ProductsInfo

  ' local property declarations
  Dim _productsId As Integer
  Dim _category As String
  Dim _comments As String
  Dim _dateDelivered As Date
  Dim _deleted As Boolean
  Dim _description As String
  Dim _invoiceId As Integer
  Dim _priceBuy As Decimal
  Dim _priceSell As Decimal
  Dim _projectId As Integer
  Dim _quantity As Decimal

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal productsId As Integer, ByVal category As String, ByVal comments As String, ByVal dateDelivered As Date, ByVal deleted As Boolean, ByVal description As String, ByVal invoiceId As Integer, ByVal priceBuy As Decimal, ByVal priceSell As Decimal, ByVal projectId As Integer, ByVal quantity As Decimal)
   Me.Category = category
   Me.Comments = comments
   Me.DateDelivered = dateDelivered
   Me.Deleted = deleted
   Me.Description = description
   Me.InvoiceId = invoiceId
   Me.PriceBuy = priceBuy
   Me.PriceSell = priceSell
   Me.ProductsId = productsId
   Me.ProjectId = projectId
   Me.Quantity = quantity
  End Sub
#End Region

#Region "Public Properties"
  Public Property ProductsId() As Integer
   Get
    Return _productsId
   End Get
   Set(ByVal Value As Integer)
    _productsId = Value
   End Set
  End Property

  Public Property Category() As String
   Get
    Return _category
   End Get
   Set(ByVal Value As String)
    _category = Value
   End Set
  End Property

  Public Property Comments() As String
   Get
    Return _comments
   End Get
   Set(ByVal Value As String)
    _comments = Value
   End Set
  End Property

  Public Property DateDelivered() As Date
   Get
    Return _dateDelivered
   End Get
   Set(ByVal Value As Date)
    _dateDelivered = Value
   End Set
  End Property

  Public Property Deleted() As Boolean
   Get
    Return _deleted
   End Get
   Set(ByVal Value As Boolean)
    _deleted = Value
   End Set
  End Property

  Public Property Description() As String
   Get
    Return _description
   End Get
   Set(ByVal Value As String)
    _description = Value
   End Set
  End Property

  Public Property InvoiceId() As Integer
   Get
    Return _invoiceId
   End Get
   Set(ByVal Value As Integer)
    _invoiceId = Value
   End Set
  End Property

  Public Property PriceBuy() As Decimal
   Get
    Return _priceBuy
   End Get
   Set(ByVal Value As Decimal)
    _priceBuy = Value
   End Set
  End Property

  Public Property PriceSell() As Decimal
   Get
    Return _priceSell
   End Get
   Set(ByVal Value As Decimal)
    _priceSell = Value
   End Set
  End Property

  Public Property ProjectId() As Integer
   Get
    Return _projectId
   End Get
   Set(ByVal Value As Integer)
    _projectId = Value
   End Set
  End Property

  Public Property Quantity() As Decimal
   Get
    Return _quantity
   End Get
   Set(ByVal Value As Decimal)
    _quantity = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "ProductsController"
 Public Class ProductsController

  Public Function GetProducts(ByVal productsId As Integer) As ProductsInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetProducts(productsId), GetType(ProductsInfo)), ProductsInfo)

  End Function


  Public Function GetProductsByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProductsByInvoices(invoiceId, IncludeDeleted), GetType(ProductsInfo))

  End Function

  Public Function GetProductsByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProductsByProjects(projectId, IncludeDeleted), GetType(ProductsInfo))

  End Function

  Public Function GetProductsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProductsByAccounts(accountId, IncludeDeleted), GetType(ProductsInfo))

  End Function

  Public Function GetProductsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProductsByPortal(PortalId, IncludeDeleted), GetType(ProductsInfo))

  End Function

  Public Function GetProductsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProductsByUser(UserId, IncludeDeleted), GetType(ProductsInfo))

  End Function

  Public Function AddProducts(ByVal objProducts As ProductsInfo) As Integer

   Return CType(DataProvider.Instance().AddProducts(objProducts.Category, objProducts.Comments, objProducts.DateDelivered, objProducts.Deleted, objProducts.Description, objProducts.InvoiceId, objProducts.PriceBuy, objProducts.PriceSell, objProducts.ProjectId, objProducts.Quantity), Integer)

  End Function

  Public Sub UpdateProducts(ByVal objProducts As ProductsInfo)

   DataProvider.Instance().UpdateProducts(objProducts.ProductsId, objProducts.Category, objProducts.Comments, objProducts.DateDelivered, objProducts.Deleted, objProducts.Description, objProducts.InvoiceId, objProducts.PriceBuy, objProducts.PriceSell, objProducts.ProjectId, objProducts.Quantity)

  End Sub

  Public Sub DeleteProducts(ByVal productsId As Integer)

   DataProvider.Instance().DeleteProducts(productsId)

  End Sub

 End Class
#End Region


#Region "ProjectsInfo"
 Public Class ProjectsInfo

  ' local property declarations
  Dim _projectId As Integer
  Dim _accountId As Integer
  Dim _budget As Decimal
  Dim _deleted As Boolean
  Dim _description As String
  Dim _projectName As String
  Dim _projectType As String

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal projectId As Integer, ByVal accountId As Integer, ByVal budget As Decimal, ByVal deleted As Boolean, ByVal description As String, ByVal projectName As String, ByVal projectType As String)
   Me.AccountId = accountId
   Me.Budget = budget
   Me.Deleted = deleted
   Me.Description = description
   Me.ProjectId = projectId
   Me.ProjectName = projectName
   Me.ProjectType = projectType
  End Sub
#End Region

#Region "Public Properties"
  Public Property ProjectId() As Integer
   Get
    Return _projectId
   End Get
   Set(ByVal Value As Integer)
    _projectId = Value
   End Set
  End Property

  Public Property AccountId() As Integer
   Get
    Return _accountId
   End Get
   Set(ByVal Value As Integer)
    _accountId = Value
   End Set
  End Property

  Public Property Budget() As Decimal
   Get
    Return _budget
   End Get
   Set(ByVal Value As Decimal)
    _budget = Value
   End Set
  End Property

  Public Property Deleted() As Boolean
   Get
    Return _deleted
   End Get
   Set(ByVal Value As Boolean)
    _deleted = Value
   End Set
  End Property

  Public Property Description() As String
   Get
    Return _description
   End Get
   Set(ByVal Value As String)
    _description = Value
   End Set
  End Property

  Public Property ProjectName() As String
   Get
    Return _projectName
   End Get
   Set(ByVal Value As String)
    _projectName = Value
   End Set
  End Property

  Public Property ProjectType() As String
   Get
    Return _projectType
   End Get
   Set(ByVal Value As String)
    _projectType = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "ProjectsController"
 Public Class ProjectsController

  Public Function GetProjects(ByVal projectId As Integer) As ProjectsInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetProjects(projectId), GetType(ProjectsInfo)), ProjectsInfo)

  End Function


  Public Function GetProjectsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProjectsByAccounts(accountId, IncludeDeleted), GetType(ProjectsInfo))

  End Function

  Public Function GetProjectsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProjectsByPortal(PortalId, IncludeDeleted), GetType(ProjectsInfo))

  End Function

  Public Function GetProjectsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProjectsByUser(UserId, IncludeDeleted), GetType(ProjectsInfo))

  End Function

  Public Function AddProjects(ByVal objProjects As ProjectsInfo) As Integer

   Return CType(DataProvider.Instance().AddProjects(objProjects.AccountId, objProjects.Budget, objProjects.Deleted, objProjects.Description, objProjects.ProjectName, objProjects.ProjectType), Integer)

  End Function

  Public Sub UpdateProjects(ByVal objProjects As ProjectsInfo)

   DataProvider.Instance().UpdateProjects(objProjects.ProjectId, objProjects.AccountId, objProjects.Budget, objProjects.Deleted, objProjects.Description, objProjects.ProjectName, objProjects.ProjectType)

  End Sub

  Public Sub DeleteProjects(ByVal projectId As Integer)

   DataProvider.Instance().DeleteProjects(projectId)

  End Sub

  Public Function GetProjectsByClient(ByVal ClientUserID As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetProjectsByClient(ClientUserID), GetType(ProjectsInfo))

  End Function

 End Class
#End Region


#Region "TasksInfo"
 Public Class TasksInfo

  ' local property declarations
  Dim _taskId As Integer
  Dim _comments As String
  Dim _deleted As Boolean
  Dim _description As String
  Dim _employeeId As Integer
  Dim _invoiceId As Integer
  Dim _projectId As Integer
  Dim _tariff As Decimal
  Dim _taskDate As Date
  Dim _taskHeading As String
  Dim _taskTime As Decimal
  Dim _taskTimeBilled As Decimal

#Region "Constructors"
  Public Sub New()
  End Sub

  Public Sub New(ByVal taskId As Integer, ByVal comments As String, ByVal deleted As Boolean, ByVal description As String, ByVal employeeId As Integer, ByVal invoiceId As Integer, ByVal projectId As Integer, ByVal tariff As Decimal, ByVal taskDate As Date, ByVal taskHeading As String, ByVal taskTime As Decimal, ByVal taskTimeBilled As Decimal)
   Me.Comments = comments
   Me.Deleted = deleted
   Me.Description = description
   Me.EmployeeId = employeeId
   Me.InvoiceId = invoiceId
   Me.ProjectId = projectId
   Me.Tariff = tariff
   Me.TaskDate = taskDate
   Me.TaskHeading = taskHeading
   Me.TaskId = taskId
   Me.TaskTime = taskTime
   Me.TaskTimeBilled = taskTimeBilled
  End Sub
#End Region

#Region "Public Properties"
  Public Property TaskId() As Integer
   Get
    Return _taskId
   End Get
   Set(ByVal Value As Integer)
    _taskId = Value
   End Set
  End Property

  Public Property Comments() As String
   Get
    Return _comments
   End Get
   Set(ByVal Value As String)
    _comments = Value
   End Set
  End Property

  Public Property Deleted() As Boolean
   Get
    Return _deleted
   End Get
   Set(ByVal Value As Boolean)
    _deleted = Value
   End Set
  End Property

  Public Property Description() As String
   Get
    Return _description
   End Get
   Set(ByVal Value As String)
    _description = Value
   End Set
  End Property

  Public Property EmployeeId() As Integer
   Get
    Return _employeeId
   End Get
   Set(ByVal Value As Integer)
    _employeeId = Value
   End Set
  End Property

  Public Property InvoiceId() As Integer
   Get
    Return _invoiceId
   End Get
   Set(ByVal Value As Integer)
    _invoiceId = Value
   End Set
  End Property

  Public Property ProjectId() As Integer
   Get
    Return _projectId
   End Get
   Set(ByVal Value As Integer)
    _projectId = Value
   End Set
  End Property

  Public Property Tariff() As Decimal
   Get
    Return _tariff
   End Get
   Set(ByVal Value As Decimal)
    _tariff = Value
   End Set
  End Property

  Public Property TaskDate() As Date
   Get
    Return _taskDate
   End Get
   Set(ByVal Value As Date)
    _taskDate = Value
   End Set
  End Property

  Public Property TaskHeading() As String
   Get
    Return _taskHeading
   End Get
   Set(ByVal Value As String)
    _taskHeading = Value
   End Set
  End Property

  Public Property TaskTime() As Decimal
   Get
    Return _taskTime
   End Get
   Set(ByVal Value As Decimal)
    _taskTime = Value
   End Set
  End Property

  Public Property TaskTimeBilled() As Decimal
   Get
    Return _taskTimeBilled
   End Get
   Set(ByVal Value As Decimal)
    _taskTimeBilled = Value
   End Set
  End Property
#End Region
 End Class
#End Region

#Region "TasksController"
 Public Class TasksController

  Public Function GetTasks(ByVal taskId As Integer) As TasksInfo

   Return CType(DotNetNuke.Common.Utilities.CBO.FillObject(DataProvider.Instance().GetTasks(taskId), GetType(TasksInfo)), TasksInfo)

  End Function


  Public Function GetTasksByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetTasksByInvoices(invoiceId, IncludeDeleted), GetType(TasksInfo))

  End Function

  Public Function GetTasksByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetTasksByProjects(projectId, IncludeDeleted), GetType(TasksInfo))

  End Function

  Public Function GetTasksByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetTasksByAccounts(accountId, IncludeDeleted), GetType(TasksInfo))

  End Function

  Public Function GetTasksByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetTasksByPortal(PortalId, IncludeDeleted), GetType(TasksInfo))

  End Function

  Public Function GetTasksByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetTasksByUser(UserId, IncludeDeleted), GetType(TasksInfo))

  End Function

  Public Function AddTasks(ByVal objTasks As TasksInfo) As Integer

   Return CType(DataProvider.Instance().AddTasks(objTasks.Comments, objTasks.Deleted, objTasks.Description, objTasks.EmployeeId, objTasks.InvoiceId, objTasks.ProjectId, objTasks.Tariff, objTasks.TaskDate, objTasks.TaskHeading, objTasks.TaskTime, objTasks.TaskTimeBilled), Integer)

  End Function

  Public Sub UpdateTasks(ByVal objTasks As TasksInfo)

   DataProvider.Instance().UpdateTasks(objTasks.TaskId, objTasks.Comments, objTasks.Deleted, objTasks.Description, objTasks.EmployeeId, objTasks.InvoiceId, objTasks.ProjectId, objTasks.Tariff, objTasks.TaskDate, objTasks.TaskHeading, objTasks.TaskTime, objTasks.TaskTimeBilled)

  End Sub

  Public Sub DeleteTasks(ByVal taskId As Integer)

   DataProvider.Instance().DeleteTasks(taskId)

  End Sub

 End Class
#End Region

#Region "DocumentInfo"
    'Module enhancement (document functionalities) added 8/2006
    Public Class DocumentInfo

#Region "Private Members"

        Private _ItemId As Integer
        Private _AccountId As Integer
        Private _ModuleId As Integer
        Private _CreatedByUser As String
        Private _CreatedDate As Date
        Private _Url As String
        Private _Title As String
        Private _Category As String
        Private _Size As Integer
        Private _ContentType As String
        Private _TrackClicks As Boolean
        Private _NewWindow As Boolean

#End Region

#Region "Contructors"

        Public Sub New()
        End Sub

#End Region

#Region "Properties"

        ' public properties
        Public Property ItemId() As Integer
            Get
                Return _ItemId
            End Get
            Set(ByVal Value As Integer)
                _ItemId = Value
            End Set
        End Property

        Public Property AccountId() As Integer
            Get
                Return _AccountId
            End Get
            Set(ByVal Value As Integer)
                _AccountId = Value
            End Set
        End Property

        Public Property ModuleId() As Integer
            Get
                Return _ModuleId
            End Get
            Set(ByVal Value As Integer)
                _ModuleId = Value
            End Set
        End Property

        Public Property CreatedByUser() As String
            Get
                Return _CreatedByUser
            End Get
            Set(ByVal Value As String)
                _CreatedByUser = Value
            End Set
        End Property

        Public Property CreatedDate() As Date
            Get
                Return _CreatedDate
            End Get
            Set(ByVal Value As Date)
                _CreatedDate = Value
            End Set
        End Property

        Public Property Url() As String
            Get
                Return _Url
            End Get
            Set(ByVal Value As String)
                _Url = Value
            End Set
        End Property

        Public Property Title() As String
            Get
                Return _Title
            End Get
            Set(ByVal Value As String)
                _Title = Value
            End Set
        End Property

        Public Property Category() As String
            Get
                Return _Category
            End Get
            Set(ByVal Value As String)
                _Category = Value
            End Set
        End Property

        Public Property Size() As Integer
            Get
                Return _Size
            End Get
            Set(ByVal Value As Integer)
                _Size = Value
            End Set
        End Property

        Public Property ContentType() As String
            Get
                Return _ContentType
            End Get
            Set(ByVal Value As String)
                _ContentType = Value
            End Set
        End Property

        Public Property TrackClicks() As Boolean
            Get
                Return _TrackClicks
            End Get
            Set(ByVal Value As Boolean)
                _TrackClicks = Value
            End Set
        End Property

        Public Property NewWindow() As Boolean
            Get
                Return _NewWindow
            End Get
            Set(ByVal Value As Boolean)
                _NewWindow = Value
            End Set
        End Property

#End Region

    End Class
#End Region

#Region "DocumentController"
    'Module enhancement (document functionalities) added 8/2006
    Public Class DocumentController

#Region "Public Methods"

        Public Sub AddDocument(ByVal objDocument As DocumentInfo)

            DataProvider.Instance().AddDocument(objDocument.AccountId, objDocument.ModuleId, objDocument.Title, objDocument.Url, objDocument.CreatedByUser, objDocument.Category)

        End Sub

        Public Sub DeleteDocument(ByVal ItemID As Integer)

            DataProvider.Instance().DeleteDocument(ItemID)

        End Sub

        Public Function GetDocument(ByVal ItemId As Integer, ByVal ModuleId As Integer) As DocumentInfo


            Return CType(CBO.FillObject(DataProvider.Instance().GetDocument(ItemId, ModuleId), GetType(DocumentInfo)), DocumentInfo)

        End Function

        Public Function GetDocuments(ByVal AccountId As Integer, ByVal ModuleId As Integer) As ArrayList

            Return CBO.FillCollection(DataProvider.Instance().GetDocuments(AccountId, ModuleId), GetType(DocumentInfo))

        End Function


        Public Sub UpdateDocument(ByVal objDocument As DocumentInfo)

            DataProvider.Instance().UpdateDocument(objDocument.ItemId, objDocument.Title, objDocument.Url, objDocument.CreatedByUser, objDocument.Category)

        End Sub

#End Region

#Region "Optional Interfaces"


#End Region

    End Class
#End Region

End Namespace
