'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditIssue
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents ddlProject As System.Web.UI.WebControls.DropDownList
  Protected WithEvents txtIssueHeading As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtDiscourse As System.Web.UI.WebControls.TextBox
  Protected WithEvents chkResolved As System.Web.UI.WebControls.CheckBox
  Protected WithEvents hlTask As System.Web.UI.WebControls.HyperLink
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtUrgency As System.Web.UI.WebControls.TextBox
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents txtDate As System.Web.UI.WebControls.TextBox
  Protected WithEvents valDate As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents valDate2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents imgDate As System.Web.UI.HtmlControls.HtmlImage
  Protected WithEvents txtDateResolved As System.Web.UI.WebControls.TextBox
  Protected WithEvents Comparevalidator2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents imgDateResolved As System.Web.UI.HtmlControls.HtmlImage

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim IssueId As Integer = -1
  Private AccountId As Integer = -1
  Private ProjectId As Integer = -1

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objCtlIssues As New IssuesController
   Dim objIssue As New IssuesInfo

   If Not (Request.Params("IssueId") Is Nothing) Then
    IssueId = Int32.Parse(Request.Params("IssueId"))
   Else
    IssueId = -1
   End If
   ' Determine AccountId
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If
   ' Determine ProjectId
   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objProjects As New ProjectsController
    Dim objAccounts As New AccountsController
    If IssueId <> -1 Then
     objIssue = objCtlIssues.GetIssues(IssueId)
     ProjectId = objIssue.ProjectId
     AccountId = objProjects.GetProjects(ProjectId).AccountId
    Else
     If ProjectId <> -1 Then
      AccountId = objProjects.GetProjects(ProjectId).AccountId
     Else
      If AccountId = -1 Then
       UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
       Exit Sub
      End If
     End If
    End If
    Me.ViewState.Item("AccountId") = AccountId
    Me.ViewState.Item("ProjectId") = ProjectId

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If
    If Not Security.IsEmployee Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    imgDate.Attributes.Add("onclick", "popUpCalendar(this, " & txtDate.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDate.Src = IWorkPath & "ew_calendar.gif"
    If Not Me.Page.IsClientScriptBlockRegistered("PopCalendar") Then
     Dim sr As New IO.StreamReader(Server.MapPath(IWorkPath & "popcalendar.js"))
     Dim CalScript As String = sr.ReadToEnd
     CalScript = CalScript.Replace("[IMAGEDIRECTORY]", IWorkPath)
     sr.Close()
     Page.RegisterClientScriptBlock("PopCalendar", "<script language='javascript'>" & CalScript & "</script>")
    End If
    imgDateResolved.Attributes.Add("onclick", "popUpCalendar(this, " & txtDateResolved.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDateResolved.Src = IWorkPath & "ew_calendar.gif"
    lblAccountName.Text = objAccounts.GetAccounts(AccountId, PortalId).AccountName
    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
    ddlProject.DataSource = objProjects.GetProjectsByAccounts(AccountId, False)
    ddlProject.DataBind()
    'Dim objUsers As New DotNetNuke.Entities.Users.UserController
    If IssueId <> -1 Then
     If Not objIssue Is Nothing Then
      'Load data
      With objIssue
       txtIssueHeading.Text = .IssueHeading
       txtDiscourse.Text = .Discourse
       chkResolved.Checked = .Resolved
       hlTask.Text = "task"
       ddlProject.SelectedValue = .ProjectId
       txtDate.Text = .IssueDate.ToShortDateString
       txtUrgency.Text = .IssueUrgency.ToString
       If .Resolved Then
        txtDateResolved.Text = .ResolvedDate.ToShortDateString
        txtDateResolved.Enabled = True
       Else
        txtDateResolved.Enabled = False
        imgDateResolved.Visible = False
       End If
      End With
      If Security.IsAdmin Then
       cmdDelete.Visible = True
      End If
     Else ' security violation attempt to access item not related to this Module
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else
     'new record
     txtDate.Text = Now.ToShortDateString
     txtUrgency.Text = "5"
    End If
   End If

  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid

    If Page.IsValid = True Then
     Dim objIssues As New IssuesInfo

     'bind text values to object
     With objIssues
      .IssueId = IssueId
      .Discourse = txtDiscourse.Text
      .IssueHeading = txtIssueHeading.Text
      .Resolved = chkResolved.Checked
      .ProjectId = ddlProject.SelectedValue
      .IssueUrgency = CType(txtUrgency.Text, Integer)
      .IssueDate = Convert.ToDateTime(txtDate.Text)
      If chkResolved.Checked Then
       .ResolvedDate = Convert.ToDateTime(txtDateResolved.Text)
      End If
     End With

     Dim objCtlIssues As New IssuesController
     If IssueId = -1 Then
      IssueId = objCtlIssues.AddIssues(objIssues)
     Else
      objCtlIssues.UpdateIssues(objIssues)
     End If

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("IssueId", IssueId.ToString, "ViewIssue"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If IssueId = -1 Then
     If Me.ViewState.Item("ProjectId") = -1 Then
      Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
     Else
      Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
     End If
    Else
     Response.Redirect(EditUrl("IssueId", IssueId.ToString, "ViewIssue"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not IssueId = -1 Then
     Dim objCtlIssues As New IssuesController
     objCtlIssues.DeleteIssues(IssueId)
    End If

    If ProjectId = -1 Then
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    Else
     Response.Redirect(EditUrl("ProjectId", ProjectId.ToString, "ViewProject"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub chkResolved_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkResolved.CheckedChanged
   Dim chkBox As CheckBox = CType(sender, CheckBox)
   If chkBox.Checked Then
    txtDateResolved.Enabled = True
    imgDateResolved.Visible = True
   Else
    txtDateResolved.Enabled = False
    imgDateResolved.Visible = False
   End If
  End Sub
 End Class
End Namespace
