'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditProject
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents txtProjectName As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtProjectType As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtDescription As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtBudget As System.Web.UI.WebControls.TextBox
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Private ProjectId As Integer = -1
  Private AccountId As Integer = -1

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objProjects As New ProjectsController
   Dim objProject As New ProjectsInfo

   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objAccounts As New AccountsController
    If ProjectId = -1 Then
     If AccountId = -1 Then
      UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else
     objProject = objProjects.GetProjects(ProjectId)
     AccountId = objProject.AccountId
    End If
    Me.ViewState.Item("AccountId") = AccountId

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If
    If Not Security.IsEmployee Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    lblAccountName.Text = objAccounts.GetAccounts(AccountId, PortalId).AccountName
    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
    If ProjectId <> -1 Then
     If Not objProject Is Nothing Then
      txtProjectName.Text = objProject.ProjectName
      txtProjectType.Text = objProject.ProjectType
      txtDescription.Text = objProject.Description
      txtBudget.Text = objProject.Budget.ToString("0.00")
     Else ' security violation attempt to access item not related to this Module
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
     If Security.IsAdmin Then
      cmdDelete.Visible = True
      If objProject.Deleted Then
       cmdDelete.Text = "Undelete"
       cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Undelete This Item ?');")
      Else
       cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
      End If
     End If
    Else
     txtBudget.Text = "0"
    End If
   End If
  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid

    If Page.IsValid = True Then
     Dim objProject As New ProjectsInfo

     'objIWork = CType(CBO.InitializeObject(objIWork, GetType(IWorkInfo)), IWorkInfo)

     'bind text values to object
     With objProject
      .ProjectId = ProjectId
      .AccountId = Me.ViewState.Item("AccountId")
      .Description = txtDescription.Text
      .ProjectType = txtProjectType.Text
      .ProjectName = txtProjectName.Text
      .Budget = CType(txtBudget.Text, Decimal)
     End With

     Dim objProjects As New ProjectsController
     If ProjectId = -1 Then
      ProjectId = objProjects.AddProjects(objProject)
     Else
      objProjects.UpdateProjects(objProject)
     End If

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("ProjectId", ProjectId.ToString, "ViewProject"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub


  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If ProjectId = -1 Then
     If Me.ViewState.Item("AccountId") = -1 Then
      Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
     Else
      Response.Redirect(EditUrl("AccountId", Me.ViewState.Item("AccountId").ToString, "ViewAccount"), True)
     End If
    Else
     Response.Redirect(EditUrl("ProjectId", ProjectId.ToString, "ViewProject"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not ProjectId = -1 Then
     'first make sure there are no open issues left
     Dim objIssues As New IssuesController
     Dim objIssue As IssuesInfo
     For Each objIssue In objIssues.GetIssuesByProjects(ProjectId)
      If Not objIssue.Resolved Then
       objIssue.Resolved = True
       objIssue.ResolvedDate = Now
       objIssues.UpdateIssues(objIssue)
      End If
     Next
     'now delete the project
     Dim objProjects As New ProjectsController
     Dim objProject As ProjectsInfo = objProjects.GetProjects(ProjectId)
     If objProject.Deleted Then
      objProject.Deleted = False
     Else
      objProject.Deleted = True
     End If
     objProjects.UpdateProjects(objProject)
    End If

    ' Redirect back to the portal home page
    If Me.ViewState.Item("AccountId") = -1 Then
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    Else
     Response.Redirect(EditUrl("AccountId", Me.ViewState.Item("AccountId").ToString, "ViewAccount"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub
 End Class

End Namespace
