'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class IWorkOptions
  Inherits DotNetNuke.Entities.Modules.ModuleSettingsBase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

#Region " Controls "
  Protected WithEvents cboMgtRole As System.Web.UI.WebControls.DropDownList
  Protected WithEvents cboClientRole As System.Web.UI.WebControls.DropDownList
  Protected WithEvents cboEmplRole As System.Web.UI.WebControls.DropDownList
#End Region

#Region " Base Method Implementations "
  Public Overrides Sub LoadSettings()

   Dim ObjRoles As New DotNetNuke.Security.Roles.RoleController
   Dim ms As New ModuleSettings(ModuleId)

   cboClientRole.DataSource = ObjRoles.GetPortalRoles(PortalId)
   cboClientRole.DataBind()
   cboClientRole.Items.Insert(0, New Web.UI.WebControls.ListItem("<None Specified>", "-1"))
   cboEmplRole.DataSource = ObjRoles.GetPortalRoles(PortalId)
   cboEmplRole.DataBind()
   cboEmplRole.Items.Insert(0, New Web.UI.WebControls.ListItem("<None Specified>", "-1"))
   cboMgtRole.DataSource = ObjRoles.GetPortalRoles(PortalId)
   cboMgtRole.DataBind()
   cboMgtRole.Items.Insert(0, New Web.UI.WebControls.ListItem("<None Specified>", "-1"))

   Try
    cboClientRole.Items.FindByValue(ms.ClientRole).Selected = True
   Catch ex As Exception
   End Try

   Try
    cboEmplRole.Items.FindByValue(ms.UserRole).Selected = True
   Catch ex As Exception
   End Try

   Try
    cboMgtRole.Items.FindByValue(ms.AdminRole).Selected = True
   Catch ex As Exception
   End Try

  End Sub

  Public Overrides Sub UpdateSettings()

   Dim ms As New ModuleSettings(ModuleId)
   With ms
    .AdminRole = Integer.Parse(cboMgtRole.SelectedValue)
    .ClientRole = Integer.Parse(cboClientRole.SelectedValue)
    .UserRole = Integer.Parse(cboEmplRole.SelectedValue)
    .SaveSettings()
   End With

   Dim CacheKey As String = "Settings4Module" & Me.ModuleId & "inPortal" & Me.PortalId
   Me.Cache.Remove(CacheKey)

  End Sub
#End Region

 End Class

End Namespace
