'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ViewProject
  Inherits PortalModuleBase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblProjectName As System.Web.UI.WebControls.Label
  Protected WithEvents lblDescription As System.Web.UI.WebControls.Label
  Protected WithEvents hlEditProject As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlIssues As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgIssues As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlProducts As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgProducts As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlTasks As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgTasks As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlProject As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlTasks As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlProducts As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlIssues As System.Web.UI.WebControls.Panel
  Protected WithEvents lblAccount As System.Web.UI.WebControls.Label
  Protected WithEvents lblProjectType As System.Web.UI.WebControls.Label
  Protected WithEvents hlAddIssue As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlAddTask As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlAddProduct As System.Web.UI.WebControls.HyperLink

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()

   'prefer to do it via the regular window pane after all
   'If IsEmployee(Me.Settings, Me.Context) Then
   ' MyBase.Actions.Add(GetNextActionID, "Add Issue", "", URL:=EditURL("ProjectId", Request.Params("ProjectId"), "EditIssue"), secure:=SecurityAccessLevel.View, Visible:=True)
   ' MyBase.Actions.Add(GetNextActionID, "Add Product", "", URL:=EditURL("ProjectId", Request.Params("ProjectId"), "EditProduct"), secure:=SecurityAccessLevel.Edit, Visible:=True)
   ' MyBase.Actions.Add(GetNextActionID, "Add Task", "", URL:=EditURL("ProjectId", Request.Params("ProjectId"), "EditTask"), secure:=SecurityAccessLevel.Edit, Visible:=True)
   'End If
  End Sub

#End Region

  Dim ProjectId As Integer = -1
  Public IsAnEmployee As Boolean

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objProjects As New ProjectsController
   Dim objProject As New ProjectsInfo

   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   objProject = objProjects.GetProjects(ProjectId)
   If Not Security.OK2View(objProject.AccountId) Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If
   If Security.IsEmployee Then
    IsAnEmployee = True
    hlAddProduct.Visible = True
    hlAddTask.Visible = True
   Else
    hlEditProject.Visible = False
    IsAnEmployee = False
    hlAddProduct.Visible = False
    hlAddTask.Visible = False
   End If

   hlEditProject.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "EditProject")

   If Not Page.IsPostBack Then
    If Not objProject Is Nothing Then
     Dim objAccounts As New AccountsController
     Dim objAccount As AccountsInfo = objAccounts.GetAccounts(objProject.AccountId, PortalId)
     hlIssues.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "ListIssues")
     hlProducts.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "ListProducts")
     hlTasks.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "ListTasks")
     hlAddIssue.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "AddIssue")
     hlAddProduct.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "EditProduct")
     hlAddTask.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "EditTask")

     lblAccount.Text = objAccount.AccountName
     lblProjectName.Text = objProject.ProjectName
     hlBack.Text = "Back to " & objAccount.AccountName & " account"
     hlBack.NavigateUrl = EditUrl("AccountId", objAccount.AccountId.ToString, "ViewAccount")
     lblProjectType.Text = objProject.ProjectType
     lblDescription.Text = objProject.Description

     BindGrids()
    Else ' no id
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    End If
   End If

  End Sub

  Private Sub dgTasks_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles dgTasks.PageIndexChanged
   dgTasks.CurrentPageIndex = e.NewPageIndex
   BindGrids()
  End Sub

  Private Sub dgProducts_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles dgProducts.PageIndexChanged
   dgProducts.CurrentPageIndex = e.NewPageIndex
   BindGrids()
  End Sub

  Private Sub dgIssues_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles dgIssues.PageIndexChanged
   dgIssues.CurrentPageIndex = e.NewPageIndex
   BindGrids()
  End Sub

  Private Sub BindGrids()
   Dim dvIssues As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetIssuesByProjects(ProjectId)))
   dvIssues.Sort = "Resolved, IssueId"
   dgIssues.DataSource = dvIssues
   dgIssues.DataBind()

   Dim dvProducts As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProductsByProjects(ProjectId, False)))
   dvProducts.Sort = "DateDelivered DESC"
   dgProducts.DataSource = dvProducts
   dgProducts.DataBind()

   Dim dvTasks As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByProjects(ProjectId, False)))
   dvTasks.Sort = "TaskDate DESC"
   dgTasks.DataSource = dvTasks
   dgTasks.DataBind()
  End Sub

 End Class

End Namespace
