Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork
 Public Class Query

#Region " Private Members "
  Private _accountId As Integer = -1
  Private _projectId As Integer = -1
  Private _invoiceId As Integer = -1
  Private _issueId As Integer = -1
  Private _productId As Integer = -1
  Private _taskId As Integer = -1
#End Region

#Region " Public Members "
  Public RequestedAccount As AccountsInfo
  Public RequestedProject As ProjectsInfo
  Public RequestedInvoice As InvoicesInfo
  Public RequestedIssue As IssuesInfo
  Public RequestedProduct As ProductsInfo
  Public RequestedTask As TasksInfo
#End Region

#Region " Properties "
  Public ReadOnly Property TaskId() As Integer
   Get
    Return _taskId
   End Get
  End Property

  Public ReadOnly Property ProductId() As Integer
   Get
    Return _productId
   End Get
  End Property

  Public ReadOnly Property IssueId() As Integer
   Get
    Return _issueId
   End Get
  End Property

  Public ReadOnly Property InvoiceId() As Integer
   Get
    Return _invoiceId
   End Get
  End Property

  Public ReadOnly Property ProjectId() As Integer
   Get
    Return _projectId
   End Get
  End Property

  Public ReadOnly Property AccountId() As Integer
   Get
    Return _accountId
   End Get
  End Property
#End Region

#Region " Public Methods "
  Public Sub New(ByVal Request As HttpRequest, ByVal PortalId As Integer, ByVal Security As Security)
   Dim objAccounts As New AccountsController
   Dim objProjects As New ProjectsController
   Dim objInvoices As New InvoicesController
   Dim objIssues As New IssuesController
   Dim objProducts As New ProductsController
   Dim objTasks As New TasksController

   If Not Request.Params("AccountId") Is Nothing Then
    _accountId = Integer.Parse(Request.Params("AccountId"))
    If Security.OK2View(_accountId) Then
     RequestedAccount = objAccounts.GetAccounts(_accountId, PortalId)
    Else
     _accountId = -1
     Exit Sub
    End If
   End If

   If Not Request.Params("ProjectId") Is Nothing Then
    _projectId = Integer.Parse(Request.Params("ProjectId"))
    RequestedProject = objProjects.GetProjects(_projectId)
   End If

   If Not Request.Params("InvoiceId") Is Nothing Then
    _invoiceId = Integer.Parse(Request.Params("InvoiceId"))
    RequestedInvoice = objInvoices.GetInvoices(_invoiceId)
   End If

   If Not Request.Params("IssueId") Is Nothing Then
    _issueId = Integer.Parse(Request.Params("IssueId"))
    RequestedIssue = objIssues.GetIssues(_issueId)
   End If

   If Not Request.Params("ProductId") Is Nothing Then
    _productId = Integer.Parse(Request.Params("ProductId"))
    RequestedProduct = objProducts.GetProducts(_productId)
   End If

   If Not Request.Params("TaskId") Is Nothing Then
    _taskId = Integer.Parse(Request.Params("TaskId"))
    RequestedTask = objTasks.GetTasks(_taskId)
   End If

  End Sub

  Public Function IWorkUrl(ByVal TabId As Integer, ByVal ControlKey As String, Optional ByVal AccountId As Integer = -1, Optional ByVal ProjectId As Integer = -1, Optional ByVal InvoiceId As Integer = -1, Optional ByVal IssueId As Integer = -1, Optional ByVal ProductId As Integer = -1, Optional ByVal TaskId As Integer = -1) As String
   Dim params As New ArrayList
   If AccountId > -1 Then
    params.Add("AccountId=" & AccountId.ToString)
   End If
   If ProjectId > -1 Then
    params.Add("ProjectId=" & ProjectId.ToString)
   End If
   If InvoiceId > -1 Then
    params.Add("InvoiceId=" & InvoiceId.ToString)
   End If
   If IssueId > -1 Then
    params.Add("IssueId=" & IssueId.ToString)
   End If
   If ProductId > -1 Then
    params.Add("ProductId=" & ProductId.ToString)
   End If
   If TaskId > -1 Then
    params.Add("TaskId=" & TaskId.ToString)
   End If
   Dim s As String() = params.ToArray(GetType(String))
   Return DotNetNuke.Common.NavigateURL(TabId, ControlKey, s)
  End Function
#End Region
 End Class
End Namespace