'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditProduct
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents txtProductHeading As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtCategory As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtPriceBuy As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtPriceSell As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtComments As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtQuantity As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator1 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents Requiredfieldvalidator3 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents Requiredfieldvalidator4 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents ddlProject As System.Web.UI.WebControls.DropDownList
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents Comparevalidator2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents Comparevalidator3 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents txtDate As System.Web.UI.WebControls.TextBox
  Protected WithEvents valDate As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents valDate2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents imgDate As System.Web.UI.HtmlControls.HtmlImage

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim ProductId As Integer = -1
  Dim AccountId As Integer = -1
  Dim ProjectId As Integer = -1

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objProducts As New ProductsController
   Dim objProduct As New ProductsInfo

   If Not (Request.Params("ProductId") Is Nothing) Then
    ProductId = Int32.Parse(Request.Params("ProductId"))
   Else
    ProductId = -1
   End If
   ' Determine AccountId
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If
   ' Determine ProjectId
   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objProjects As New ProjectsController
    Dim objAccounts As New AccountsController
    If ProductId <> -1 Then
     objProduct = objProducts.GetProducts(ProductId)
     ProjectId = objProduct.ProjectId
     AccountId = objProjects.GetProjects(ProjectId).AccountId
    Else
     If ProjectId <> -1 Then
      AccountId = objProjects.GetProjects(ProjectId).AccountId
     Else
      UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    End If
    Me.ViewState.Item("AccountId") = AccountId
    Me.ViewState.Item("ProjectId") = ProjectId

    ddlProject.DataSource = objProjects.GetProjectsByAccounts(AccountId, False)
    ddlProject.DataBind()

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If
    If Not Security.IsEmployee Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    imgDate.Attributes.Add("onclick", "popUpCalendar(this, " & txtDate.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDate.Src = IWorkPath & "ew_calendar.gif"
    If Not Me.Page.IsClientScriptBlockRegistered("PopCalendar") Then
     Dim sr As New IO.StreamReader(Server.MapPath(IWorkPath & "popcalendar.js"))
     Dim CalScript As String = sr.ReadToEnd
     CalScript = CalScript.Replace("[IMAGEDIRECTORY]", IWorkPath)
     sr.Close()
     Page.RegisterClientScriptBlock("PopCalendar", "<script language='javascript'>" & CalScript & "</script>")
    End If
    lblAccountName.Text = objAccounts.GetAccounts(AccountId, PortalId).AccountName
    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
    If ProductId <> -1 Then
     If Not objProduct Is Nothing Then
      txtProductHeading.Text = objProduct.Description
      txtCategory.Text = objProduct.Category
      txtQuantity.Text = objProduct.Quantity.ToString("0.0")
      txtPriceBuy.Text = objProduct.PriceBuy.ToString("0.00")
      txtPriceSell.Text = objProduct.PriceSell.ToString("0.00")
      txtComments.Text = objProduct.Comments
      txtDate.Text = objProduct.DateDelivered.ToShortDateString
      ddlProject.SelectedValue = objProduct.ProjectId
      Me.ViewState.Item("InvoiceId") = objProduct.InvoiceId
      'check if it has been billed already (we can't change something which has already been billed)
      Dim objInvoices As New InvoicesController
      If objProduct.InvoiceId > 0 Then
       Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(objProduct.InvoiceId)
       If Not objInvoice Is Nothing Then
        If objInvoice.Sent Then
         txtProductHeading.Enabled = False
         txtCategory.Enabled = False
         txtQuantity.Enabled = False
         txtPriceBuy.Enabled = False
         txtPriceSell.Enabled = False
         txtDate.Enabled = False
         'txtComments.Enabled = False
         cmdDelete.Visible = False
        End If
       End If
      End If
      If Security.IsAdmin Then
       cmdDelete.Visible = True
       If objProduct.Deleted Then
        cmdDelete.Text = "Undelete"
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Undelete This Item ?');")
       Else
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
       End If
      End If
     Else ' security violation attempt to access item not related to this Module
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else
     Me.ViewState.Item("InvoiceId") = 0
     If ProjectId <> -1 Then
      ddlProject.SelectedValue = ProjectId
     End If
     txtDate.Text = Now.ToShortDateString
    End If
   End If
  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid
    If Page.IsValid = True Then
     Dim objProduct As New ProductsInfo

     'bind text values to object
     With objProduct
      .ProductsId = ProductId
      .ProjectId = ddlProject.SelectedValue
      .Description = txtProductHeading.Text
      .Category = txtCategory.Text
      .Quantity = CType(txtQuantity.Text, Single)
      .Comments = txtComments.Text
      .DateDelivered = Convert.ToDateTime(txtDate.Text)
      .PriceBuy = CType(txtPriceBuy.Text, Single)
      .PriceSell = CType(txtPriceSell.Text, Single)
      .InvoiceId = Me.ViewState.Item("InvoiceId")
     End With

     If Me.ViewState.Item("InvoiceId") > 0 Then
      RecalcInvoice(Me.ViewState.Item("InvoiceId"))
     End If

     Dim objProducts As New ProductsController
     If ProductId = -1 Then
      ProductId = objProducts.AddProducts(objProduct)
     Else
      objProducts.UpdateProducts(objProduct)
     End If

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub


  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If Me.ViewState.Item("ProjectId") = -1 Then
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    Else
     Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not ProductId = -1 Then
     Dim objProducts As New ProductsController
     Dim objProduct As ProductsInfo = objProducts.GetProducts(ProductId)
     If objProduct.Deleted Then
      objProduct.Deleted = False
     Else
      objProduct.Deleted = True
     End If
     objProducts.UpdateProducts(objProduct)
    End If

    ' Redirect back to the portal home page
    Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

 End Class

End Namespace
