Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business
Imports System.Web.UI.WebControls
Imports DotNetNuke.Services.FileSystem
Imports DotNetNuke.Services.Localization
Imports DotNetNuke.Services.Exceptions

Namespace Bring2mind.DNN.Modules.IWork
    'Module enhancement (document functionalities) added 8/2006
    'based on the Document control from the core

    Public Class ListDocuments
        Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase

#Region "Controls"
        Protected WithEvents grdDocuments As System.Web.UI.WebControls.DataGrid
        Protected WithEvents hlAddDocument As System.Web.UI.WebControls.HyperLink
#End Region

#Region "Members"
        Private AccountId As Integer = -1
        Protected WithEvents pnlInvoices As System.Web.UI.WebControls.Panel
        Public IsAnEmployee As Boolean
#End Region

#Region "Public Methods"

        Function FormatSize(ByVal Size As Integer) As String
            Try
                If Not Common.Utilities.Null.IsNull(Size) Then
                    FormatSize = Format(Size / 1000, "#,##0.00")
                Else
                    FormatSize = Localization.GetString("Unknown")
                End If
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Function


        Function FormatURL(ByVal Link As String, ByVal TrackClicks As Boolean) As String

            Return Common.Globals.LinkClick(Link, TabId, ModuleId, TrackClicks)

        End Function

#End Region

#Region "Event Handlers"

        Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

            IsAnEmployee = Security.IsEmployee

            If Not Me.IsPostBack Then
                If Not (Request.Params("AccountId") Is Nothing) Then
                    AccountId = Int32.Parse(Request.Params("AccountId"))
                    If Security.OK2View(AccountId) Then

                        Dim objDocuments As New DocumentController
                        Dim objAccounts As New AccountsController
                        Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
                        lblAccountName.Text = "Documents for " & objAccount.AccountName
                        hlBack.Text = "Back to " & objAccount.AccountName & " account"
                        hlBack.NavigateUrl = EditUrl("AccountId", AccountId.ToString, "ViewAccount")
                        hlAddDocument.Visible = Security.IsEmployee
                        hlAddDocument.NavigateUrl = EditUrl("AccountId", Request.Params("AccountId"), "EditDocument")

                        Try


                            'Localize the Data Grid
                            Localization.LocalizeDataGrid(grdDocuments, Me.LocalResourceFile)

                            grdDocuments.DataSource = objDocuments.GetDocuments(AccountId, ModuleId)
                            grdDocuments.DataBind()

                        Catch exc As Exception    'Module failed to load
                            ProcessModuleLoadException(Me, exc)
                        End Try
                    Else
                        UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
                        Exit Sub
                    End If
                Else
                    If Security.IsAdmin Then
                        lblAccountName.Text = "Invoices"
                        hlBack.Text = "Back"
                        hlBack.NavigateUrl = DotNetNuke.Common.Globals.NavigateURL()

                    Else
                        UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
                        Exit Sub
                    End If
                End If
            End If
        End Sub

        Private Sub grdDocuments_EditCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles grdDocuments.EditCommand
            Try

                Dim strLink As String = ""

                Dim ItemId As Integer = Integer.Parse(Convert.ToString(grdDocuments.DataKeys(e.Item.ItemIndex)))

                Dim objDocuments As New DocumentController
                Dim objDocument As DocumentInfo = objDocuments.GetDocument(ItemId, ModuleId)
                If Not objDocument Is Nothing Then
                    strLink = Common.Globals.LinkClick(objDocument.Url, TabId, ModuleId, objDocument.TrackClicks, objDocument.ContentType)
                End If

                If strLink <> "" Then
                    Response.Redirect(strLink, True)
                End If
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Sub

        Private Sub grdDocuments_ItemCreated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataGridItemEventArgs) Handles grdDocuments.ItemCreated
            Try
                If e.Item.ItemType = ListItemType.Header Then
                    e.Item.Cells(1).Attributes.Add("Scope", "col")
                    e.Item.Cells(2).Attributes.Add("Scope", "col")
                    e.Item.Cells(3).Attributes.Add("Scope", "col")
                    e.Item.Cells(4).Attributes.Add("Scope", "col")
                    e.Item.Cells(5).Attributes.Add("Scope", "col")
                End If
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Sub
#End Region

#Region " Code gnr par le Concepteur Web Form "

        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

        End Sub

        Private designerPlaceholderDeclaration As System.Object
        Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
        Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label

        Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
            InitializeComponent()
        End Sub

#End Region


    End Class

End Namespace
