<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <xsl:param name="DownloadPath"/>
 <xsl:param name="Locale"/>
 <xsl:template match="/">
  <ul id="ourfiletree" class="treeview">
   <xsl:for-each select="FileCollection/Folder">
    <li>
     <span class="folder">
      <xsl:value-of select="@Name"/>
     </span>
     <xsl:call-template name="tree">
      <xsl:with-param name="fNode" select="."/>
     </xsl:call-template>
    </li>
   </xsl:for-each>
   <xsl:for-each select="FileCollection/File">
    <li>
     <span class="file">
      <a target="_blank">
       <xsl:attribute name="href"><xsl:value-of select="$DownloadPath"/>&amp;file=<xsl:value-of select="@AccessPath"/></xsl:attribute>
       <xsl:value-of select="@Name"/>
      </a>
     </span>
    </li>
   </xsl:for-each>
  </ul>
  <script type="text/javascript">
   $(document).ready(function(){$("#ourfiletree").treeview({animated:"fast", collapsed:true});});
  </script>
 </xsl:template>
 <xsl:template name="tree">
  <xsl:param name="fNode"/>
  <ul>
   <xsl:for-each select="$fNode/Folder">
    <li>
     <span class="folder">
      <xsl:value-of select="@Name"/>
     </span>
     <xsl:call-template name="tree">
      <xsl:with-param name="fNode" select="."/>
     </xsl:call-template>
    </li>
   </xsl:for-each>
   <xsl:for-each select="$fNode/File">
    <li>
     <span class="file">
      <a target="_blank">
       <xsl:attribute name="href"><xsl:value-of select="$DownloadPath"/>&amp;file=<xsl:value-of select="@AccessPath"/></xsl:attribute>
       <xsl:value-of select="@Name"/>
      </a>
     </span>
    </li>
   </xsl:for-each>
  </ul>
 </xsl:template>
</xsl:stylesheet>
