Imports System.Xml
Imports System.Text
Imports System.Collections.Generic
Imports System.IO

Imports DotNetNuke.Common.Utilities.XmlUtils
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Services.Search

Public Class SimpleDownloadsController
 Implements DotNetNuke.Entities.Modules.IPortable
 Implements DotNetNuke.Entities.Modules.ISearchable

#Region " IPortable Implementation "
 Public Function ExportModule(ByVal ModuleID As Integer) As String Implements DotNetNuke.Entities.Modules.IPortable.ExportModule
  Dim sb As New StringBuilder()
  Dim settings As New XmlWriterSettings()
  settings.ConformanceLevel = ConformanceLevel.Fragment
  settings.OmitXmlDeclaration = True

  sb.Append("<SimpleDownloads><Settings>")
  Dim moduleSettings As Hashtable
  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  moduleSettings = objModules.GetModuleSettings(ModuleID)
  For Each name As String In moduleSettings.Keys
   sb.Append("<Setting Name=""" + name + """>")
   sb.Append("<Value>" + XMLEncode(moduleSettings(name).ToString) + "</Value>")
   sb.Append("</Setting>")
  Next
  sb.Append("</Settings>")

  ' content items go here

  sb.Append("</SimpleDownloads>")
  Return sb.ToString()

 End Function

 Public Sub ImportModule(ByVal ModuleID As Integer, ByVal Content As String, ByVal Version As String, ByVal UserID As Integer) Implements DotNetNuke.Entities.Modules.IPortable.ImportModule

  Dim xmlDoc As New XmlDocument
  xmlDoc.LoadXml(Content)

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  For Each xSetting As XmlNode In xmlDoc.SelectNodes("SimpleDownloads/Settings/Setting")
   Dim settingName As String = xSetting.Attributes("Name").InnerText
   Dim settingValue As String = xSetting.SelectSingleNode("Value").InnerText
   objModules.UpdateModuleSetting(ModuleID, settingName, settingValue)
  Next

 End Sub
#End Region

#Region " ISearchable "
 Public Function GetSearchItems(ByVal ModInfo As DotNetNuke.Entities.Modules.ModuleInfo) As SearchItemInfoCollection Implements DotNetNuke.Entities.Modules.ISearchable.GetSearchItems
  Dim sic As New SearchItemInfoCollection
  Dim fl As New FileList(New SimpleDownloadsSettings(ModInfo.ModuleID))

  For Each xFile As XmlNode In fl.SelectNodes("//File")
   Dim fName As String = xFile.Attributes("Name").InnerText
   Dim si As New SearchItemInfo
   With si
    .Content = fName & " " & IO.Path.GetFileNameWithoutExtension(fName)
    .Description = fName
    .GUID = "file=" & xFile.Attributes("AccessPath").InnerText
    .ModuleId = ModInfo.ModuleID
    .PubDate = Date.Parse(xFile.Attributes("LastWriteTimeUtc").InnerText)
    .SearchKey = xFile.Attributes("AccessPath").InnerText
    .Title = fName
   End With
   sic.Add(si)
  Next

  Return sic

 End Function
#End Region

End Class

