﻿Imports System
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization.Localization
Imports DotNetNuke.Services.Localization
Imports Bring2mind.DNN.Modules.Questionnaire

Partial Public Class Settings
 Inherits Entities.Modules.ModuleSettingsBase

#Region " Base Method Implementations "
 Public Overrides Sub LoadSettings()
  Try
   If Not Page.IsPostBack Then

    Dim Settings As New ModuleSettings(Me.ModuleId)

    Dim di As New IO.DirectoryInfo(Settings.UploadMapPath)
    Dim XmlFiles() As IO.FileInfo = di.GetFiles("*.xml")
    ddQuestionnaireFile.DataSource = XmlFiles
    ddQuestionnaireFile.DataBind()
    ddQuestionnaireFile.Items.Insert(0, New ListItem("Select ...", ""))

    Dim XslFiles() As IO.FileInfo = di.GetFiles("*.xsl?")
    ddListXslt.DataSource = XslFiles
    ddListXslt.DataBind()
    ddListXslt.Items.Insert(0, New ListItem("Select ...", ""))

    With Settings
     Try
      ddQuestionnaireFile.Items.FindByValue(.QuestionnaireFile).Selected = True
     Catch ex As Exception
     End Try
     chkAllowMultiple.Checked = .AllowMultiple
     chkSendResults.Checked = .SendResults
     chkSaveResults.Checked = .SaveResults
     txtDestinationEmail.Text = .DestinationEmail
     chkSendAsXml.Checked = .SendAsXml
     chkSendAsAttachment.Checked = .SendAsAttachment
     txtProcessingInstructions.Text = .ProcessingInstructions
     chkResultsPublic.Checked = .ResultsPublic
     Try
      ddListXslt.Items.FindByValue(.ListXslt).Selected = True
     Catch ex As Exception
     End Try
    End With
   End If
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Public Overrides Sub UpdateSettings()
  Try

   Dim Settings As New ModuleSettings(Me.ModuleId)
   With Settings
    .QuestionnaireFile = ddQuestionnaireFile.SelectedValue
    .AllowMultiple = chkAllowMultiple.Checked
    .SendResults = chkSendResults.Checked
    .SaveResults = chkSaveResults.Checked
    .DestinationEmail = txtDestinationEmail.Text
    .SendAsXml = chkSendAsXml.Checked
    .SendAsAttachment = chkSendAsAttachment.Checked
    .ProcessingInstructions = txtProcessingInstructions.Text
    .ResultsPublic = chkResultsPublic.Checked
    .ListXslt = ddListXslt.SelectedValue
    .SaveSettings()
   End With

   For Each l As String In GetSupportedLocales().Keys
    Me.Cache.Remove("Questionnaire4Module" & Me.ModuleId & "inPortal" & Me.PortalId & "Locale" & l)
    Me.Cache.Remove("ListXslt" & Me.ModuleId & "User" & Me.UserId & "Locale" & l)
   Next
   Me.Cache.Remove("Settings4Module" & ModuleId & "inPortal" & PortalId)

  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

#End Region

#Region " Event Handlers "
 Private Sub cmdUpload_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdUpload.Click

  Dim ModuleSettings As New ModuleSettings(Me.ModuleId)

  If NewFile.PostedFile Is Nothing Then Exit Sub
  With NewFile.PostedFile
   If .ContentLength < 1 Then Exit Sub
  End With

  Select Case IO.Path.GetExtension(NewFile.PostedFile.FileName)
   Case ".xml"
    Dim TempFile As String = ModuleSettings.UploadMapPath & "temp.xml"
    NewFile.PostedFile.SaveAs(TempFile)
    'now test q-validity
    Dim Passed As Boolean = True
    Dim testquestionnaire As New QuestionnaireTemplate
    Try
     testquestionnaire.ReadXml(TempFile, XmlReadMode.InferSchema)
    Catch ex As Exception
     Passed = False
    End Try
    If testquestionnaire.questionnaire.Rows.Count < 1 Then
     Passed = False
    End If
    If Not Passed Then
     lblError.Text = GetString("XmlWrong", Me.LocalResourceFile)
     Exit Sub
    End If
    IO.File.Delete(TempFile)
    Dim NewFileName As String = System.Text.RegularExpressions.Regex.Replace(NewFile.PostedFile.FileName, ".*\\", "")
    NewFile.PostedFile.SaveAs(ModuleSettings.UploadMapPath & NewFileName)
    ddQuestionnaireFile.Items.Insert(1, New ListItem(NewFileName, NewFileName))
   Case ".xsl", ".xslt"
    Dim NewFileName As String = System.Text.RegularExpressions.Regex.Replace(NewFile.PostedFile.FileName, ".*\\", "")
    NewFile.PostedFile.SaveAs(ModuleSettings.UploadMapPath & NewFileName)
    ddListXslt.Items.Insert(1, New ListItem(NewFileName, NewFileName))
  End Select

 End Sub

#End Region

End Class