Imports DotNetNuke

Public Class ResultMail

#Region " Public Members "
 Public MailFrom As String
 Public MailTo As String
 Public Cc As String
 Public Bcc As String
 Public Attachment As String
 Public Attachments As New ArrayList
 Public AttachmentsToDelete As New ArrayList
 Public Priority As Web.Mail.MailPriority = Mail.MailPriority.Normal
 Public BodyFormat As Web.Mail.MailFormat = Mail.MailFormat.Text
 Public Subject As String
 Public Body As String
 Public BodyEncoding As System.Text.Encoding = System.Text.Encoding.Default
#End Region

#Region " Constructors "
 Public Sub New(ByVal strMailFrom As String, ByVal strMailTo As String, ByVal strSubject As String, ByVal strBody As String)
  MailFrom = strMailFrom
  MailTo = strMailTo
  Subject = strSubject
  Body = strBody
 End Sub

 Public Sub New()
 End Sub
#End Region

#Region " Public Methods "
 Public Sub Send()

  ' SMTP server configuration
  Dim SMTPServer As String = ""
  If Convert.ToString(Common.Globals.HostSettings("SMTPServer")) <> "" Then
   SMTPServer = Convert.ToString(Common.Globals.HostSettings("SMTPServer"))
  End If
  Dim SMTPAuthentication As String = ""
  If Convert.ToString(Common.Globals.HostSettings("SMTPAuthentication")) <> "" Then
   SMTPAuthentication = Convert.ToString(Common.Globals.HostSettings("SMTPAuthentication"))
  End If
  Dim SMTPUsername As String = ""
  If Convert.ToString(Common.Globals.HostSettings("SMTPUsername")) <> "" Then
   SMTPUsername = Convert.ToString(Common.Globals.HostSettings("SMTPUsername"))
  End If
  Dim SMTPPassword As String = ""
  If Convert.ToString(Common.Globals.HostSettings("SMTPPassword")) <> "" Then
   SMTPPassword = Convert.ToString(Common.Globals.HostSettings("SMTPPassword"))
  End If

  Dim objMail As New Web.Mail.MailMessage
  objMail.From = MailFrom
  objMail.To = MailTo
  If Cc <> "" Then
   objMail.Cc = Cc
  End If
  If Bcc <> "" Then
   objMail.Bcc = Bcc
  End If
  objMail.Priority = CType(Priority, Web.Mail.MailPriority)
  objMail.BodyFormat = CType(BodyFormat, Web.Mail.MailFormat)

  If Not Attachment Is Nothing Then
   Dim atts As String() = Attachment.Split(New Char() {";"c})
   For Each att As String In atts
    att = att.Trim
    If IO.File.Exists(att) Then
     objMail.Attachments.Add(New Web.Mail.MailAttachment(att))
    End If
   Next
  End If
  For Each Attmnt As String In Attachments
   objMail.Attachments.Add(New Web.Mail.MailAttachment(Attmnt))
  Next

  ' message
  objMail.Subject = Subject
  objMail.BodyEncoding = BodyEncoding
  objMail.Body = Body

  ' external SMTP server
  If SMTPServer <> "" Then
   Web.Mail.SmtpMail.SmtpServer = SMTPServer
   Select Case SMTPAuthentication
    Case "", "0" ' anonymous
    Case "1" ' basic
     If SMTPUsername <> "" And SMTPPassword <> "" Then
      objMail.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1
      objMail.Fields("http://schemas.microsoft.com/cdo/configuration/sendusername") = SMTPUsername
      objMail.Fields("http://schemas.microsoft.com/cdo/configuration/sendpassword") = SMTPPassword
     End If
    Case "2" ' NTLM
     objMail.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 2
   End Select
  End If

  Try
   Web.Mail.SmtpMail.Send(objMail)
  Catch objException As Exception
   ' mail configuration problem
   DotNetNuke.Services.Exceptions.LogException(objException)
  Finally
   For Each strAtt As String In AttachmentsToDelete
    Try
     IO.File.Delete(strAtt)
    Catch ex As Exception
    End Try
   Next
  End Try

 End Sub
#End Region
End Class
