'
' Copyright (c) 2004-2005
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software for a single server. It is 
' NOT permitted to publish, distribute, sublicense, and/or sell copies of this software in its
' original or modified form. You are not allowed to remove this copyright notice.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
' BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
' NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
' DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
' OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OF THE SOFTWARE.
'

Public Class Dialog
 Inherits System.Web.UI.Control

#Region " Private Members "
 Private _title As String
 Private _description As String
 Private _buttons As ArrayList
#End Region

#Region " Public Methods "
 Public Sub AddButton(ByVal Text As String, ByVal Url As String)
  If _buttons Is Nothing Then
   _buttons = New ArrayList
  End If
  Dim li As New ListItem(Text, Url)
  _buttons.Add(li)
 End Sub
#End Region

#Region " Event Handlers "
 Private Sub Dialog_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.PreRender

  Dim bx As New HtmlGenericControl("div")
  bx.Attributes.Add("class", "Confirm_Box")
  Me.Controls.Add(bx)

  Dim t As New HtmlGenericControl("div")
  t.Attributes.Add("class", "Confirm_Title")
  t.InnerHtml = Title
  bx.Controls.Add(t)

  Dim d As New HtmlGenericControl("div")
  d.Attributes.Add("class", "Confirm_Description")
  d.InnerHtml = Description
  bx.Controls.Add(d)

  If Not Buttons Is Nothing Then
   Dim bs As New HtmlGenericControl("div")
   bs.Attributes.Add("class", "Confirm_Buttons")
   Dim li As ListItem
   For Each li In Buttons
    Dim b As New HyperLink
    b.Text = li.Text
    b.NavigateUrl = li.Value
    bs.Controls.Add(b)
   Next
   bx.Controls.Add(bs)
  End If

 End Sub
#End Region

#Region " Properties "
 Public Property Buttons() As ArrayList
  Get
   Return _buttons
  End Get
  Set(ByVal Value As ArrayList)
   _buttons = Value
  End Set
 End Property

 Public Property Description() As String
  Get
   Return _description
  End Get
  Set(ByVal Value As String)
   _description = Value
  End Set
 End Property

 Public Property Title() As String
  Get
   Return _title
  End Get
  Set(ByVal Value As String)
   _title = Value
  End Set
 End Property
#End Region

End Class

