Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.Questionnaire


Public Class PortalModuleBase
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Variables "
 Public _questionnaire As QuestionnaireTemplate
 Private _moduleSettings As ModuleSettings
 Private _pageParams As ArrayList
 Private _query As Query
 Private _permission As String
 Private _searchFields As Hashtable
 Private _filterFields As ArrayList
#End Region

#Region " Public Properties "
 Public Property ModuleSettings() As ModuleSettings
  Get
   If _moduleSettings Is Nothing Then
    Dim CacheKey As String = "Settings4Module" & Me.ModuleId & "inPortal" & Me.PortalId
    Try
     _moduleSettings = CType(Me.Cache.Item(CacheKey), ModuleSettings)
    Catch ex As Exception
    End Try
    If _moduleSettings Is Nothing Then
     _moduleSettings = New ModuleSettings(ModuleId)
     Me.Cache.Insert(CacheKey, _moduleSettings, Nothing, DateTime.MaxValue, New System.TimeSpan(0, 20, 0))
    End If
   End If
   Return _moduleSettings
  End Get
  Set(ByVal Value As ModuleSettings)
   _moduleSettings = Value
  End Set
 End Property

 Public Property Questionnaire() As QuestionnaireTemplate
  Get

   If _questionnaire Is Nothing Then
    If ModuleSettings.QuestionnaireFile = "" Then
     Return Nothing
    End If
    Dim CacheKey As String = "Questionnaire4Module" & Me.ModuleId & "inPortal" & Me.PortalId & "Locale" & System.Threading.Thread.CurrentThread.CurrentCulture.ToString
    Try
     _questionnaire = CType(Me.Cache.Item(CacheKey), QuestionnaireTemplate)
    Catch ex As Exception
    End Try
    If _questionnaire Is Nothing Then
     Try
      _questionnaire = New QuestionnaireTemplate
      Dim xmlFileName As String = Globals.GetLocalizedFile(ModuleSettings.QuestionnaireFileFullName, System.Threading.Thread.CurrentThread.CurrentCulture.ToString)
      _questionnaire.ReadXml(xmlFileName, XmlReadMode.InferSchema)
      ' Set the cache
      Dim dp As New Caching.CacheDependency(xmlFileName)
      Dim CacheMins As Integer
      CacheMins = 3 * Convert.ToInt32(DotNetNuke.Common.Globals.PerformanceSetting)
      If CacheMins > 0 Then
       DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _questionnaire, dp, Date.MaxValue, New TimeSpan(0, CacheMins, 0))
       'DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _questionnaire, New TimeSpan(0, CacheMins, 0))
      End If
     Catch ex As Exception
      _questionnaire = Nothing
     End Try
    End If
   End If
   Return _questionnaire

  End Get
  Set(ByVal Value As QuestionnaireTemplate)
   _questionnaire = Value
  End Set
 End Property

 Public Property FilterFields() As ArrayList
  Get

   If _filterFields Is Nothing Then
    If ModuleSettings.QuestionnaireFile = "" Then
     Return Nothing
    End If
    Dim CacheKey As String = "FilterFields4Module" & Me.ModuleId & "inPortal" & Me.PortalId & "Locale" & System.Threading.Thread.CurrentThread.CurrentCulture.ToString
    Try
     _filterFields = CType(Me.Cache.Item(CacheKey), ArrayList)
    Catch ex As Exception
    End Try
    If _filterFields Is Nothing Then
     Try
      _filterFields = New ArrayList
      Dim q As QuestionnaireTemplate.questionRow
      For Each q In _questionnaire.question.Rows
       If Not q.IsfilterableNull AndAlso Globals.GetABoolean(q.filterable) Then
        Dim ff As New FilterField(q.id, q.issue)
        For Each opt As QuestionnaireTemplate._optionRow In q.GetoptionsRows(0).GetoptionRows
         ff.Values.Add(opt.value, opt.text)
        Next
        _filterFields.Add(ff)
       End If
      Next
      ' Set the cache to the questionnaire
      Dim dp As New Caching.CacheDependency(ModuleSettings.QuestionnaireFileFullName)
      Dim CacheMins As Integer
      CacheMins = 3 * Convert.ToInt32(DotNetNuke.Common.Globals.PerformanceSetting)
      If CacheMins > 0 Then
       DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _filterFields, dp, Date.MaxValue, New TimeSpan(0, CacheMins, 0))
      End If
     Catch ex As Exception
      _searchFields = Nothing
     End Try
    End If
   End If
   Return _filterFields

  End Get
  Set(ByVal Value As ArrayList)

   _filterFields = Value

  End Set
 End Property

 Public Property SearchFields() As Hashtable
  Get

   If _searchFields Is Nothing Then
    If ModuleSettings.QuestionnaireFile = "" Then
     Return Nothing
    End If
    Dim CacheKey As String = "SearchFields4Module" & Me.ModuleId & "inPortal" & Me.PortalId & "Locale" & System.Threading.Thread.CurrentThread.CurrentCulture.ToString
    Try
     _searchFields = CType(Me.Cache.Item(CacheKey), Hashtable)
    Catch ex As Exception
    End Try
    If _searchFields Is Nothing Then
     Try
      _searchFields = New Hashtable
      Dim q As QuestionnaireTemplate.questionRow
      For Each q In _questionnaire.question.Rows
       If Not q.IssearchableNull AndAlso Globals.GetABoolean(q.searchable) Then
        _searchFields.Add(q.id, q.issue)
       End If
      Next
      ' Set the cache to the questionnaire
      Dim dp As New Caching.CacheDependency(ModuleSettings.QuestionnaireFileFullName)
      Dim CacheMins As Integer
      CacheMins = 3 * Convert.ToInt32(DotNetNuke.Common.Globals.PerformanceSetting)
      If CacheMins > 0 Then
       DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _searchFields, dp, Date.MaxValue, New TimeSpan(0, CacheMins, 0))
      End If
     Catch ex As Exception
      _searchFields = Nothing
     End Try
    End If
   End If
   Return _searchFields

  End Get
  Set(ByVal Value As Hashtable)
   _searchFields = Value
  End Set
 End Property

 Public Property Query() As Query
  Get

   If _query Is Nothing Then
    _query = New Query(Me.Request)
   End If
   Return _query

  End Get
  Set(ByVal Value As Query)
   _query = Value
  End Set
 End Property

 Public ReadOnly Property ListXslt() As String
  Get
   Dim CacheKey As String = "ListXslt" & Me.ModuleId & "User" & Me.UserId & "Locale" & System.Threading.Thread.CurrentThread.CurrentCulture.ToString
   Dim _res As String
   Try
    _res = CType(Me.Cache.Item(CacheKey), String)
   Catch ex As Exception
   End Try
   If _res Is Nothing Then
    Dim xslFilename As String = Globals.GetLocalizedFile(Me.ModuleSettings.UploadMapPath & Me.ModuleSettings.ListXslt, System.Threading.Thread.CurrentThread.CurrentCulture.ToString)
    Dim sr As New IO.StreamReader(xslFilename)
    _res = sr.ReadToEnd
    sr.Close()
    Globals.ParameterizeString(_res, Me.UserInfo, Me.PageParameters)
    ' Set the cache
    Dim dp As New Caching.CacheDependency(xslFilename)
    Dim CacheMins As Integer
    CacheMins = 3 * Convert.ToInt32(DotNetNuke.Common.Globals.PerformanceSetting)
    If CacheMins > 0 Then
     DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _res, dp, Date.MaxValue, New TimeSpan(0, CacheMins, 0))
     'DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey, _res, New TimeSpan(0, CacheMins, 0))
    End If
   End If

   _res = _res.Replace("[DetailId]", Me.Query.DetailId).Replace("[PageIndex]", Me.Query.PageIndex).Replace("[SortKey]", Me.Query.SortKey).Replace("[PERMISSION]", Me.Permission)
   For Each prm As String In Me.Request.Params.Keys
    Select Case prm
     Case "DetailId", "PageIndex", "SortKey"
      ' Do nothing as they've been replaced already
     Case Else
      _res = _res.Replace("[" & prm & "]", Me.Request.Params(prm))
    End Select
   Next
   Return _res

  End Get
 End Property

 Public ReadOnly Property Permission() As String
  Get
   If _permission Is Nothing Then
    If DotNetNuke.Security.PortalSecurity.HasNecessaryPermission(DotNetNuke.Security.SecurityAccessLevel.Admin, Me.PortalSettings, Me.ModuleConfiguration, Me.UserInfo.Username) Then
     _permission = "ADMIN"
    ElseIf Me.IsEditable Then
     _permission = "EDIT"
    Else
     _permission = "VIEW"
    End If
   End If
   Return _permission
  End Get
 End Property

 Public Function NewId(ByRef ResultsFile As System.Xml.XmlDocument) As String
  Dim key As String = Globals.RandomString(20, 30)
  Dim i As Integer = 0
  Do While Not ResultsFile.SelectSingleNode("/responses/response[q_respondent/id='" & key & "']") Is Nothing
   key = Globals.RandomString(20, 30)
   i += 1
   If i > 80 Then Return "ran out of keys"
  Loop
  Return key
 End Function

 Public ReadOnly Property PageParameters() As ArrayList
  Get
   If _pageParams Is Nothing Then
    _pageParams = New ArrayList
    _pageParams.Add(ModuleId.ToString) ' Custom:0
    _pageParams.Add(TabId.ToString) ' Custom:1
    _pageParams.Add(DotNetNuke.Common.NavigateURL(TabId).Replace("&", "&amp;")) ' Custom:2
    _pageParams.Add(EditUrl("Questionnaire").Replace("&", "&amp;")) ' Custom:3
    _pageParams.Add(EditUrl("Details").Replace("&", "&amp;")) ' Custom:4
    _pageParams.Add(Me.ModuleSettings.ResultsPath) ' Custom:5
    _pageParams.Add(Me.PortalSettings.PortalAlias.HTTPAlias) ' Custom:6
    _pageParams.Add(DotNetNuke.Common.ApplicationPath) ' Custom:7
    _pageParams.Add(DotNetNuke.Common.ApplicationMapPath) ' Custom:8
   End If
   Return _pageParams
  End Get
 End Property
#End Region

End Class




