﻿Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Services.Exceptions

Imports Bring2mind.DNN.Modules.WebRequester.Business

Partial Public Class EditWebRequest
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Variables "
 Dim WebRequestID As Integer
#End Region

#Region " Event Handlers "
 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  If Not (Request.Params("WebRequestID") Is Nothing) Then
   WebRequestID = Int32.Parse(Request.Params("WebRequestID"))
  Else
   WebRequestID = -1
  End If

  If Not Page.IsPostBack Then
   cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
   If WebRequestID <> -1 Then
    Dim objWebRequest As WebRequestInfo = WebRequestsController.GetWebRequest(WebRequestID, ModuleId)
    If Not objWebRequest Is Nothing Then
     'set screen
     txtConditionSQL.Text = objWebRequest.ConditionSQL
     txtRequestSQL.Text = objWebRequest.RequestSQL
     txtRequestUrl.Text = objWebRequest.RequestUrl
    Else ' security violation attempt to access item not related to this Module
     Response.Redirect(NavigateURL(), True)
    End If
   Else
    'Initialize New Record
    cmdDelete.Visible = False

   End If
  Else
   'its a postback
  End If
 End Sub

 Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
  Try
   ' Only Update if the Entered Data is Valid
   If Page.IsValid = True Then
    Dim objWebRequest As New WebRequestInfo

    'bind text values to object
    With objWebRequest
     'set values
     .ConditionSQL = txtConditionSQL.Text
     .ModuleID = ModuleID
     .RequestSQL = txtRequestSQL.Text
     .RequestUrl = txtRequestUrl.Text
     .WebRequestID = WebRequestID
    End With

    If WebRequestID = -1 Then
     WebRequestsController.AddWebRequest(objWebRequest)
    Else
     WebRequestsController.UpdateWebRequest(objWebRequest)
    End If

    ' Redirect back to the portal home page
    Response.Redirect(NavigateURL(), True)

   End If
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
  Try
   Response.Redirect(NavigateURL(), True)
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
  Try
   If Not WebRequestID = -1 Then
    WebRequestsController.DeleteWebRequest(WebRequestID)
   End If

   ' Redirect back to the portal home page
   Response.Redirect(NavigateURL(), True)
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub
#End Region

#Region " Optional Interfaces "
#End Region

#Region " Private Methods "
#End Region

#Region " Public Methods "
#End Region

End Class