
Imports System
Imports DotNetNuke

Namespace Data

 Public MustInherit Class DataProvider

#Region " Shared/Static Methods "

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(Framework.Reflection.CreateObject("data", "Bring2mind.DNN.Modules.WebRequester.Data", ""), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region

#Region " General Methods "
  Public MustOverride Function GetNull(ByVal Field As Object) As Object
#End Region


#Region " WebRequest Methods "

  Public MustOverride Function GetWebRequest(ByVal WebRequestID As Integer, ByVal ModuleId As Integer) As IDataReader

  Public MustOverride Function AddWebRequest(ByVal ConditionSQL As String, ByVal ModuleID As Integer, ByVal Order As Integer, ByVal RequestSQL As String, ByVal RequestUrl As String) As Integer

  Public MustOverride Sub UpdateWebRequest(ByVal WebRequestID As Integer, ByVal ConditionSQL As String, ByVal ModuleID As Integer, ByVal Order As Integer, ByVal RequestSQL As String, ByVal RequestUrl As String)

  Public MustOverride Sub DeleteWebRequest(ByVal WebRequestID As Integer)

  Public MustOverride Function GetWebRequestsByModule(ByVal ModuleID As Integer) As IDataReader

#End Region

#Region " Other Procedures "
  Public MustOverride Function GetModuleInstances(ByVal DesktopModuleName As String) As IDataReader
  Public MustOverride Function GetRowSet(ByVal CommandText As String) As IDataReader
  Public MustOverride Function GetScalar(ByVal CommandText As String) As Object
#End Region

 End Class

End Namespace

