
Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema
Imports System.Xml.Serialization

Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Services.Tokens

Imports Bring2mind.DNN.Modules.WebRequester.Data

Namespace Business


#Region " WebRequestInfo "
 <Serializable(), XmlRoot("WebRequest")> _
 Public Class WebRequestInfo
  Implements IHydratable
  Implements IPropertyAccess
  Implements IXmlSerializable

  ' local property declarations
  Private _WebRequestID As Integer
  Private _ConditionSQL As String
  Private _ModuleID As Integer
  Private _Order As Integer
  Private _RequestSQL As String
  Private _RequestUrl As String

#Region " Constructors "
  Public Sub New()
  End Sub

  Public Sub New(ByVal WebRequestID As Integer, ByVal ConditionSQL As String, ByVal ModuleID As Integer, ByVal Order As Integer, ByVal RequestSQL As String, ByVal RequestUrl As String)
   Me.ConditionSQL = ConditionSQL
   Me.ModuleID = ModuleID
   Me.Order = Order
   Me.RequestSQL = RequestSQL
   Me.RequestUrl = RequestUrl
   Me.WebRequestID = WebRequestID
  End Sub
#End Region

#Region " Public Properties "

  Public Property WebRequestID() As Integer
   Get
    Return _WebRequestID
   End Get
   Set(ByVal Value As Integer)
    _WebRequestID = Value
   End Set
  End Property

  Public Property ConditionSQL() As String
   Get
    Return _ConditionSQL
   End Get
   Set(ByVal Value As String)
    _ConditionSQL = Value
   End Set
  End Property

  Public Property ModuleID() As Integer
   Get
    Return _ModuleID
   End Get
   Set(ByVal Value As Integer)
    _ModuleID = Value
   End Set
  End Property

  Public Property Order() As Integer
   Get
    Return _Order
   End Get
   Set(ByVal Value As Integer)
    _Order = Value
   End Set
  End Property

  Public Property RequestSQL() As String
   Get
    Return _RequestSQL
   End Get
   Set(ByVal Value As String)
    _RequestSQL = Value
   End Set
  End Property

  Public Property RequestUrl() As String
   Get
    Return _RequestUrl
   End Get
   Set(ByVal Value As String)
    _RequestUrl = Value
   End Set
  End Property

#End Region

#Region " IHydratable Implementation "
  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' Fill hydrates the object from a Datareader
  ''' </summary>
  ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
  ''' rather than using the more expensive Refection  methods.</remarks>
  ''' <history>
  ''' 	[]	09/07/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

   ConditionSQL = Convert.ToString(Null.SetNull(dr.Item("ConditionSQL"), ConditionSQL))
   ModuleID = Convert.ToInt32(Null.SetNull(dr.Item("ModuleID"), ModuleID))
   Order = Convert.ToInt32(Null.SetNull(dr.Item("Order"), Order))
   RequestSQL = Convert.ToString(Null.SetNull(dr.Item("RequestSQL"), RequestSQL))
   RequestUrl = Convert.ToString(Null.SetNull(dr.Item("RequestUrl"), RequestUrl))
   WebRequestID = Convert.ToInt32(Null.SetNull(dr.Item("WebRequestID"), WebRequestID))

  End Sub
  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' Gets and sets the Key ID
  ''' </summary>
  ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
  ''' as the key property when creating a Dictionary</remarks>
  ''' <history>
  ''' 	[]	09/07/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Property KeyID() As Integer Implements IHydratable.KeyID
   Get
    Return WebRequestID
   End Get
   Set(ByVal value As Integer)
    WebRequestID = value
   End Set
  End Property
#End Region

#Region " IPropertyAccess Implementation "
  Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As DotNetNuke.Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
   Dim OutputFormat As String = String.Empty
   Dim portalSettings As DotNetNuke.Entities.Portals.PortalSettings = DotNetNuke.Entities.Portals.PortalController.GetCurrentPortalSettings()
   If strFormat = String.Empty Then
    OutputFormat = "D"
   Else
    OutputFormat = strFormat
   End If
   Select Case strPropertyName.ToLower
    Case "conditionsql"
     Return PropertyAccess.FormatString(Me.ConditionSQL, strFormat)
    Case "moduleid"
     Return (Me.ModuleID.ToString(OutputFormat, formatProvider))
    Case "order"
     Return (Me.Order.ToString(OutputFormat, formatProvider))
    Case "requestsql"
     Return PropertyAccess.FormatString(Me.RequestSQL, strFormat)
    Case "requesturl"
     Return PropertyAccess.FormatString(Me.RequestUrl, strFormat)
    Case "webrequestid"
     Return (Me.WebRequestID.ToString(OutputFormat, formatProvider))
    Case Else
     PropertyNotFound = True
   End Select

   Return Null.NullString
  End Function

  Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
   Get
    Return CacheLevel.fullyCacheable
   End Get
  End Property
#End Region

#Region " IXmlSerializable Implementation "
  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' GetSchema returns the XmlSchema for this class
  ''' </summary>
  ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
  ''' <history>
  ''' 	[]	09/07/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
   Return Nothing
  End Function

  Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
   If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
    reader.ReadToFollowing(ElementName)
   End If
   If reader.NodeType = XmlNodeType.Element Then
    Return reader.ReadElementContentAsString
   Else
    Return ""
   End If
  End Function

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
  ''' </summary>
  ''' <remarks></remarks>
  ''' <param name="reader">The XmlReader that contains the xml for the object</param>
  ''' <history>
  ''' 	[]	09/07/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
   Try

    ConditionSQL = readElement(reader, "ConditionSQL")
    If Not Int32.TryParse(readElement(reader, "ModuleID"), ModuleID) Then
     ModuleID = Null.NullInteger
    End If
    If Not Int32.TryParse(readElement(reader, "Order"), Order) Then
     Order = Null.NullInteger
    End If
    RequestSQL = readElement(reader, "RequestSQL")
    RequestUrl = readElement(reader, "RequestUrl")
   Catch ex As Exception
    ' log exception as DNN import routine does not do that
    DotNetNuke.Services.Exceptions.LogException(ex)
    ' re-raise exception to make sure import routine displays a visible error to the user
    Throw New Exception("An error occured during import of an WebRequest", ex)
   End Try

  End Sub

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
  ''' </summary>
  ''' <remarks></remarks>
  ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
  ''' <history>
  ''' 	[]	09/07/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
   writer.WriteStartElement("WebRequest")
   writer.WriteElementString("WebRequestID", WebRequestID.ToString())
   writer.WriteElementString("ConditionSQL", ConditionSQL)
   writer.WriteElementString("ModuleID", ModuleID.ToString())
   writer.WriteElementString("Order", Order.ToString())
   writer.WriteElementString("RequestSQL", RequestSQL)
   writer.WriteElementString("RequestUrl", RequestUrl)
   writer.WriteEndElement()
  End Sub
#End Region

#Region " ToXml Methods "
  Public Function ToXml() As String
   Return ToXml("WebRequest")
  End Function

  Public Function ToXml(ByVal elementName As String) As String
   Dim xml As New StringBuilder
   xml.Append("<")
   xml.Append(elementName)
   'AddAttribute(xml, "WebRequestID", WebRequestID.ToString())
   'AddAttribute(xml, "ConditionSQL", ConditionSQL)
   'AddAttribute(xml, "ModuleID", ModuleID.ToString())
   'AddAttribute(xml, "Order", Order.ToString())
   'AddAttribute(xml, "RequestSQL", RequestSQL)
   'AddAttribute(xml, "RequestUrl", RequestUrl)
   xml.Append(" />")
   Return xml.ToString
  End Function
#End Region

 End Class
#End Region

#Region " WebRequestsController "
 Public Class WebRequestsController

  Public Shared Function GetWebRequest(ByVal WebRequestID As Integer, ByVal ModuleId As Integer) As WebRequestInfo

   Return CType(CBO.FillObject(DataProvider.Instance().GetWebRequest(WebRequestID, ModuleId), GetType(WebRequestInfo)), WebRequestInfo)

  End Function

  Public Shared Function AddWebRequest(ByVal objWebRequest As WebRequestInfo) As Integer

   Return CType(DataProvider.Instance().AddWebRequest(objWebRequest.ConditionSQL, objWebRequest.ModuleID, objWebRequest.Order, objWebRequest.RequestSQL, objWebRequest.RequestUrl), Integer)

  End Function

  Public Shared Sub UpdateWebRequest(ByVal objWebRequest As WebRequestInfo)

   DataProvider.Instance().UpdateWebRequest(objWebRequest.WebRequestID, objWebRequest.ConditionSQL, objWebRequest.ModuleID, objWebRequest.Order, objWebRequest.RequestSQL, objWebRequest.RequestUrl)

  End Sub

  Public Shared Sub DeleteWebRequest(ByVal WebRequestID As Integer)

   DataProvider.Instance().DeleteWebRequest(WebRequestID)

  End Sub

  Public Shared Function GetWebRequestsByModule(ByVal ModuleID As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetWebRequestsByModule(ModuleID), GetType(WebRequestInfo))

  End Function

 End Class
#End Region


End Namespace
