﻿Imports System.Xml

Imports DotNetNuke
Imports DotNetNuke.Common

Public Class Common

 Public Const STR_Expires As String = "DNNSupport_Expires"

#Region " Generic Data "
 Public Shared Sub RunQuery(ByRef node As XmlNode, ByVal tableName As String, ByVal rowName As String, ByVal query As String)

  If node Is Nothing Then Exit Sub
  AddDataReader(node, tableName, rowName, DotNetNuke.Data.DataProvider.Instance.ExecuteSQL(query))

 End Sub

 Public Shared Sub AddDataReader(ByRef node As XmlNode, ByVal tableName As String, ByVal rowName As String, ByVal reader As IDataReader)

  If node Is Nothing Then Exit Sub
  Dim table As XmlNode = node.OwnerDocument.CreateElement(tableName)
  node.AppendChild(table)
  Dim fields As New ArrayList
  Dim intFieldCount As Integer = reader.FieldCount
  Dim intCounter As Integer
  For intCounter = 0 To intFieldCount - 1
   fields.Add(reader.GetName(intCounter))
  Next intCounter
  While reader.Read()
   Dim row As XmlNode = node.OwnerDocument.CreateElement(rowName)
   table.AppendChild(row)
   For Each field As String In fields
    AddElement(row, field, GetAString(reader.Item(field)))
   Next
  End While
  reader.Close()

 End Sub

 Public Shared Sub AddDataTable(ByRef node As XmlNode, ByVal tableName As String, ByVal rowName As String, ByVal table As DataTable)

  If node Is Nothing Then Exit Sub
  Dim xTable As XmlNode = node.OwnerDocument.CreateElement(tableName)
  node.AppendChild(xTable)
  Dim fields As New ArrayList
  Dim intFieldCount As Integer = table.Columns.Count
  Dim intCounter As Integer
  For intCounter = 0 To intFieldCount - 1
   fields.Add(table.Columns(intCounter).ColumnName)
  Next intCounter
  For Each dr As DataRow In table.Rows
   Dim row As XmlNode = node.OwnerDocument.CreateElement(rowName)
   xTable.AppendChild(row)
   For Each field As String In fields
    AddElement(row, field, GetAString(dr.Item(field)))
   Next
  Next

 End Sub

 Public Shared Function GetAString(ByVal x As Object) As String

  If x Is Nothing Then
   Return "NULL"
  ElseIf x Is DBNull.Value Then
   Return "NULL"
  Else
   Return Convert.ToString(x)
  End If

 End Function
#End Region

#Region " File System "
 Public Shared Sub AddFileSystemDetails(ByRef node As XmlNode, ByVal path As String, ByVal includeFiles As Boolean, ByVal recurse As Boolean)

  If node Is Nothing Then Exit Sub
  Dim x As XmlNode = node.OwnerDocument.CreateElement("Folder")
  node.AppendChild(x)
  AddAttribute(x, "Path", Mid(path, path.LastIndexOf("\"c) + 2))
  If Not VerifyFileCreate(path & "\Verify.txt") Then
   AddAttribute(x, "VerifyFileCreate", "False")
  End If
  If Not VerifyFileCreate(path & "\Verify.txt") Then
   AddAttribute(x, "VerifyFileDelete", "False")
  End If
  If Not VerifyFolderCreate(path & "\Verify") Then
   AddAttribute(x, "VerifyFolderCreate", "False")
  End If
  If Not VerifyFolderDelete(path & "\Verify") Then
   AddAttribute(x, "VerifyFolderDelete", "False")
  End If
  AddAttribute(x, "Files", IO.Directory.GetFiles(path).Length.ToString)
  If includeFiles Then
   For Each f As String In IO.Directory.GetFiles(path)
    Dim fi As New IO.FileInfo(f)
    Dim xFile As XmlNode = node.OwnerDocument.CreateElement("File")
    x.AppendChild(xFile)
    xFile.InnerText = fi.Name
    AddAttribute(xFile, "Size", fi.Length.ToString)
    AddAttribute(xFile, "CreationTime", fi.CreationTime.ToString("u"))
    If f.EndsWith(".dll") Then
     Try
      Dim ass As System.Reflection.Assembly = System.Reflection.Assembly.LoadFile(f)
      AddAttribute(xFile, "AssemblyVersion", ass.GetName.Version.ToString)
      AddAttribute(xFile, "FileVersion", System.Diagnostics.FileVersionInfo.GetVersionInfo(ass.Location).FileVersion)
      AddAttribute(xFile, "CompanyName", System.Diagnostics.FileVersionInfo.GetVersionInfo(ass.Location).CompanyName)
      AddAttribute(xFile, "ProductVersion", System.Diagnostics.FileVersionInfo.GetVersionInfo(ass.Location).ProductVersion)
      AddAttribute(xFile, "ProductName", System.Diagnostics.FileVersionInfo.GetVersionInfo(ass.Location).ProductName)
     Catch ex As Exception
     End Try
    End If
   Next
  End If
  If recurse Then
   For Each sDir As String In IO.Directory.GetDirectories(path)
    AddFileSystemDetails(x, sDir, includeFiles, recurse)
   Next
  End If

 End Sub

 Public Shared Function VerifyFileCreate(ByVal verifyFilePath As String) As Boolean

  Dim verified As Boolean = True
  'Attempt to create the File
  Try
   If IO.File.Exists(verifyFilePath) Then
    IO.File.Delete(verifyFilePath)
   End If
   Dim fileStream As IO.Stream = IO.File.Create(verifyFilePath)
   fileStream.Close()
  Catch ex As Exception
   verified = False
  End Try
  Return verified

 End Function

 Public Shared Function VerifyFileDelete(ByVal verifyFilePath As String) As Boolean

  Dim verified As Boolean = True
  'Attempt to delete the File
  Try
   IO.File.Delete(verifyFilePath)
  Catch ex As Exception
   verified = False
  End Try
  Return verified

 End Function

 Public Shared Function VerifyFolderCreate(ByVal verifyPath As String) As Boolean

  Dim verified As Boolean = True
  'Attempt to create the Directory
  Try
   If IO.Directory.Exists(verifyPath) Then
    IO.Directory.Delete(verifyPath, True)
   End If
   IO.Directory.CreateDirectory(verifyPath)
  Catch ex As Exception
   verified = False
  End Try
  Return verified

 End Function

 Public Shared Function VerifyFolderDelete(ByVal verifyPath As String) As Boolean

  Dim verified As Boolean = True
  If verified Then
   'Attempt to delete the Directory
   Try
    IO.Directory.Delete(verifyPath)
   Catch ex As Exception
    verified = False
   End Try
  End If
  Return verified

 End Function
#End Region

#Region " Add Xml Files "
 Public Shared Sub AddXmlFile(ByRef node As XmlNode, ByVal nodeName As String, ByVal filename As String)

  If node Is Nothing Then Exit Sub
  AddXmlFile(node, nodeName, filename, "", "")

 End Sub

 Public Shared Sub AddXmlFile(ByRef node As XmlNode, ByVal nodeName As String, ByVal filename As String, ByVal grepReplace As String, ByVal grepReplaceWith As String)

  If node Is Nothing Then Exit Sub
  Dim xmld As New XmlDocument
  xmld.Load(filename)
  Dim x As XmlNode = node.OwnerDocument.CreateElement(nodeName)
  node.AppendChild(x)
  If grepReplace = "" Then
   x.InnerXml = xmld.DocumentElement.InnerXml
  Else
   x.InnerXml = Regex.Replace(xmld.DocumentElement.InnerXml, grepReplace, grepReplaceWith)
  End If

 End Sub
#End Region

#Region " Host Settings "
 Public Shared Sub AddHostSettings(ByRef node As XmlNode)

  If node Is Nothing Then Exit Sub
  Dim host As XmlNode = node.OwnerDocument.CreateElement("Host")
  node.AppendChild(host)
  AddElement(host, "AppVersion", glbAppVersion)
  AddElement(host, "DataProvider", DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration("data").DefaultProvider)
  AddElement(host, "Framework", System.Environment.Version.ToString)
  AddElement(host, "MachineName", System.Environment.MachineName)
  AddElement(host, "Platform", System.Environment.OSVersion.Platform.ToString)
  AddElement(host, "PlatformVersion", System.Environment.OSVersion.Version.ToString)
  AddElement(host, "ProcessorCount", System.Environment.ProcessorCount.ToString)
  AddElement(host, "UserDomainName", System.Environment.UserDomainName)
  AddElement(host, "WorkingSet", System.Environment.WorkingSet.ToString)
  AddElement(host, "Identity", System.Security.Principal.WindowsIdentity.GetCurrent.Name)
  AddElement(host, "HostName", Net.Dns.GetHostName())
  Dim strPermissions As String = ""
  If Framework.SecurityPolicy.HasRelectionPermission Then
   strPermissions += ", " & Framework.SecurityPolicy.ReflectionPermission
  End If
  If Framework.SecurityPolicy.HasWebPermission Then
   strPermissions += ", " & Framework.SecurityPolicy.WebPermission
  End If
  AddElement(host, "Permissions", Mid(strPermissions, 3))
  AddElement(host, "ApplicationPath", DotNetNuke.Common.ApplicationPath)
  AddElement(host, "ApplicationMapPath", DotNetNuke.Common.ApplicationMapPath)
  AddElement(host, "WebFarmEnabled", DotNetNuke.Common.Globals.WebFarmEnabled.ToString())
  AddHostSetting(host, "GUID", "HostPortalId", "HostTitle", "HostURL", "HostEmail", "ControlPanel")
  AddHostSetting(host, "PaymentProcessor", "Currency", "HostCurrency")
  AddHostSetting(host, "SchedulerMode", "HostSpace", "PageQuota", "UserQuota")
  AddHostSetting(host, "SiteLogStorage", "SiteLogBuffer", "SiteLogHistory")
  AddHostSetting(host, "PageStatePersister", "ModuleCaching", "PerformanceSetting", "AuthenticatedCacheability", "HttpCompression", "WhitespaceFilter")
  AddHostSetting(host, "DemoPeriod", "DemoSignup", "Copyright", "DisableUsersOnline", "UsersOnlineTime", "EnableAJAX")
  AddHostSetting(host, "AutoAccountUnlockDuration", "ProxyServer", "ProxyPort", "WebRequestTimeout")
  AddElement(host, "SMTPServerSet", (Convert.ToString(DotNetNuke.Common.Globals.HostSettings("SMTPServer")) <> "").ToString)
  AddHostSetting(host, "SMTPAuthentication", "SMTPEnableSSL")
  AddHostSetting(host, "FileExtensions", "UseCustomErrorMessages", "UseFriendlyUrls", "EnableRequestFilters")
  AddHostSetting(host, "EventLogBuffer", "SkinUpload", "HelpURL", "EnableModuleOnLineHelp", "EnableFileAutoSync")

 End Sub

 Public Shared Sub AddHostSetting(ByRef node As XmlNode, ByVal ParamArray settings() As String)

  For Each setting As String In settings
   If DotNetNuke.Common.Globals.HostSettings(setting) IsNot Nothing Then
    AddElement(node, setting, Convert.ToString(DotNetNuke.Common.Globals.HostSettings(setting).ToString))
   End If
  Next

 End Sub
#End Region

#Region " Helper Methods "
 Public Shared Sub AddAttribute(ByRef node As XmlNode, ByVal propName As String, ByVal propValue As String)

  If node Is Nothing Then Exit Sub
  Dim att As XmlAttribute = node.OwnerDocument.CreateAttribute(propName)
  att.InnerText = propValue
  node.Attributes.Append(att)

 End Sub

 Public Shared Sub AddElement(ByRef node As XmlNode, ByVal propName As String, ByVal propValue As String)

  If node Is Nothing Then Exit Sub
  Dim elt As XmlNode = node.OwnerDocument.CreateElement(propName)
  elt.InnerText = propValue
  node.AppendChild(elt)

 End Sub
#End Region

#Region " Event Log "
 Public Shared Sub AddEventLog(ByRef node As XmlNode)

  If node Is Nothing Then Exit Sub

  Dim dtIn As DataTable = DotNetNuke.Common.ConvertDataReaderToDataTable(Data.DataProvider.Instance.GetEventLog)
  Dim dtOut As New DataTable("EventLog")
  dtOut.Columns.Add("LogCreateDate", GetType(Date))
  dtOut.Columns.Add("LogTypeKey", GetType(String))
  dtOut.Columns.Add("LogConfigID", GetType(Integer))
  dtOut.Columns.Add("LogUserID", GetType(Integer))
  dtOut.Columns.Add("LogUserName", GetType(String))
  dtOut.Columns.Add("ID", GetType(Integer))

  Dim id As Integer = 1
  For Each dr As DataRow In dtIn.Rows
   Dim lp As New XmlDocument
   lp.LoadXml(CStr(dr.Item("LogProperties")))
   For Each xn As XmlNode In lp.SelectNodes("LogProperties/LogProperty")
    Dim fld As String = xn.SelectSingleNode("PropertyName").InnerText
    Dim val As String = xn.SelectSingleNode("PropertyValue").InnerText
    If val <> "" And Not dtOut.Columns.Contains(fld) Then
     dtOut.Columns.Add(fld, GetType(String))
    End If
   Next
   Dim drNew As DataRow = dtOut.NewRow
   drNew.Item("LogCreateDate") = dr.Item("LogCreateDate")
   drNew.Item("LogTypeKey") = dr.Item("LogTypeKey")
   drNew.Item("LogConfigID") = dr.Item("LogConfigID")
   drNew.Item("LogUserID") = dr.Item("LogUserID")
   drNew.Item("LogUserName") = dr.Item("LogUserName")
   drNew.Item("ID") = id
   id += 1
   For Each xn As XmlNode In lp.SelectNodes("LogProperties/LogProperty")
    Dim fld As String = xn.SelectSingleNode("PropertyName").InnerText
    Dim val As String = xn.SelectSingleNode("PropertyValue").InnerText
    If val <> "" Then
     drNew.Item(fld) = val
    End If
   Next
   dtOut.Rows.Add(drNew)
  Next

  AddDataTable(node, "EventLog", "LogEntry", dtOut)

 End Sub
#End Region

#Region " Scheduler "
 Public Shared Sub AddScheduleLog(ByRef node As XmlNode)

  ' add scheduled tasks
  AddDataReader(node, "Schedule", "ScheduleItem", Data.DataProvider.Instance.GetSchedule)

  ' add history
  AddDataReader(node, "ScheduleHistory", "ScheduleHistoryItem", Data.DataProvider.Instance.GetScheduleHistory)

 End Sub
#End Region

End Class
