﻿Imports System.Xml

Imports DotNetNuke
Imports DotNetNuke.Entities
Imports DotNetNuke.Framework

Imports Bring2mind.DNN.Modules.DNNSupport.Common

Public Class XmlReport
 Inherits XmlDocument

#Region " Private Members "
 Private _root As XmlNode
#End Region

#Region " Constructors "
 Public Sub New()
  MyBase.New()
  Me.AppendChild(Me.CreateXmlDeclaration("1.0", Nothing, "yes"))
  _root = Me.CreateElement("Report")
  Me.AppendChild(_root)
  AddAttribute(_root, "Created", Now.ToString("u"))
  AddHostSettings(_root)
  AddXmlFile(_root, "Compression", DotNetNuke.Common.Globals.ApplicationMapPath + "\Compression.config")
  AddXmlFile(_root, "WebConfig", DotNetNuke.Common.Globals.ApplicationMapPath + "\web.config", "(?i)(?<=validationkey=""|decryptionkey=""|key=""sitesqlserver"" value=""|connectionstring="")[^""]+(?-i)", "*******")
  Dim x As XmlNode = Me.CreateElement("FileSystem")
  _root.AppendChild(x)
  AddFileSystemDetails(x, DotNetNuke.Common.ApplicationMapPath & "\bin", True, False)
  AddFileSystemDetails(x, DotNetNuke.Common.ApplicationMapPath & "\portals", False, True)
  AddDataReader(_root, "DatabaseUsage", "Table", Data.DataProvider.Instance.DatabaseUsage)
  AddDataReader(_root, "InstalledModules", "Module", DotNetNuke.Data.DataProvider.Instance.GetDesktopModules)
  AddDataReader(_root, "ModuleUsage", "Module", Data.DataProvider.Instance.GetModuleUsageList)
  AddDataReader(_root, "Portals", "Portal", Data.DataProvider.Instance.GetPortalDetails)
  For Each pi As Portals.PortalInfo In (New Portals.PortalController).GetPortals
   AddDataReader(_root.SelectSingleNode("Portals/Portal[PortalID='" & pi.PortalID.ToString & "']"), "Aliases", "Alias", DotNetNuke.Data.DataProvider.Instance.GetPortalAliasByPortalID(pi.PortalID))
   AddDataReader(_root.SelectSingleNode("Portals/Portal[PortalID='" & pi.PortalID.ToString & "']"), "Modules", "Module", Data.DataProvider.Instance.GetModuleList(pi.PortalID))
  Next
  For Each dm As DotNetNuke.Entities.Modules.DesktopModuleInfo In (New DotNetNuke.Entities.Modules.DesktopModuleController).GetDesktopModules
   If dm.BusinessControllerClass <> "" Then
    Try
     Dim objController As Object = Framework.Reflection.CreateObject(dm.BusinessControllerClass, "")
     If TypeOf objController Is ISysInfoProducer Then
      Dim sip As ISysInfoProducer = CType(objController, ISysInfoProducer)
      sip.ProduceInfo(_root)
     End If
    Catch ex As Exception
    End Try
   End If
  Next
  AddEventLog(_root)
  AddScheduleLog(_root)
 End Sub
#End Region

End Class

