Imports System

Imports DotNetNuke.Common.Utilities

Imports BugNET.DNN.Library.Data

Public Class BugsController

 Public Shared Function GetBug(ByVal BugID As Integer) As BugInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBug(BugID), GetType(BugInfo)), BugInfo)

 End Function

 Public Shared Function AddBug(ByVal objBug As BugInfo) As Integer

  If objBug.ReporterUserName = "" Then
   objBug.ReporterUserName = DotNetNuke.Entities.Users.UserController.GetCurrentUserInfo.Username
  End If
  If objBug.LastUpdateUserName = "" Then
   objBug.LastUpdateUserName = DotNetNuke.Entities.Users.UserController.GetCurrentUserInfo.Username
  End If

  Return CType(DataProvider.Instance().AddBug(objBug.AssignedToUserName, objBug.ComponentID, objBug.Description, objBug.DueDate, objBug.Estimation, objBug.FixedInVersionId, objBug.LastUpdate, objBug.LastUpdateUserName, objBug.PriorityID, objBug.ProjectID, objBug.ReportedDate, objBug.ReporterUserName, objBug.ResolutionID, objBug.StatusID, objBug.Summary, objBug.TypeID, objBug.VersionID, objBug.Visibility), Integer)

 End Function

 Public Shared Sub UpdateBug(ByVal objBug As BugInfo)

  DataProvider.Instance().UpdateBug(objBug.BugID, objBug.AssignedToUserName, objBug.ComponentID, objBug.Description, objBug.DueDate, objBug.Estimation, objBug.FixedInVersionId, objBug.LastUpdate, objBug.LastUpdateUserName, objBug.PriorityID, objBug.ProjectID, objBug.ReportedDate, objBug.ReporterUserName, objBug.ResolutionID, objBug.StatusID, objBug.Summary, objBug.TypeID, objBug.VersionID, objBug.Visibility)

 End Sub

 Public Shared Sub DeleteBug(ByVal BugID As Integer)

  DataProvider.Instance().DeleteBug(BugID)

 End Sub

 Public Shared Function GetBugsByCriteria(ByVal projectId As Integer, ByVal componentId As Integer, ByVal versionId As Integer, ByVal priorityId As Integer, ByVal typeId As Integer, ByVal resolutionId As Integer, ByVal statusId As Integer, ByVal assignedToUserName As String, ByVal keywords As String, ByVal includeComments As Boolean, ByVal reporterUserName As String, ByVal fixedInVersionId As Integer) As IDictionary(Of Integer, BugInfo)

  Return CBO.FillDictionary(Of BugInfo)(Data.DataProvider.Instance.GetBugsByCriteria(projectId, componentId, versionId, priorityId, typeId, resolutionId, statusId, assignedToUserName, keywords, includeComments, reporterUserName, fixedInVersionId))

 End Function

 Public Shared Function GetBugsByProject(ByVal projectId As Integer) As IDictionary(Of Integer, BugInfo)
  Return GetBugsByCriteria(projectId, -1, -1, -1, -1, -1, -1, "", "", False, "", -1)
 End Function

End Class

