Imports System
Imports System.Data
Imports Microsoft.ApplicationBlocks.Data

Imports DotNetNuke.Common.Utilities

Namespace Data
 Public Class SqlDataProvider
  Inherits DataProvider

#Region " Private Members "

  Private Const ProviderType As String = "data"

  Private _providerConfiguration As DotNetNuke.Framework.Providers.ProviderConfiguration = DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration(ProviderType)
  Private _connectionString As String
  Private _providerPath As String
  Private _objectQualifier As String
  Private _databaseOwner As String

#End Region

#Region " Constructors "

  Public Sub New()

   ' Read the configuration specific information for this provider
   Dim objProvider As DotNetNuke.Framework.Providers.Provider = CType(_providerConfiguration.Providers(_providerConfiguration.DefaultProvider), DotNetNuke.Framework.Providers.Provider)

   'Get Connection string from web.config
   _connectionString = Config.GetConnectionString()
   If _connectionString = "" Then
    ' Use connection string specified in provider
    _connectionString = objProvider.Attributes("connectionString")
   End If

   _providerPath = objProvider.Attributes("providerPath")

   _objectQualifier = objProvider.Attributes("objectQualifier")
   If _objectQualifier <> "" And _objectQualifier.EndsWith("_") = False Then
    _objectQualifier += "_"
   End If

   _databaseOwner = objProvider.Attributes("databaseOwner")
   If _databaseOwner <> "" And _databaseOwner.EndsWith(".") = False Then
    _databaseOwner += "."
   End If

  End Sub

#End Region

#Region " Properties "

  Public ReadOnly Property ConnectionString() As String
   Get
    Return _connectionString
   End Get
  End Property

  Public ReadOnly Property ProviderPath() As String
   Get
    Return _providerPath
   End Get
  End Property

  Public ReadOnly Property ObjectQualifier() As String
   Get
    Return _objectQualifier
   End Get
  End Property

  Public Const ModuleQualifier As String = "BugNETDNN_"

  Public ReadOnly Property DatabaseOwner() As String
   Get
    Return _databaseOwner
   End Get
  End Property

#End Region

#Region " General Methods "
  Public Overrides Function GetNull(ByVal Field As Object) As Object
   Return DotNetNuke.Common.Utilities.Null.GetNull(Field, DBNull.Value)
  End Function
#End Region


#Region " BugAttachments Methods "

  Public Overrides Function GetBugAttachment(ByVal BugAttachmentID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBugAttachment", BugAttachmentID), IDataReader)
  End Function

  Public Overrides Function AddBugAttachment(ByVal BugID As Integer, ByVal Description As String, ByVal FileName As String, ByVal FileSize As Integer, ByVal Type As String, ByVal UploadedDate As Date, ByVal UploadedUsername As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBugAttachment", BugID, Description, FileName, FileSize, Type, UploadedDate, UploadedUsername), Integer)
  End Function

  Public Overrides Sub UpdateBugAttachment(ByVal BugAttachmentID As Integer, ByVal BugID As Integer, ByVal Description As String, ByVal FileName As String, ByVal FileSize As Integer, ByVal Type As String, ByVal UploadedDate As Date, ByVal UploadedUsername As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateBugAttachment", BugAttachmentID, BugID, Description, FileName, FileSize, Type, UploadedDate, UploadedUsername)
  End Sub

  Public Overrides Sub DeleteBugAttachment(ByVal BugAttachmentID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBugAttachment", BugAttachmentID)
  End Sub

#End Region


#Region " BugComments Methods "

  Public Overrides Function GetBugComment(ByVal BugCommentID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBugComment", BugCommentID), IDataReader)
  End Function

  Public Overrides Function AddBugComment(ByVal BugID As Integer, ByVal Comment As String, ByVal CreatedDate As Date, ByVal CreatedUsername As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBugComment", BugID, Comment, CreatedDate, CreatedUsername), Integer)
  End Function

  Public Overrides Sub UpdateBugComment(ByVal BugCommentID As Integer, ByVal BugID As Integer, ByVal Comment As String, ByVal CreatedDate As Date, ByVal CreatedUsername As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateBugComment", BugCommentID, BugID, Comment, CreatedDate, CreatedUsername)
  End Sub

  Public Overrides Sub DeleteBugComment(ByVal BugCommentID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBugComment", BugCommentID)
  End Sub

#End Region


#Region " BugHistories Methods "

  Public Overrides Function GetBugHistory(ByVal BugHistoryID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBugHistory", BugHistoryID), IDataReader)
  End Function

  Public Overrides Function AddBugHistory(ByVal BugID As Integer, ByVal CreatedDate As Date, ByVal CreatedUsername As String, ByVal FieldChanged As String, ByVal NewValue As String, ByVal OldValue As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBugHistory", BugID, CreatedDate, CreatedUsername, FieldChanged, NewValue, OldValue), Integer)
  End Function

  Public Overrides Sub UpdateBugHistory(ByVal BugHistoryID As Integer, ByVal BugID As Integer, ByVal CreatedDate As Date, ByVal CreatedUsername As String, ByVal FieldChanged As String, ByVal NewValue As String, ByVal OldValue As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateBugHistory", BugHistoryID, BugID, CreatedDate, CreatedUsername, FieldChanged, NewValue, OldValue)
  End Sub

  Public Overrides Sub DeleteBugHistory(ByVal BugHistoryID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBugHistory", BugHistoryID)
  End Sub

#End Region


#Region " BugNotifications Methods "

  Public Overrides Function GetBugNotification(ByVal BugNotificationID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBugNotification", BugNotificationID), IDataReader)
  End Function

  Public Overrides Function AddBugNotification(ByVal BugId As Integer, ByVal Username As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBugNotification", BugId, Username), Integer)
  End Function

  Public Overrides Sub DeleteBugNotification(ByVal BugId As Integer, ByVal Username As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBugNotification", BugId, Username)
  End Sub

#End Region


#Region " Bugs Methods "

  Public Overrides Function GetBug(ByVal BugID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBug", BugID), IDataReader)
  End Function

  Public Overrides Function AddBug(ByVal AssignedToUsername As String, ByVal ComponentID As Integer, ByVal Description As String, ByVal DueDate As Date, ByVal Estimation As Decimal, ByVal FixedInVersionId As Integer, ByVal LastUpdate As Date, ByVal LastUpdateUsername As String, ByVal PriorityID As Integer, ByVal ProjectID As Integer, ByVal ReportedDate As Date, ByVal ReporterUsername As String, ByVal ResolutionID As Integer, ByVal StatusID As Integer, ByVal Summary As String, ByVal TypeID As Integer, ByVal VersionID As Integer, ByVal Visibility As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBug", GetNull(AssignedToUsername), ComponentID, Description, GetNull(DueDate), Estimation, FixedInVersionId, LastUpdate, LastUpdateUsername, PriorityID, ProjectID, ReportedDate, ReporterUsername, ResolutionID, StatusID, Summary, TypeID, VersionID, Visibility), Integer)
  End Function

  Public Overrides Sub UpdateBug(ByVal BugID As Integer, ByVal AssignedToUsername As String, ByVal ComponentID As Integer, ByVal Description As String, ByVal DueDate As Date, ByVal Estimation As Decimal, ByVal FixedInVersionId As Integer, ByVal LastUpdate As Date, ByVal LastUpdateUsername As String, ByVal PriorityID As Integer, ByVal ProjectID As Integer, ByVal ReportedDate As Date, ByVal ReporterUsername As String, ByVal ResolutionID As Integer, ByVal StatusID As Integer, ByVal Summary As String, ByVal TypeID As Integer, ByVal VersionID As Integer, ByVal Visibility As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateBug", BugID, GetNull(AssignedToUsername), ComponentID, Description, GetNull(DueDate), Estimation, FixedInVersionId, LastUpdate, LastUpdateUsername, PriorityID, ProjectID, ReportedDate, ReporterUsername, ResolutionID, StatusID, Summary, TypeID, VersionID, Visibility)
  End Sub

  Public Overrides Sub DeleteBug(ByVal BugID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBug", BugID)
  End Sub

  Public Overrides Function GetBugsByCriteria(ByVal projectId As Integer, ByVal componentId As Integer, ByVal versionId As Integer, ByVal priorityId As Integer, ByVal typeId As Integer, ByVal resolutionId As Integer, ByVal statusId As Integer, ByVal assignedToUserName As String, ByVal keywords As String, ByVal includeComments As Boolean, ByVal reporterUserName As String, ByVal fixedInVersionId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & "BugNET_Bug_GetBugsByCriteria", GetNull(projectId), GetNull(componentId), GetNull(versionId), GetNull(priorityId), GetNull(typeId), GetNull(resolutionId), GetNull(statusId), GetNull(assignedToUserName), GetNull(keywords), includeComments, GetNull(reporterUserName), GetNull(fixedInVersionId)), IDataReader)
  End Function

#End Region


#Region " BugTimeEntries Methods "

  Public Overrides Function GetBugTimeEntry(ByVal BugTimeEntryId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetBugTimeEntry", BugTimeEntryId), IDataReader)
  End Function

  Public Overrides Function AddBugTimeEntry(ByVal BugCommentId As Integer, ByVal BugId As Integer, ByVal CreatedUsername As String, ByVal Duration As Decimal, ByVal WorkDate As Date) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddBugTimeEntry", BugCommentId, BugId, CreatedUsername, Duration, WorkDate), Integer)
  End Function

  Public Overrides Sub UpdateBugTimeEntry(ByVal BugTimeEntryId As Integer, ByVal BugCommentId As Integer, ByVal BugId As Integer, ByVal CreatedUsername As String, ByVal Duration As Decimal, ByVal WorkDate As Date)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateBugTimeEntry", BugTimeEntryId, BugCommentId, BugId, CreatedUsername, Duration, WorkDate)
  End Sub

  Public Overrides Sub DeleteBugTimeEntry(ByVal BugTimeEntryId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteBugTimeEntry", BugTimeEntryId)
  End Sub

#End Region


#Region " Components Methods "

  Public Overrides Function GetComponent(ByVal ComponentID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetComponent", ComponentID), IDataReader)
  End Function

  Public Overrides Function AddComponent(ByVal Name As String, ByVal ParentComponentID As Integer, ByVal ProjectID As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddComponent", Name, GetNull(ParentComponentID), ProjectID), Integer)
  End Function

  Public Overrides Sub UpdateComponent(ByVal ComponentID As Integer, ByVal Name As String, ByVal ParentComponentID As Integer, ByVal ProjectID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateComponent", ComponentID, Name, GetNull(ParentComponentID), ProjectID)
  End Sub

  Public Overrides Sub DeleteComponent(ByVal ComponentID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteComponent", ComponentID)
  End Sub

  Public Overrides Function FindComponentByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindComponentByName", Name), IDataReader)
  End Function

  Public Overrides Function GetComponentsByProject(ByVal ProjectID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetComponentsByProject", ProjectID), IDataReader)
  End Function

#End Region


#Region " Logs Methods "

  Public Overrides Function GetLog(ByVal Id As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetLog", Id), IDataReader)
  End Function

  Public Overrides Function AddLog(ByVal [Date] As Date, ByVal Exception As String, ByVal Level As String, ByVal Logger As String, ByVal Message As String, ByVal Thread As String, ByVal User As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddLog", [Date], GetNull(Exception), Level, Logger, Message, Thread, User), Integer)
  End Function

  Public Overrides Sub UpdateLog(ByVal Id As Integer, ByVal [Date] As Date, ByVal Exception As String, ByVal Level As String, ByVal Logger As String, ByVal Message As String, ByVal Thread As String, ByVal User As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateLog", Id, [Date], GetNull(Exception), Level, Logger, Message, Thread, User)
  End Sub

  Public Overrides Sub DeleteLog(ByVal Id As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteLog", Id)
  End Sub

#End Region


#Region " Permissions Methods "

  Public Overrides Function GetPermission(ByVal PermissionId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetPermission", PermissionId), IDataReader)
  End Function

  Public Overrides Function AddPermission(ByVal Name As String, ByVal PermissionKey As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddPermission", Name, PermissionKey), Integer)
  End Function

  Public Overrides Sub UpdatePermission(ByVal PermissionId As Integer, ByVal Name As String, ByVal PermissionKey As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdatePermission", PermissionId, Name, PermissionKey)
  End Sub

  Public Overrides Sub DeletePermission(ByVal PermissionId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeletePermission", PermissionId)
  End Sub

  Public Overrides Function FindPermissionByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindPermissionByName", Name), IDataReader)
  End Function

#End Region


#Region " Priorities Methods "

  Public Overrides Function GetPriority(ByVal PriorityID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetPriority", PriorityID), IDataReader)
  End Function

  Public Overrides Function AddPriority(ByVal ImageUrl As String, ByVal Name As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddPriority", GetNull(ImageUrl), Name), Integer)
  End Function

  Public Overrides Sub UpdatePriority(ByVal PriorityID As Integer, ByVal ImageUrl As String, ByVal Name As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdatePriority", PriorityID, GetNull(ImageUrl), Name)
  End Sub

  Public Overrides Sub DeletePriority(ByVal PriorityID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeletePriority", PriorityID)
  End Sub

  Public Overrides Function FindPriorityByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindPriorityByName", Name), IDataReader)
  End Function

  Public Overrides Function GetPriorities() As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetPriorities"), IDataReader)
  End Function

#End Region


#Region " ProjectCustomFields Methods "

  Public Overrides Function GetProjectCustomField(ByVal CustomFieldId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectCustomField", CustomFieldId), IDataReader)
  End Function

  Public Overrides Function AddProjectCustomField(ByVal CustomFieldDataType As Integer, ByVal CustomFieldName As String, ByVal CustomFieldRequired As Boolean, ByVal CustomFieldTypeId As Integer, ByVal ProjectId As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProjectCustomField", CustomFieldDataType, CustomFieldName, CustomFieldRequired, CustomFieldTypeId, ProjectId), Integer)
  End Function

  Public Overrides Sub UpdateProjectCustomField(ByVal CustomFieldId As Integer, ByVal CustomFieldDataType As Integer, ByVal CustomFieldName As String, ByVal CustomFieldRequired As Boolean, ByVal CustomFieldTypeId As Integer, ByVal ProjectId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProjectCustomField", CustomFieldId, CustomFieldDataType, CustomFieldName, CustomFieldRequired, CustomFieldTypeId, ProjectId)
  End Sub

  Public Overrides Sub DeleteProjectCustomField(ByVal CustomFieldId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProjectCustomField", CustomFieldId)
  End Sub

#End Region


#Region " ProjectCustomFieldSelections Methods "

  Public Overrides Function GetProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectCustomFieldSelection", CustomFieldSelectionId), IDataReader)
  End Function

  Public Overrides Function AddProjectCustomFieldSelection(ByVal CustomFieldId As Integer, ByVal CustomFieldSelectionName As String, ByVal CustomFieldSelectionSortOrder As Integer, ByVal CustomFieldSelectionValue As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProjectCustomFieldSelection", CustomFieldId, CustomFieldSelectionName, CustomFieldSelectionSortOrder, CustomFieldSelectionValue), Integer)
  End Function

  Public Overrides Sub UpdateProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldSelectionName As String, ByVal CustomFieldSelectionSortOrder As Integer, ByVal CustomFieldSelectionValue As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProjectCustomFieldSelection", CustomFieldSelectionId, CustomFieldId, CustomFieldSelectionName, CustomFieldSelectionSortOrder, CustomFieldSelectionValue)
  End Sub

  Public Overrides Sub DeleteProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProjectCustomFieldSelection", CustomFieldSelectionId)
  End Sub

#End Region


#Region " ProjectCustomFieldTypes Methods "

  Public Overrides Function GetProjectCustomFieldType(ByVal CustomFieldTypeId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectCustomFieldType", CustomFieldTypeId), IDataReader)
  End Function

  Public Overrides Function AddProjectCustomFieldType(ByVal CustomFieldTypeName As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProjectCustomFieldType", CustomFieldTypeName), Integer)
  End Function

  Public Overrides Sub UpdateProjectCustomFieldType(ByVal CustomFieldTypeId As Integer, ByVal CustomFieldTypeName As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProjectCustomFieldType", CustomFieldTypeId, CustomFieldTypeName)
  End Sub

  Public Overrides Sub DeleteProjectCustomFieldType(ByVal CustomFieldTypeId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProjectCustomFieldType", CustomFieldTypeId)
  End Sub

#End Region


#Region " ProjectCustomFieldValues Methods "

  Public Overrides Function GetProjectCustomFieldValue(ByVal CustomFieldValueId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectCustomFieldValue", CustomFieldValueId), IDataReader)
  End Function

  Public Overrides Function AddProjectCustomFieldValue(ByVal BugId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldValue As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProjectCustomFieldValue", BugId, CustomFieldId, CustomFieldValue), Integer)
  End Function

  Public Overrides Sub UpdateProjectCustomFieldValue(ByVal CustomFieldValueId As Integer, ByVal BugId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldValue As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProjectCustomFieldValue", CustomFieldValueId, BugId, CustomFieldId, CustomFieldValue)
  End Sub

  Public Overrides Sub DeleteProjectCustomFieldValue(ByVal CustomFieldValueId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProjectCustomFieldValue", CustomFieldValueId)
  End Sub

#End Region


#Region " ProjectMailBoxes Methods "

  Public Overrides Function GetProjectMailBox(ByVal ProjectMailboxId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectMailBox", ProjectMailboxId), IDataReader)
  End Function

  Public Overrides Function AddProjectMailBox(ByVal AssignToUsername As String, ByVal IssueTypeId As Integer, ByVal MailBox As String, ByVal ProjectId As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProjectMailBox", GetNull(AssignToUsername), GetNull(IssueTypeId), MailBox, ProjectId), Integer)
  End Function

  Public Overrides Sub UpdateProjectMailBox(ByVal ProjectMailboxId As Integer, ByVal AssignToUsername As String, ByVal IssueTypeId As Integer, ByVal MailBox As String, ByVal ProjectId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProjectMailBox", ProjectMailboxId, GetNull(AssignToUsername), GetNull(IssueTypeId), MailBox, ProjectId)
  End Sub

  Public Overrides Sub DeleteProjectMailBox(ByVal ProjectMailboxId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProjectMailBox", ProjectMailboxId)
  End Sub

#End Region


#Region " Projects Methods "

  Public Overrides Function GetProjects() As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjects"), IDataReader)
  End Function

  Public Overrides Function GetProject(ByVal ProjectID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProject", ProjectID), IDataReader)
  End Function

  Public Overrides Function AddProject(ByVal AccessType As Integer, ByVal Active As Integer, ByVal AllowAttachments As Boolean, ByVal Code As String, ByVal CreateDate As Date, ByVal CreatorUsername As String, ByVal Description As String, ByVal ManagerUsername As String, ByVal Name As String, ByVal UploadPath As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddProject", AccessType, Active, AllowAttachments, Code, CreateDate, CreatorUsername, GetNull(Description), ManagerUsername, Name, UploadPath), Integer)
  End Function

  Public Overrides Sub UpdateProject(ByVal ProjectID As Integer, ByVal AccessType As Integer, ByVal Active As Integer, ByVal AllowAttachments As Boolean, ByVal Code As String, ByVal CreateDate As Date, ByVal CreatorUsername As String, ByVal Description As String, ByVal ManagerUsername As String, ByVal Name As String, ByVal UploadPath As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateProject", ProjectID, AccessType, Active, AllowAttachments, Code, CreateDate, CreatorUsername, GetNull(Description), ManagerUsername, Name, UploadPath)
  End Sub

  Public Overrides Sub DeleteProject(ByVal ProjectID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteProject", ProjectID)
  End Sub

  Public Overrides Function FindProjectByCode(ByVal Code As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindProjectByCode", Code), IDataReader)
  End Function

  Public Overrides Function FindProjectByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindProjectByName", Name), IDataReader)
  End Function

#End Region


#Region " RelatedBugs Methods "

  Public Overrides Function GetRelatedBug(ByVal RelatedBugID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetRelatedBug", RelatedBugID), IDataReader)
  End Function

  Public Overrides Function AddRelatedBug(ByVal BugID As Integer, ByVal LinkedBugID As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddRelatedBug", BugID, LinkedBugID), Integer)
  End Function

  Public Overrides Sub UpdateRelatedBug(ByVal RelatedBugID As Integer, ByVal BugID As Integer, ByVal LinkedBugID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateRelatedBug", RelatedBugID, BugID, LinkedBugID)
  End Sub

  Public Overrides Sub DeleteRelatedBug(ByVal RelatedBugID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteRelatedBug", RelatedBugID)
  End Sub

#End Region


#Region " Resolutions Methods "

  Public Overrides Function GetResolution(ByVal ResolutionID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetResolution", ResolutionID), IDataReader)
  End Function

  Public Overrides Function AddResolution(ByVal Name As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddResolution", Name), Integer)
  End Function

  Public Overrides Sub UpdateResolution(ByVal ResolutionID As Integer, ByVal Name As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateResolution", ResolutionID, Name)
  End Sub

  Public Overrides Sub DeleteResolution(ByVal ResolutionID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteResolution", ResolutionID)
  End Sub

  Public Overrides Function FindResolutionByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindResolutionByName", Name), IDataReader)
  End Function

  Public Overrides Function GetResolutions() As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetResolutions"), IDataReader)
  End Function

#End Region


#Region " RolePermissions Methods "

  Public Overrides Function GetRolePermission(ByVal RolePermissionId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetRolePermission", RolePermissionId), IDataReader)
  End Function

  Public Overrides Function AddRolePermission(ByVal PermissionId As Integer, ByVal RoleId As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddRolePermission", PermissionId, RoleId), Integer)
  End Function

  Public Overrides Sub UpdateRolePermission(ByVal RolePermissionId As Integer, ByVal PermissionId As Integer, ByVal RoleId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateRolePermission", RolePermissionId, PermissionId, RoleId)
  End Sub

  Public Overrides Sub DeleteRolePermission(ByVal RolePermissionId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteRolePermission", RolePermissionId)
  End Sub

#End Region


#Region " Roles Methods "

  Public Overrides Function GetRole(ByVal RoleId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetRole", RoleId), IDataReader)
  End Function

  Public Overrides Function AddRole(ByVal AutoAssign As Boolean, ByVal Description As String, ByVal ProjectId As Integer, ByVal RoleName As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddRole", AutoAssign, Description, GetNull(ProjectId), RoleName), Integer)
  End Function

  Public Overrides Sub UpdateRole(ByVal RoleId As Integer, ByVal AutoAssign As Boolean, ByVal Description As String, ByVal ProjectId As Integer, ByVal RoleName As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateRole", RoleId, AutoAssign, Description, GetNull(ProjectId), RoleName)
  End Sub

  Public Overrides Sub DeleteRole(ByVal RoleId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteRole", RoleId)
  End Sub

#End Region


#Region " Statuses Methods "

  Public Overrides Function GetStatus(ByVal StatusID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetStatus", StatusID), IDataReader)
  End Function

  Public Overrides Function AddStatus(ByVal Name As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddStatus", Name), Integer)
  End Function

  Public Overrides Sub UpdateStatus(ByVal StatusID As Integer, ByVal Name As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateStatus", StatusID, Name)
  End Sub

  Public Overrides Sub DeleteStatus(ByVal StatusID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteStatus", StatusID)
  End Sub

  Public Overrides Function FindStatusByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindStatusByName", Name), IDataReader)
  End Function

  Public Overrides Function GetStatuses() As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetStatuses"), IDataReader)
  End Function

#End Region


#Region " Types Methods "

  Public Overrides Function GetBugType(ByVal TypeID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetType", TypeID), IDataReader)
  End Function

  Public Overrides Function AddType(ByVal ImageUrl As String, ByVal Name As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddType", GetNull(ImageUrl), Name), Integer)
  End Function

  Public Overrides Sub UpdateType(ByVal TypeID As Integer, ByVal ImageUrl As String, ByVal Name As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateType", TypeID, GetNull(ImageUrl), Name)
  End Sub

  Public Overrides Sub DeleteType(ByVal TypeID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteType", TypeID)
  End Sub

  Public Overrides Function FindTypeByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindTypeByName", Name), IDataReader)
  End Function

  Public Overrides Function GetBugTypes() As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetTypes"), IDataReader)
  End Function

#End Region


#Region " UserProjects Methods "
  Public Overrides Sub AddUserProject(ByVal UserName As String, ByVal ProjectId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddUserProject", UserName, ProjectId)
  End Sub

  Public Overrides Sub DeleteUserProject(ByVal UserName As String, ByVal ProjectId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteUserProject", UserName, ProjectId)
  End Sub
#End Region


#Region " UserRoles Methods "

  Public Overrides Sub AddUserRole(ByVal UserName As String, ByVal RoleId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddUserRole", UserName, RoleId)
  End Sub

  Public Overrides Sub DeleteUserRole(ByVal UserName As String, ByVal RoleId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteUserRole", UserName, RoleId)
  End Sub

#End Region


#Region " Users Methods "

  Public Overrides Function GetUser(ByVal UserName As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetUser", UserName), IDataReader)
  End Function

  Public Overrides Function AddUser(ByVal IsAnonymous As Boolean, ByVal LastActivityDate As Date, ByVal MobileAlias As String, ByVal Username As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddUser", IsAnonymous, LastActivityDate, GetNull(MobileAlias), Username), Integer)
  End Function

  Public Overrides Sub UpdateUser(ByVal IsAnonymous As Boolean, ByVal LastActivityDate As Date, ByVal MobileAlias As String, ByVal Username As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateUser", IsAnonymous, LastActivityDate, GetNull(MobileAlias), Username)
  End Sub

  Public Overrides Sub DeleteUser(ByVal UserName As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteUser", UserName)
  End Sub

  Public Overrides Function GetProjectMembers(ByVal ProjectId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetProjectMembers", ProjectId), IDataReader)
  End Function

#End Region


#Region " Versions Methods "

  Public Overrides Function GetVersion(ByVal VersionID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetVersion", VersionID), IDataReader)
  End Function

  Public Overrides Function AddVersion(ByVal Name As String, ByVal ProjectID As Integer, ByVal SortOrder As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "AddVersion", Name, ProjectID, SortOrder), Integer)
  End Function

  Public Overrides Sub UpdateVersion(ByVal VersionID As Integer, ByVal Name As String, ByVal ProjectID As Integer, ByVal SortOrder As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "UpdateVersion", VersionID, Name, ProjectID, SortOrder)
  End Sub

  Public Overrides Sub DeleteVersion(ByVal VersionID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "DeleteVersion", VersionID)
  End Sub

  Public Overrides Function FindVersionByName(ByVal Name As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "FindVersionByName", Name), IDataReader)
  End Function

  Public Overrides Function GetVersionsByProject(ByVal ProjectID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & ModuleQualifier & "GetVersionsByProject", ProjectID), IDataReader)
  End Function

#End Region


 End Class
End Namespace
