Imports System
Imports DotNetNuke

Namespace Data

 <CLSCompliant(True)> _
 Public MustInherit Class DataProvider

#Region " Shared/Static Methods "

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(DotNetNuke.Framework.Reflection.CreateObject("data", "Bring2mind.DNN.Modules.BugNetLink.Data", ""), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region

#Region " General Methods "
  Public MustOverride Function GetNull(ByVal Field As Object) As Object
#End Region

#Region " BugNet Methods "
  'Public MustOverride Function GetProjects() As IDataReader
  'Public MustOverride Sub AddUserToRole(ByVal userName As String, ByVal roleId As Integer)
  'Public MustOverride Sub RemoveUserFromRole(ByVal userName As String, ByVal roleId As Integer)
  'Public MustOverride Sub AddUserToProject(ByVal userName As String, ByVal projectId As Integer)
  'Public MustOverride Sub RemoveUserFromProject(ByVal userName As String, ByVal projectId As Integer)
  'Public MustOverride Function GetProjectsByUserName(ByVal UserName As String, ByVal activeOnly As Boolean) As IDataReader
  'Public MustOverride Function GetComponentsByProjectID(ByVal projectId As Integer) As IDataReader
  'Public MustOverride Function GetVersionByProjectId(ByVal projectId As Integer) As IDataReader
  'Public MustOverride Function GetAllTypes() As IDataReader
  'Public MustOverride Function GetAllResolutions() As IDataReader
  'Public MustOverride Function GetAllPriorities() As IDataReader
  'Public MustOverride Function GetAllStatus() As IDataReader
  'Public MustOverride Function GetProjectMembers(ByVal projectId As Integer) As IDataReader
  'Public MustOverride Function CreateNewBug(ByVal summary As String, ByVal description As String, ByVal statusID As Integer, ByVal priorityID As Integer, ByVal typeID As Integer, ByVal componentID As Integer, ByVal projectID As Integer, ByVal resolutionID As Integer, ByVal versionID As Integer, ByVal reporterUserId As String, ByVal assignedToUserId As String, ByVal dueDate As DateTime, ByVal fixedInVersionId As Integer, ByVal visibility As Integer, ByVal estimation As Decimal) As Integer
  'Public MustOverride Sub UpdateBug(ByVal BugID As Integer, ByVal summary As String, ByVal description As String, ByVal statusID As Integer, ByVal priorityID As Integer, ByVal typeID As Integer, ByVal componentID As Integer, ByVal projectID As Integer, ByVal resolutionID As Integer, ByVal versionID As Integer, ByVal assignedToUserId As String, ByVal lastUpdateUserId As String, ByVal dueDate As DateTime, ByVal fixedInVersionId As Integer, ByVal visibility As Integer, ByVal estimation As Decimal)
  'Public MustOverride Function GetBugById(ByVal bugId As Integer) As IDataReader
  'Public MustOverride Function GetBugsByProjectId(ByVal projectId As Integer) As IDataReader
  'Public MustOverride Sub AddBugNotification(ByVal BugId As Integer, ByVal userName As String)
  'Public MustOverride Sub DeleteBugNotification(ByVal BugId As Integer, ByVal userName As String)
  'Public MustOverride Function GetProject(ByVal projectId As Integer) As IDataReader
  'Public MustOverride Function GetBugsByProject(ByVal projectId As Integer) As IDataReader
#End Region

#Region " ItemIssue Methods "
  Public MustOverride Function GetItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer) As IDataReader
  Public MustOverride Sub AddItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer, ByVal BugId As Integer, ByVal Created As Date, ByVal CreatedBy As Integer)
  Public MustOverride Sub UpdateItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer, ByVal BugId As Integer, ByVal Created As Date, ByVal CreatedBy As Integer)
  Public MustOverride Sub DeleteItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer)
  Public MustOverride Function GetItemIssuesByBugNet_Bug(ByVal BugId As Integer) As IDataReader
  Public MustOverride Function GetItemIssuesByModule(ByVal ModuleID As Integer) As IDataReader
#End Region

#Region " Other Methods "
  Public MustOverride Function GetUserRoleMembership(ByVal UserName As String) As IDataReader
  Public MustOverride Function GetText(ByVal SQL As String, ByVal ItemId As Integer) As IDataReader
  Public MustOverride Function GetBugNotification(ByVal bugId As Integer, ByVal Username As String) As IDataReader
#End Region

 End Class

End Namespace

