Imports System.Web.UI
Imports System.Collections.Generic
Imports System.Reflection

Imports DotNetNuke
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization

Imports BugNET.DNN.Library

Imports Bring2mind.DNN.Modules.BugnetLink.Business

Partial Class BugNetIssue
 Inherits ModuleBase

#Region " Private Members "
 Private _currentBug As BugInfo
 Private _itemId As Integer = -1
 Private _itemIssue As ItemIssueInfo = Nothing
#End Region

#Region " Event Handlers "
 Private Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
  If Me.Settings.IdField <> "" Then
   If Me.Request.Params(Me.Settings.IdField) IsNot Nothing Then
    _itemId = CInt(Me.Request.Params(Me.Settings.IdField))
    _itemIssue = ItemIssuesController.GetItemIssue(ModuleId, _itemId)
    If _itemIssue IsNot Nothing Then
     _currentBug = BugsController.GetBug(_itemIssue.BugId)
    Else
     Me.Controls.Add(New LiteralControl(Settings.NotConnectedMessage))
    End If
   End If
  End If
  If _currentBug Is Nothing Then
   _currentBug = New BugInfo
   pnlDetails.Visible = False
   cmdSubscribe.Visible = False
   cmdUnsubscribe.Visible = False
  Else
   If Me.UserId = -1 Then
    cmdSubscribe.Visible = False
    cmdUnsubscribe.Visible = False
   Else
    If BugNetController.IsSubscribed(_currentBug.BugID, Me.UserInfo.Username) Then
     cmdSubscribe.Visible = False
     cmdUnsubscribe.Visible = True
    Else
     cmdSubscribe.Visible = True
     cmdUnsubscribe.Visible = False
    End If
   End If
  End If
  ctlBugDetails.CurrentBug = _currentBug
 End Sub

 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
  Try
   cmdEdit.Visible = False
   cmdDelete.Visible = False
   If Not Me.IsPostBack Then
    DotNetNuke.UI.Utilities.ClientAPI.AddButtonConfirm(cmdDelete, DotNetNuke.Services.Localization.Localization.GetString("DeleteItem"))
    If _itemId > -1 Then
     If DotNetNuke.Security.Permissions.ModulePermissionController.HasModulePermission(Me.ModuleConfiguration.ModulePermissions, "EDIT") Then
      cmdEdit.NavigateUrl = EditUrl("ItemId", Me.Request.Params(Me.Settings.IdField), "IssueEdit")
      cmdEdit.Visible = True
      cmdDelete.Visible = (_itemIssue IsNot Nothing)
     End If
    End If
   End If
  Catch exc As Exception        'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Private Sub cmdSubscribe_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdSubscribe.Click
  BugNotificationsController.AddBugNotification(_currentBug.BugID, Me.UserInfo.Username)
  cmdSubscribe.Visible = False
  cmdUnsubscribe.Visible = True
 End Sub

 Private Sub cmdUnsubscribe_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdUnsubscribe.Click
  BugNotificationsController.DeleteBugNotification(_currentBug.BugID, Me.UserInfo.Username)
  cmdSubscribe.Visible = True
  cmdUnsubscribe.Visible = False
 End Sub

 Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDelete.Click
  ItemIssuesController.DeleteItemIssue(ModuleId, _itemId)
  pnlDetails.Visible = False
  cmdSubscribe.Visible = False
  cmdUnsubscribe.Visible = False
  cmdDelete.Visible = False
  cmdEdit.Visible = True
  Me.Controls.Add(New LiteralControl(Settings.NotConnectedMessage))
 End Sub
#End Region

End Class

