﻿  function onCallbackError(excString)
  {
    if (confirm('Invalid data has been entered. View details?')) alert(excString); 
  }

  function onDelete(item)
  {
      if (confirm("Delete record?"))
        return true; 
      else
        return false; 
  }
  
  function editRow(grid, rowId)
  {
    grid.edit(grid.getItemFromClientId(rowId)); 
  }
  
  function updateRow(grid)
  {
    grid.EditingDirty = true;
    grid.editComplete();
  }

  function addRow(grid)
  {
    var newRow = grid.Table.addEmptyRow();
    newRow.SetValue(0,-1,true); 
    newRow.SetValue(1,newRow.Index,true); 
    grid.edit(newRow);
  }

  function deleteRow(grid, rowId)
  {
    grid.deleteItem(grid.getItemFromClientId(rowId)); 
  }
  
  function moveUpRow(grid, rowId)
  {
    var SelectedItem = grid.getItemFromClientId(rowId);
    var currentPos = SelectedItem.Index;
    if (currentPos > 0)
    {
     var currentRunOrder = SelectedItem.GetMember("ViewOrder").Value;
     var prevRow = grid.Table.GetRow(SelectedItem.Index-1);
     SelectedItem.SetValue(1, prevRow.GetMember("ViewOrder").Value);
     prevRow.SetValue(1, currentRunOrder);
     moveItem(grid, currentPos, true);
    }
  }
  
  function moveDownRow(grid, rowId)
  {
    var SelectedItem = grid.getItemFromClientId(rowId);
    var currentPos = SelectedItem.Index;
    if (currentPos < grid.Table.getRowCount()-1)
    {
     var currentRunOrder = SelectedItem.GetMember("ViewOrder").Value;
     var nextRow = grid.Table.GetRow(SelectedItem.Index+1);
     SelectedItem.SetValue(1, nextRow.GetMember("ViewOrder").Value);
     nextRow.SetValue(1, currentRunOrder);
     moveItem(grid, currentPos, false);
    }
  }

  function moveItem(grid, index, up) 
  { 
   var table = grid.get_table(); 
   var targetIndex = up? index - 1 : index + 1; 
   if(targetIndex >= 0 && targetIndex < table.getRowCount()) 
   { 
    var tempRow = table.Data[targetIndex]; 
    table.Data[targetIndex] = table.Data[index]; 
    table.Data[index] = tempRow; 
    grid.render();
   } 
  } 
