Imports System
Imports DotNetNuke

Namespace Data

 Public MustInherit Class DataProvider

#Region " Shared/Static Methods "

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(Framework.Reflection.CreateObject("data", "Bring2mind.DNN.Modules.DNNSupport.Data", ""), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region

#Region " General Methods "
  Public MustOverride Function GetNull(ByVal Field As Object) As Object
#End Region

#Region " Abstract Methods "
  Public MustOverride Function GetPortalDetails() As IDataReader
  Public MustOverride Function GetModuleList(ByVal PortalId As Integer) As IDataReader
  Public MustOverride Function GetModuleUsageList() As IDataReader
  Public MustOverride Function DatabaseUsage() As IDataReader
#End Region

 End Class

End Namespace

