﻿Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Users

Public Class SuperUserCheck
 Inherits DotNetNuke.Services.Scheduling.SchedulerClient

 Private Log As New StringBuilder

 Public Sub New(ByVal objScheduleHistoryItem As DotNetNuke.Services.Scheduling.ScheduleHistoryItem)
  MyBase.new()
  Me.ScheduleHistoryItem = objScheduleHistoryItem
 End Sub

 Public Overrides Sub DoWork()

  Try

   Me.Progressing() ' Start

   Dim sUsers As ArrayList = DotNetNuke.Security.Membership.MembershipProvider.Instance().GetUsers(DotNetNuke.Common.Utilities.Null.NullInteger, False, 0, 100, Nothing)
   For Each sUser As UserInfo In sUsers
    Dim expires As DateTime = Date.MaxValue
    Try
     expires = Date.Parse(sUser.Profile.GetPropertyValue(Common.STR_Expires))
    Catch ex As Exception
    End Try
    If expires < Now Then
     sUser.Membership.Approved = False
     UserController.UpdateUser(Null.NullInteger, sUser)
     Log.AppendLine("Disabled Superuser " & sUser.Username)
    End If
   Next

   Me.ScheduleHistoryItem.AddLogNote(Log.ToString.Replace(vbCrLf, "<br />"))
   Me.ScheduleHistoryItem.Succeeded = True

  Catch ex As Exception
   Me.ScheduleHistoryItem.AddLogNote(Log.ToString & vbCrLf & "SuperUserCheck failed: " & ex.Message & "(" & ex.StackTrace & ")" & vbCrLf & Log.ToString)
   Me.ScheduleHistoryItem.Succeeded = False
   Me.Errored(ex)
   LogException(ex)
  End Try


 End Sub
End Class
