﻿Imports DotNetNuke.Entities.Modules

Public Class NavigatorSettings

#Region " Private Members "
 Private _moduleId As Integer = -1
 Private _Height As Integer = 320
 Private _Width As Integer = 200
#End Region

#Region " Constructors "
 Public Sub New(ByVal ModuleId As Integer)
  _moduleId = ModuleId

  Dim mc As New ModuleController
  Dim settings As Hashtable = mc.GetModuleSettings(_moduleId)

  If Not settings.Item("Height") Is Nothing Then
   Height = CType(settings.Item("Height"), Integer)
  End If

  If Not settings.Item("Width") Is Nothing Then
   Width = CType(settings.Item("Width"), Integer)
  End If

 End Sub
#End Region

#Region " Public Members "
 Public Overloads Sub SaveSettings()

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  objModules.UpdateModuleSetting(_moduleId, "Height", Me.Height.ToString)
  objModules.UpdateModuleSetting(_moduleId, "Width", Me.Width.ToString)
  DotNetNuke.Common.Utilities.DataCache.RemoveCache(CacheKey(_moduleId))

 End Sub

 Public Shared Function GetNavigatorSettings(ByVal ModuleId As Integer) As NavigatorSettings
  Dim _ms As NavigatorSettings = CType(DotNetNuke.Common.Utilities.DataCache.GetCache(CacheKey(ModuleId)), NavigatorSettings)
  If _ms Is Nothing Then
   _ms = New NavigatorSettings(ModuleId)
   DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey(ModuleId), _ms)
  End If
  Return _ms
 End Function
#End Region

#Region " Properties "
 Private Shared Function CacheKey(ByVal ModuleId As Integer) As String
  Return "NavigatorSettingsModule" & ModuleId.ToString
 End Function

 Public Property Height() As Integer
  Get
   Return _Height
  End Get
  Set(ByVal Value As Integer)
   _Height = Value
  End Set
 End Property

 Public Property Width() As Integer
  Get
   Return _Width
  End Get
  Set(ByVal Value As Integer)
   _Width = Value
  End Set
 End Property
#End Region

End Class
