'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports System.Web.UI.HtmlControls
Imports System.io
Imports System.Xml
Imports DotNetNuke.Entities.Users

Namespace Bring2mind.DNN.Modules.DMX.Navigator
 Public Class GetContents
  Inherits DotNetNuke.Framework.PageBase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents rpProducts As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpTasks As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpInvoice As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpAccount As System.Web.UI.WebControls.Repeater

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
   PageInit()
  End Sub

#End Region

  Private _collectionId As Integer
  Private _tabId As Integer
  Private _moduleId As Integer
  Private _security As DMX.Security.Security
  Private _portalId As Integer
  Private _userId As Integer

  Private Sub PageInit()
   _portalId = Me.PortalSettings.PortalId
   Dim UserName As String = HttpContext.Current.User.Identity.Name
   Dim ui As UserInfo
   If UserName = "" Then
    _userId = -1
    ui = New UserInfo
   Else
    Dim uc As New UserController
    ui = uc.GetUserByUsername(_portalId, UserName)
    _userId = ui.UserID
   End If
   Dim SessionVarKey As String = "DMXSecurityUser" & _userId.ToString & "AndPortal" & _portalId
   Try
    _security = CType(Context.Session(SessionVarKey), DMX.Security.Security)
   Catch ex As Exception
   End Try
   If _security Is Nothing Then
    _security = New DMX.Security.Security(ui, _portalId)
    Context.Session(SessionVarKey) = _security
   End If
  End Sub

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   HttpContext.Current.Response.ContentType = "text/xml"
   'HttpContext.Current.Response.ContentEncoding = System.Text.Encoding.UTF8

   If Not (Request.QueryString("CollectionId") Is Nothing) Then
    _collectionId = Int32.Parse(Request.QueryString("CollectionId"))
   Else
    Exit Sub
   End If
   If Not (Request.QueryString("TabId") Is Nothing) Then
    _tabId = Int32.Parse(Request.QueryString("TabId"))
   Else
    Exit Sub
   End If
   If Not (Request.QueryString("ModuleId") Is Nothing) Then
    _moduleId = Int32.Parse(Request.QueryString("ModuleId"))
   Else
    Exit Sub
   End If

   Dim tvNavigate As New ComponentArt.Web.UI.TreeView

   Dim dt As DataTable = DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.DMX.Data.DataProvider.Instance().GetCollectionContents(False, _collectionId, _portalId, _userId, False))
   dt.Columns.Add("CanView", System.Type.GetType("System.Boolean"), _security.GetFilter("ViewRoles", True))
   dt.Columns.Add("IsCollection", System.Type.GetType("System.Boolean"), "EntryType LIKE '*Collection*'")

   Dim dv As New DataView(dt)
   If _security.IsInGodMode Then
    dv.RowFilter = "NOT Deleted AND IsCollection"
   Else
    dv.RowFilter = "CanView AND NOT Deleted AND IsCollection AND (NOT IsPrivate OR UserId = " & _userId.ToString & ")"
   End If
   dv.Sort = "Description"

   For Each drv As DataRowView In dv
    Dim newNode As New ComponentArt.Web.UI.TreeViewNode
    newNode.Text = drv("Description").ToString()
    newNode.ImageUrl = "folder.gif"
    newNode.NavigateUrl = DotNetNuke.Common.NavigateURL(_tabId, "", "DMXModule=" & _moduleId.ToString, "EntryId=" & CType(drv("EntryId"), String))
    If CType(drv("Subcollections"), Integer) > 0 Then
     newNode.ContentCallbackUrl = DotNetNuke.Common.ResolveUrl("~/DesktopModules/Bring2mind/DMX/Addons/Navigator/GetContents.aspx") & "?CollectionId=" & drv("EntryId").ToString() & "&TabId=" & _tabId.ToString & "&ModuleId=" & _moduleId.ToString
    End If
    tvNavigate.Nodes.Add(newNode)
   Next

   Response.Write(tvNavigate.GetXml)

  End Sub

 End Class
End Namespace
