﻿Imports System
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.DMX.Business
Imports Bring2mind.DNN.Modules.DMX.Common
Imports System.Collections.Generic

Partial Public Class Navigator
 Inherits DMX.Framework.ModuleBase

#Region " Controls "
#End Region

#Region " Private Members "
 Private _baseUrl As String = Nothing
 Private _navigatorSettings As NavigatorSettings = Nothing
#End Region

#Region " Public Members "
 Public ReadOnly Property BaseUrl() As String
  Get
   If _baseUrl Is Nothing Then
    _baseUrl = DotNetNuke.Common.NavigateURL(TabId)
    If _baseUrl.ToLower.Contains(".aspx?") Then
     _baseUrl &= "&"
    Else
     _baseUrl &= "?"
    End If
   End If
   Return _baseUrl
  End Get
 End Property

 Public Property NavigatorSettings() As NavigatorSettings
  Get
   If _navigatorSettings Is Nothing Then
    _navigatorSettings = NavigatorSettings.GetNavigatorSettings(ModuleId)
   End If
   Return _navigatorSettings
  End Get
  Set(ByVal value As NavigatorSettings)
   _navigatorSettings = value
  End Set
 End Property
#End Region

#Region " Page Events "
 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
  Try


   If Not Me.IsPostBack Then
    With tvNavigate
     If NavigatorSettings.Height > 0 Then
      .Height = Unit.Pixel(NavigatorSettings.Height)
     End If
     If NavigatorSettings.Width > 0 Then
      .Width = Unit.Pixel(NavigatorSettings.Width)
     End If
    End With
    Dim rt As Integer = 0
    If Me.Query.CategoryId > -1 Then
     initTreeView("cat" & Me.Query.CategoryId.ToString)
    ElseIf Me.Query.EntryId > -1 Then
     If Me.Query.RequestedEntry.IsCollection Then
      initTreeView("ent" & Me.Query.EntryId.ToString)
     Else
      initTreeView("ent" & Me.Query.RequestedEntry.CollectionId.ToString)
     End If
    Else
     initTreeView("")
    End If

   End If

  Catch exc As Exception
   DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
  End Try
 End Sub
#End Region

#Region " Private Methods "
 Private Sub initTreeView(ByVal selectedId As String)

  Dim selectedNodeChain As Hashtable = Nothing
  If selectedId = "" Then
   Select Case Me.Query.ViewType
    Case ViewType.CollectionView, ViewType.DetailsView
     If Me.Query.EntryId > 0 Then
      If Me.Query.RequestedEntry.IsCollection Then
       selectedId = "ent" & Me.Query.EntryId.ToString
      Else
       selectedId = "ent" & Me.Query.RequestedEntry.CollectionId.ToString
      End If
     End If
    Case ViewType.CategoryView
     If Me.Query.CategoryId > 0 Then
      selectedId = "cat" & Me.Query.CategoryId.ToString
     End If
   End Select
  End If

  If selectedId.StartsWith("ent") Then
   selectedNodeChain = Common.EntryUtils.GetCollectionNodeChain(PortalId, Integer.Parse(Mid(selectedId, 4)))
  ElseIf selectedId.StartsWith("cat") Then
   selectedNodeChain = Common.CategoryUtils.GetCategoryNodeChain(PortalId, Integer.Parse(Mid(selectedId, 4)))
  End If

  tvNavigate.Nodes.Clear()

  ' What is commented out might be implemented later. It will show categories, subscriptions etc. For now TemplateView will not show this from the querystring
  'Dim dv As DataView = DMX.Framework.ExtensionController.GetExtensions(PortalId, UserId, True, "", "Contents.%")
  'dv.Sort = "Custom"
  'For Each drv As DataRowView In dv
  'Dim provider As String = CStr(drv("ControlToLoad"))
  'Dim prov As Object = DotNetNuke.Framework.Reflection.CreateObject(provider, provider)
  'If TypeOf (prov) Is UI.IContentProvider Then
  'Dim icp As UI.IContentProvider = CType(prov, UI.IContentProvider)
  Dim icp As UI.IContentProvider = CType(New EntriesController, UI.IContentProvider)
  Dim rootNodes As List(Of Global.ComponentArt.Web.UI.TreeViewNode) = icp.GetRootNodes(Me.PortalSettings, TabId, ModuleId, Me.Settings.ModuleSettings, Me.UserInfo, Me.CurrentUser.IsInGodMode)
  For Each rootNode As Global.ComponentArt.Web.UI.TreeViewNode In rootNodes
   If rootNode.ID.StartsWith("ent") Or rootNode.ID.StartsWith("cat") Then
    tvNavigate.Nodes.Add(rootNode)
    icp.AddContentsToTreeNode(Me.PortalSettings, TabId, ModuleId, Me.Settings.ModuleSettings, UserInfo, Me.CurrentUser.IsInGodMode, rootNode.ID, Nothing, rootNode, selectedNodeChain)
   End If
  Next
  'End If
  'Next

  If selectedId <> "" Then
   tvNavigate.SelectedNode = tvNavigate.FindNodeById(selectedId)
  End If

 End Sub
#End Region

End Class