﻿Imports System
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Services.Exceptions

Partial Public Class Settings
 Inherits Entities.Modules.ModuleSettingsBase

#Region " Controls "
 Protected WithEvents ctlDmxSettings As DMX.Controls.Admin.Settings
#End Region

#Region " Base Method Implementations "
 Public Overrides Sub LoadSettings()
  Try
   If Not Page.IsPostBack Then
    ctlDmxSettings.LoadSettings()
    Dim Settings As New NavigatorSettings(Me.ModuleId)
    With Settings
     txtHeight.Text = .Height.ToString
     txtWidth.Text = .Width.ToString
    End With
   End If
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Public Overrides Sub UpdateSettings()
  Try

   ctlDmxSettings.UpdateSettings()

   Dim Settings As New NavigatorSettings(Me.ModuleId)
   With Settings
    .Height = Integer.Parse(txtHeight.Text)
    .Width = Integer.Parse(txtWidth.Text)
    .SaveSettings()
   End With

   Dim CacheKey As String = "Settings4Module" & Me.ModuleId & "inPortal" & Me.PortalId
   Me.Cache.Remove(CacheKey)

   Response.Redirect(NavigateURL(), True)
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

#End Region

#Region " Page Events "
 Private Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init

  ctlDmxSettings.ModuleConfiguration = Me.ModuleConfiguration
  ctlDmxSettings.LocalResourceFile = "DesktopModules/Bring2mind/DMX/Admin/App_LocalResources/Settings"

 End Sub
#End Region

End Class
