﻿Imports System
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Services.Localization.Localization
Imports System.Xml

Partial Public Class List
 Inherits PortalModuleBase

 Dim OurQuestionnaire As QuestionnaireTemplate.questionnaireRow

#Region " Page Events "
 Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init

  Try
   OurQuestionnaire = Me.Questionnaire.questionnaire.Rows(0)
  Catch ex As Exception
  End Try

 End Sub

 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  ' First check to see if we have a questionnaire at all
  If Me.Questionnaire Is Nothing Then
   Dim dl As New Dialog
   With dl
    .Title = GetString("NoQuestionnaireTitle", Me.LocalResourceFile)
    .Description = GetString("NoQuestionnaireDescription", Me.LocalResourceFile)
   End With
   Me.Controls.Add(dl)
   cmdDownload.Visible = False
   pnlSearch.Visible = False
   pnlFilter.Visible = False
   Exit Sub
  End If

  cmdDownload.Visible = (Me.Permission = "ADMIN") AndAlso Me.ModuleSettings.SaveResults AndAlso IO.File.Exists(Me.ModuleSettings.ResultsFile(OurQuestionnaire, True))

  ' Check to see if we should show the list
  If Me.ModuleSettings.ResultsPublic Then
   'Try
   If IO.File.Exists(Me.ModuleSettings.ResultsFile(OurQuestionnaire, True)) And IO.File.Exists(Me.ModuleSettings.UploadMapPath & Me.ModuleSettings.ListXslt) Then
    xmlList.DocumentSource = Me.ModuleSettings.ResultsFile(OurQuestionnaire, False)
    'xmlList.TransformSource = Me.ModuleSettings.UploadPath & Me.ModuleSettings.ListXslt
    Dim xslRd As New XmlTextReader(Me.ListXslt, XmlNodeType.Document, Nothing)
    Dim xslTrans As New Xsl.XslTransform
    xslTrans.Load(xslRd, New XmlUrlResolver, Nothing)
    xslRd.Close()
    xslRd = Nothing
    xmlList.Transform = xslTrans
    If Not Me.IsPostBack Then
     If Me.SearchFields.Count < 1 Or Me.Query.DetailId <> "" Then
      pnlSearch.Visible = False
     Else
      With ddSearchFields
       .DataSource = Me.SearchFields
       .DataBind()
      End With
      If Not Me.Request.Params("sfield") Is Nothing Then
       Try
        ddSearchFields.Items.FindByValue(Me.Request.Params("sfield")).Selected = True
        txtSearch.Text = Me.Request.Params("stext")
       Catch ex As Exception
       End Try
      End If
     End If
    End If
    If Me.FilterFields.Count < 1 Or Me.Query.DetailId <> "" Then
     pnlFilter.Visible = False
    Else
     For Each ff As FilterField In Me.FilterFields
      Dim lbl As New Label, td As New HtmlTableCell, dd As New DropDownList
      With lbl
       .CssClass = "Normal"
       .Text = ff.FieldName & "&nbsp;"
      End With
      td.Controls.Add(lbl)
      With dd
       .ID = ff.FieldId
       .DataTextField = "Value"
       .DataValueField = "Key"
       .DataSource = ff.Values
       .DataBind()
       .Items.Insert(0, New ListItem(GetString("Select", Me.LocalResourceFile), ""))
       .AutoPostBack = True
      End With
      AddHandler dd.SelectedIndexChanged, AddressOf FilterChanged
      If Not Me.Request.Params(ff.FieldId) Is Nothing Then
       Try
        dd.Items.FindByValue(Me.Request.Params(ff.FieldId)).Selected = True
       Catch ex As Exception
       End Try
      End If
      td.Controls.Add(dd)
      pnlFilter.Rows(1).Cells.Add(td)
     Next
    End If
   Else
    Dim dl As New Dialog
    With dl
     .Title = GetString("ErrorTitle", Me.LocalResourceFile)
     .Description = GetString("ErrorDescription", Me.LocalResourceFile)
    End With
    If Me.UserId > -1 And Me.IsEditable Then
     Dim li As New ListItem(GetString("EditMyData", Me.LocalResourceFile), Me.EditUrl("Questionnaire"))
     Dim al As New ArrayList
     al.Add(li)
     dl.Buttons = al
    End If
    Me.Controls.Add(dl)
    pnlSearch.Visible = False
    pnlFilter.Visible = False
   End If
   'Catch ex As Exception
   'End Try
   Exit Sub ' Leave as the rest is just for displaying the questionnaire
  End If

  pnlSearch.Visible = False
  pnlFilter.Visible = False

  If Not ModuleSettings.AllowMultiple And UserId > -1 Then
   Dim bSubmitted As Boolean, qkey As String
   If OurQuestionnaire.IsquestionnaireidNull Then
    qkey = "Questionnaire_" & ModuleId.ToString
   Else
    qkey = "Questionnaire_" & OurQuestionnaire.questionnaireid
   End If
   If Not DotNetNuke.Services.Personalization.Personalization.GetProfile(qkey, "Submitted") Is Nothing Then
    bSubmitted = CType(DotNetNuke.Services.Personalization.Personalization.GetProfile(qkey, "Submitted"), Boolean)
   Else
    bSubmitted = False
   End If
   If bSubmitted Then
    Dim dl As New Dialog
    With dl
     .Title = GetString("AlreadySubmittedTitle", Me.LocalResourceFile)
     .Description = GetString("AlreadySubmittedDescription", Me.LocalResourceFile)
    End With
    Me.Controls.Add(dl)
    Exit Sub
   End If
  End If

  Dim sControl As String = "Questionnaire.ascx"
  Dim objModule As PortalModuleBase = CType(Me.LoadControl(IO.Path.Combine(Me.TemplateSourceDirectory, sControl)), PortalModuleBase)
  With objModule
   .ModuleSettings = Me.ModuleSettings
   .Questionnaire = Me.Questionnaire
   .ModuleConfiguration = Me.ModuleConfiguration
   .ID = System.IO.Path.GetFileNameWithoutExtension(sControl) 'needed for localization
  End With
  Me.Controls.Add(objModule)

 End Sub

 Private Sub cmdSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdSearch.Click

  Dim NewUrl As String = DotNetNuke.Common.NavigateURL(TabId, "", "sfield=" & ddSearchFields.SelectedValue, "stext=" & txtSearch.Text.Trim)
  Response.Redirect(NewUrl, True)

 End Sub

 Public Sub FilterChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddSearchFields.SelectedIndexChanged

  Dim dd As DropDownList = CType(sender, DropDownList)
  Dim field As String = dd.ID
  Dim pr As New Collections.Specialized.NameValueCollection

  If txtSearch.Text.Trim <> "" Then
   pr.Add("sfield", ddSearchFields.SelectedValue)
   pr.Add("stext", txtSearch.Text.Trim)
  End If

  For Each ff As FilterField In Me.FilterFields
   If ff.FieldId = field Then
    If dd.SelectedValue <> "" Then
     pr.Add(field, dd.SelectedValue)
    End If
   Else
    If Not Me.Request.Params(ff.FieldId) Is Nothing Then
     pr.Add(ff.FieldId, Me.Request.Params(ff.FieldId))
    End If
   End If
  Next
  Dim prs(pr.Count - 1) As String
  For i As Integer = 0 To pr.Count - 1
   prs(i) = pr.GetKey(i) & "=" & pr(i)
  Next

  Dim NewUrl As String = DotNetNuke.Common.NavigateURL(TabId, "", prs)
  Response.Redirect(NewUrl, True)

 End Sub

 Private Sub cmdDownload_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDownload.Click

  If IO.File.Exists(Me.ModuleSettings.ResultsFile(OurQuestionnaire, True)) Then

   Response.ClearHeaders()
   Response.ClearContent()
   Response.AddHeader("Content-Disposition", "attachment; filename=QuestionnaireResults.xml")
   Response.ContentType = "text/xml"
   Response.Charset = "UTF-8"
   Response.WriteFile(Me.ModuleSettings.ResultsFile(OurQuestionnaire, True))
   Response.Flush()
   Response.End()

  End If

 End Sub
#End Region

#Region " Optional Interfaces "
 'Public ReadOnly Property ModuleActions() As DotNetNuke.Entities.Modules.Actions.ModuleActionCollection Implements DotNetNuke.Entities.Modules.IActionable.ModuleActions
 ' Get
 '  Dim Actions As New Entities.Modules.Actions.ModuleActionCollection
 '  Actions.Add(GetNextActionID, GetString(Entities.Modules.Actions.ModuleActionType.ContentOptions, Me.LocalResourceFile), Entities.Modules.Actions.ModuleActionType.ContentOptions, "", "../DesktopModules/Bring2mind/Questionnaire/icon_Questionnaire_16px.gif", EditUrl("Options"), False, DotNetNuke.Security.SecurityAccessLevel.Admin, True, False)
 '  Return Actions
 ' End Get
 'End Property
#End Region

End Class
