﻿/****** TABLES AND PRIMARY KEYS ******/
if not exists (select * from dbo.sysobjects where id = object_id(N'{databaseOwner}{objectQualifier}DMX_Repository') and OBJECTPROPERTY(id, N'IsTable') = 1)
CREATE TABLE {databaseOwner}{objectQualifier}DMX_Repository (
 [Blob] VARBINARY(MAX),
 [BlobId] INT IDENTITY (1, 1),
 [PortalId] INT
) ON [PRIMARY]
GO

if not exists (select * from dbo.sysobjects where id = object_id(N'PK_{objectQualifier}DMX_Repository') and OBJECTPROPERTY(id, N'IsPrimaryKey') = 1)
ALTER TABLE {databaseOwner}{objectQualifier}DMX_Repository ADD CONSTRAINT
	PK_{objectQualifier}DMX_Repository PRIMARY KEY CLUSTERED 
	(
	[BlobId]
	) ON [PRIMARY]
GO


/****** PROCEDURES ******/

if not exists (select * from dbo.sysobjects where id = object_id(N'FK_{objectQualifier}DMX_Repository_{objectQualifier}Portals') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE {databaseOwner}{objectQualifier}DMX_Repository ADD CONSTRAINT
	FK_{objectQualifier}DMX_Repository_{objectQualifier}Portals FOREIGN KEY
	(
    PortalId
	) REFERENCES {databaseOwner}{objectQualifier}Portals
	(
    PortalID
	) ON DELETE CASCADE
	 NOT FOR REPLICATION

GO

IF EXISTS (select * from dbo.sysobjects where id = object_id(N'{databaseOwner}{objectQualifier}DMX_GetFromRepository') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE {databaseOwner}{objectQualifier}DMX_GetFromRepository
GO

CREATE PROCEDURE {databaseOwner}{objectQualifier}DMX_GetFromRepository
	@BlobId Int,
 @PortalId int
AS

SELECT
	[Blob],
	[BlobId],
	[PortalId]
FROM
	{databaseOwner}{objectQualifier}DMX_Repository
WHERE
	[BlobId] = @BlobId
	AND [PortalId] = @PortalId
GO


IF EXISTS (select * from dbo.sysobjects where id = object_id(N'{databaseOwner}{objectQualifier}DMX_AddToRepository') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE {databaseOwner}{objectQualifier}DMX_AddToRepository
GO

CREATE PROCEDURE {databaseOwner}{objectQualifier}DMX_AddToRepository
	@PortalId Int
AS

INSERT INTO {databaseOwner}{objectQualifier}DMX_Repository (
	[Blob],
	[PortalId]
) VALUES (
	0x0,
	@PortalId
)

select SCOPE_IDENTITY()
GO


IF EXISTS (select * from dbo.sysobjects where id = object_id(N'{databaseOwner}{objectQualifier}DMX_DeleteFromRepository') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE {databaseOwner}{objectQualifier}DMX_DeleteFromRepository
GO

CREATE PROCEDURE {databaseOwner}{objectQualifier}DMX_DeleteFromRepository
	@BlobId Int
AS

DELETE FROM {databaseOwner}{objectQualifier}DMX_Repository
WHERE
	[BlobId] = @BlobId
GO


