Imports System.IO
Imports DotNetNuke.Services.Localization
Imports DotNetNuke.Services.Exceptions
Imports System.Net.Mail
Imports DotNetNuke.Entities.Portals

Public Enum MeasureType As Integer
 SqlRowset = 1
 SqlScalar = 2
 MathExpression = 3
End Enum

Public Enum Interval As Integer
 Daily = 0
 Weekly = 1
 Monthly = 2
End Enum

Public Enum Periods As Integer
 Custom = 0
 MonthToDate = 1
 LastMonth = 2
 Past7Days = 3
 LastWeek = 4
 Past24Hours = 5
 Yesterday = 6
End Enum

Public Module Globals

 Public Const SharedResourceFile As String = "DesktopModules/Bring2mind/SiteReport/App_LocalResources/SharedResources"
 Public Const EmailPermissionKey As String = "EMAIL"

 Public Function GetStringValue(ByVal xValue As Object) As String
  If xValue Is Nothing Then
   Return ""
  ElseIf xValue Is DBNull.Value Then
   Return ""
  Else
   If xValue.GetType Is GetType(Date) Then
    Return CType(xValue, Date).ToUniversalTime.ToString("u")
   Else
    Return CType(xValue, String)
   End If
  End If
 End Function

 Public Function GetIntegerValue(ByVal xValue As Object) As Integer
  If xValue Is Nothing Then
   Return -1
  ElseIf xValue Is DBNull.Value Then
   Return -1
  Else
   Return CType(xValue, Integer)
  End If
 End Function

 Public Function GetMeasureType(ByVal TypeCode As Integer) As String
  Return CType(TypeCode, MeasureType).ToString
 End Function

 Public Sub GetFileListRecursive(ByVal CurrentDirectory As DirectoryInfo, ByRef List As ArrayList)
  GetFileListRecursive(CurrentDirectory, List, "", "")
 End Sub

 Public Sub GetFileListRecursive(ByVal CurrentDirectory As DirectoryInfo, ByRef List As ArrayList, ByVal strExtensions As String)
  GetFileListRecursive(CurrentDirectory, List, strExtensions, "")
 End Sub

 Public Sub GetFileListRecursive(ByVal CurrentDirectory As DirectoryInfo, ByRef List As ArrayList, ByVal strExtensions As String, ByVal CurrentPath As String)

  Dim Directories As String() = Directory.GetDirectories(CurrentDirectory.FullName)
  Dim Dir As String
  For Each Dir In Directories
   GetFileListRecursive(New DirectoryInfo(Dir), List, strExtensions, CurrentPath & Mid(Dir, InStrRev(Dir, "\") + 1))
  Next

  Dim strExtension As String = ""
  Dim File As String
  Dim Files As String() = Directory.GetFiles(CurrentDirectory.FullName)
  For Each File In Files
   If Convert.ToBoolean(InStr(1, File, ".")) Then
    strExtension = Mid(File, InStrRev(File, ".") + 1)
   End If
   Dim FileName As String = File.Substring(CurrentDirectory.FullName.Length)
   If InStr(1, strExtensions.ToUpper, strExtension.ToUpper) <> 0 Or strExtensions = "" Then
    List.Add(New DotNetNuke.Common.FileItem(CurrentPath & FileName, CurrentPath & FileName))
   End If
  Next

 End Sub

 Private Function GetHostSettingAsBoolean(ByVal key As String, ByVal defaultValue As Boolean) As Boolean
  Dim retValue As Boolean
  Try
   Dim setting As String = DotNetNuke.Entities.Host.HostSettings.GetHostSetting(key)
   If String.IsNullOrEmpty(setting) Then
    retValue = defaultValue
   Else
    retValue = (setting.ToUpperInvariant().StartsWith("Y") OrElse setting.ToUpperInvariant = "TRUE")
   End If
  Catch ex As Exception
   'we just want to trap the error as we may not be installed so there will be no Settings
  End Try
  Return retValue
 End Function

 Public Function SendMail(ByVal message As System.Net.Mail.MailMessage) As String

  SendMail = ""

  ' SMTP server configuration
  Dim SMTPServer As String = DotNetNuke.Entities.Host.HostSettings.GetHostSetting("SMTPServer")
  Dim SMTPUsername As String = DotNetNuke.Entities.Host.HostSettings.GetHostSetting("SMTPUsername")
  Dim SMTPPassword As String = DotNetNuke.Entities.Host.HostSettings.GetHostSetting("SMTPPassword")
  Dim SMTPAuthentication As String = DotNetNuke.Entities.Host.HostSettings.GetHostSetting("SMTPAuthentication")
  Dim SMTPEnableSSL As Boolean = GetHostSettingAsBoolean("SMTPEnableSSL", False)

  If message IsNot Nothing Then

   ' external SMTP server alternate port
   Dim SmtpPort As Integer = DotNetNuke.Common.Utilities.Null.NullInteger
   Dim portPos As Integer = SMTPServer.IndexOf(":")
   If portPos > -1 Then
    SmtpPort = Int32.Parse(SMTPServer.Substring(portPos + 1, SMTPServer.Length - portPos - 1))
    SMTPServer = SMTPServer.Substring(0, portPos)
   End If

   Dim smtpClient As New Net.Mail.SmtpClient()

   If SMTPServer <> "" Then
    smtpClient.Host = SMTPServer
    If SmtpPort > DotNetNuke.Common.Utilities.Null.NullInteger Then
     smtpClient.Port = SmtpPort
    End If
    Select Case SMTPAuthentication
     Case "", "0" ' anonymous
     Case "1" ' basic
      If SMTPUsername <> "" And SMTPPassword <> "" Then
       smtpClient.UseDefaultCredentials = False
       smtpClient.Credentials = New System.Net.NetworkCredential(SMTPUsername, SMTPPassword)
      End If
     Case "2" ' NTLM
      smtpClient.UseDefaultCredentials = True
    End Select
   End If
   smtpClient.EnableSsl = SMTPEnableSSL

   Try
    smtpClient.Send(message)
    SendMail = ""
   Catch exc As SmtpFailedRecipientException
    SendMail = "FailedRecipient"
    LogException(exc)
   Catch exc As SmtpException
    SendMail = "SMTPConfigurationProblem"
    LogException(exc)
   Catch objException As Exception
    ' mail configuration problem
    If Not IsNothing(objException.InnerException) Then
     SendMail = String.Concat(objException.Message, ControlChars.CrLf, objException.InnerException.Message)
     LogException(objException.InnerException)
    Else
     SendMail = objException.Message
     LogException(objException)
    End If
   Finally
    message.Dispose()
   End Try
  End If

 End Function

End Module
