﻿Imports System
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Services.Exceptions
Imports Bring2mind.DNN.Modules.SiteReport.Business

Partial Public Class EditMeasure
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Variables "
 Private _measureId As Integer = -1
 Private _ReportID As Integer = -1

 Public Property MeasureId() As Integer
  Get
   Return _measureId
  End Get
  Set(ByVal value As Integer)
   _measureId = value
  End Set
 End Property

 Public Property ReportID() As Integer
  Get
   Return _ReportID
  End Get
  Set(ByVal value As Integer)
   _ReportID = value
  End Set
 End Property

#End Region

#Region " Event Handlers "
 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  ReportID = Int32.Parse(Request.Params("ReportId"))
  If Not (Request.Params("MeasureId") Is Nothing) Then
   MeasureId = Int32.Parse(Request.Params("MeasureId"))
  Else
   MeasureId = -1
  End If

  If Not Page.IsPostBack Then
   cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
   With ddType
    .Items.Add(New ListItem("Rowset", "1"))
    .Items.Add(New ListItem("Scalar", "2"))
    .Items.Add(New ListItem("Math", "3"))
   End With
   If MeasureId <> -1 Then
    Dim objMeasure As MeasureInfo = MeasuresController.GetMeasure(MeasureId)
    If Not objMeasure Is Nothing Then
     'set screen
     txtCode.Text = objMeasure.Code
     txtColumnFormatting.Text = objMeasure.ColumnFormatting
     txtDescription.Text = objMeasure.Description
     txtKey.Text = objMeasure.Key
     txtName.Text = objMeasure.Name
     If Not (objMeasure.Order = Null.NullInteger) Then
      txtOrder.Text = objMeasure.Order.ToString
     End If
     txtRowFilter.Text = objMeasure.RowFilter
     txtSortExpression.Text = objMeasure.SortExpression
     If Not (objMeasure.Type = Null.NullInteger) Then
      ddType.Items.FindByValue(objMeasure.Type.ToString).Selected = True
     End If
     txtExtraColumns.Text = objMeasure.ExtraColumns
    Else ' security violation attempt to access item not related to this Module
     Response.Redirect(NavigateURL(), True)
    End If
   Else
    'Initialize New Record
    cmdDelete.Visible = False
    Dim objMeasures As New MeasuresController
    txtOrder.Text = (MeasuresController.GetMeasuresByReport(ReportID).Count + 1).ToString
   End If
  Else
   'its a postback
  End If
 End Sub

 Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
  Try
   ' Only Update if the Entered Data is Valid
   If Page.IsValid = True Then
    Dim objMeasure As New MeasureInfo

    'bind text values to object
    With objMeasure
     'set values
     .Code = txtCode.Text
     .ColumnFormatting = txtColumnFormatting.Text
     .ExtraColumns = txtExtraColumns.Text
     .Description = txtDescription.Text
     .Key = txtKey.Text
     .MeasureID = MeasureId
     .Name = txtName.Text
     If txtOrder.Text <> "" Then
      .Order = Integer.Parse(txtOrder.Text)

      ' resort
      'Dim drv As DataRowView, dv As New DataView(DotNetNuke.Common.ConvertDataReaderToDataTable(Data.DataProvider.Instance().GetMeasuresByModules(ModuleId)))
      Dim m As MeasureInfo, i As Integer = .Order
      For Each m In MeasuresController.GetMeasuresByReport(ReportID)
       If m.Order >= i And m.MeasureID <> MeasureId Then
        i += 1
        m.Order = i
        MeasuresController.UpdateMeasure(m)
       End If
      Next

     Else
      .Order = Nothing
     End If
     '.ModuleId = ModuleId
     .ReportId = ReportID
     .RowFilter = txtRowFilter.Text
     .SortExpression = txtSortExpression.Text
     .Type = Integer.Parse(ddType.SelectedValue)
    End With

    If MeasureId = -1 Then
     MeasureId = MeasuresController.AddMeasure(objMeasure)
    Else
     MeasuresController.UpdateMeasure(objMeasure)
    End If

    Response.Redirect(EditUrl("ReportId", ReportID.ToString, "EditReport"), False)

   End If
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
  Try
   Response.Redirect(EditUrl("ReportId", ReportID.ToString, "EditReport"), False)
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
  Try
   If Not MeasureId = -1 Then
    MeasuresController.DeleteMeasure(MeasureId)
   End If
   Response.Redirect(EditUrl("ReportId", ReportID.ToString, "EditReport"), False)
  Catch exc As Exception 'Module failed to load
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub
#End Region

#Region " Optional Interfaces "
#End Region

#Region " Private Methods "
#End Region

#Region " Public Methods "
#End Region

End Class