Public Class ModuleSettings

#Region " Private Members "
 Private _Interval As Interval = Bring2mind.DNN.Modules.SiteReport.Interval.Weekly
 Private _Processing As String = ""
 Private _NextSend As Date = Now
 Private _ScreenStyleSheet As String = ""
 Private _MailStyleSheet As String = ""
 Private _sendAdmins As Boolean = False
 Private _emailSQL As String = ""
#End Region

#Region " Constructors "
 Friend Sub New(ByVal ModuleId As Integer)

  Dim mc As New DotNetNuke.Entities.Modules.ModuleController
  Dim ms As Hashtable = mc.GetModuleSettings(ModuleId)

  If Not ms.Item("Interval") Is Nothing Then
   Interval = CType(ms.Item("Interval"), Interval)
  End If

  If Not ms.Item("Processing") Is Nothing Then
   Processing = CType(ms.Item("Processing"), String)
  End If

  If Not ms.Item("NextSend") Is Nothing Then
   Try
    NextSend = CType(ms.Item("NextSend"), Date)
   Catch
   End Try
   If NextSend = Date.MinValue Then
    NextSend = Now
   End If
   If NextSend.Year < 2000 Then
    NextSend = Now
   End If
  End If

  If Not ms.Item("ScreenStyleSheet") Is Nothing Then
   ScreenStyleSheet = CType(ms.Item("ScreenStyleSheet"), String)
  End If

  If Not ms.Item("MailStyleSheet") Is Nothing Then
   MailStyleSheet = CType(ms.Item("MailStyleSheet"), String)
  End If

  If Not ms.Item("SendAdmins") Is Nothing Then
   SendAdmins = CType(ms.Item("SendAdmins"), Boolean)
  End If

  If Not ms.Item("EmailSQL") Is Nothing Then
   EmailSQL = CType(ms.Item("EmailSQL"), String)
  End If

 End Sub
#End Region

#Region " Public Members "
 Public Sub SaveSettings(ByVal ModuleId As Integer)

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  objModules.UpdateModuleSetting(ModuleId, "Interval", CType(Me.Interval, Integer).ToString)
  objModules.UpdateModuleSetting(ModuleId, "Processing", Me.Processing.ToString)
  objModules.UpdateModuleSetting(ModuleId, "NextSend", Me.NextSend.ToUniversalTime.ToString("u"))
  objModules.UpdateModuleSetting(ModuleId, "ScreenStyleSheet", Me.ScreenStyleSheet.ToString)
  objModules.UpdateModuleSetting(ModuleId, "MailStyleSheet", Me.MailStyleSheet.ToString)
  objModules.UpdateModuleSetting(ModuleId, "SendAdmins", Me.SendAdmins.ToString)
  objModules.UpdateModuleSetting(ModuleId, "EmailSQL", Me.EmailSQL)

 End Sub
#End Region

#Region " Properties "
 Public Property Interval() As Interval
  Get
   Return _Interval
  End Get
  Set(ByVal Value As Interval)
   _Interval = Value
  End Set
 End Property

 Public Property Processing() As String
  Get
   Return _Processing
  End Get
  Set(ByVal Value As String)
   _Processing = Value
  End Set
 End Property

 Public Property NextSend() As Date
  Get
   Return _NextSend
  End Get
  Set(ByVal Value As Date)
   _NextSend = Value
  End Set
 End Property

 Public Property ScreenStyleSheet() As String
  Get
   Return _ScreenStyleSheet
  End Get
  Set(ByVal Value As String)
   _ScreenStyleSheet = Value
  End Set
 End Property

 Public Property MailStyleSheet() As String
  Get
   Return _MailStyleSheet
  End Get
  Set(ByVal Value As String)
   _MailStyleSheet = Value
  End Set
 End Property

 Public Property SendAdmins() As Boolean
  Get
   Return _sendAdmins
  End Get
  Set(ByVal value As Boolean)
   _sendAdmins = value
  End Set
 End Property

 Public Property EmailSQL() As String
  Get
   Return _emailSQL
  End Get
  Set(ByVal value As String)
   _emailSQL = value
  End Set
 End Property
#End Region

End Class
