Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Microsoft.ApplicationBlocks.Data

Namespace Data

 Public Class SqlDataProvider
  Inherits DataProvider

#Region " Private Members "

  Private Const ProviderType As String = "data"
  Private _providerConfiguration As DotNetNuke.Framework.Providers.ProviderConfiguration = DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration(ProviderType)
  Private _connectionString As String
  Private _providerPath As String
  Private _objectQualifier As String
  Private _databaseOwner As String

#End Region

#Region " Constructors "

  Public Sub New()

   ' Read the configuration specific information for this provider
   Dim objProvider As DotNetNuke.Framework.Providers.Provider = CType(_providerConfiguration.Providers(_providerConfiguration.DefaultProvider), DotNetNuke.Framework.Providers.Provider)

   ' Read the attributes for this provider
   If objProvider.Attributes("connectionStringName") <> "" AndAlso _
   System.Configuration.ConfigurationManager.AppSettings(objProvider.Attributes("connectionStringName")) <> "" Then
    _connectionString = System.Configuration.ConfigurationManager.AppSettings(objProvider.Attributes("connectionStringName"))
   Else
    _connectionString = objProvider.Attributes("connectionString")
   End If

   _providerPath = objProvider.Attributes("providerPath")

   _objectQualifier = objProvider.Attributes("objectQualifier")
   If _objectQualifier <> "" And _objectQualifier.EndsWith("_") = False Then
    _objectQualifier += "_"
   End If

   _databaseOwner = objProvider.Attributes("databaseOwner")
   If _databaseOwner <> "" And _databaseOwner.EndsWith(".") = False Then
    _databaseOwner += "."
   End If

  End Sub

#End Region

#Region " Properties "

  Public ReadOnly Property ConnectionString() As String
   Get
    Return _connectionString
   End Get
  End Property

  Public ReadOnly Property ProviderPath() As String
   Get
    Return _providerPath
   End Get
  End Property

  Public ReadOnly Property ObjectQualifier() As String
   Get
    Return _objectQualifier
   End Get
  End Property

  Public ReadOnly Property DatabaseOwner() As String
   Get
    Return _databaseOwner
   End Get
  End Property

#End Region

#Region " General Methods "
  Public Overrides Function GetNull(ByVal Field As Object) As Object
   Return DotNetNuke.Common.Utilities.Null.GetNull(Field, DBNull.Value)
  End Function
#End Region


#Region " Measures Methods "

  Public Overrides Function GetMeasure(ByVal MeasureID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_GetMeasure", MeasureID), IDataReader)
  End Function

  Public Overrides Function AddMeasure(ByVal Code As String, ByVal ColumnFormatting As String, ByVal Description As String, ByVal ExtraColumns As String, ByVal Key As String, ByVal Name As String, ByVal Order As Integer, ByVal ReportId As Integer, ByVal RowFilter As String, ByVal SortExpression As String, ByVal Type As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_AddMeasure", GetNull(Code), GetNull(ColumnFormatting), GetNull(Description), GetNull(ExtraColumns), GetNull(Key), GetNull(Name), GetNull(Order), ReportId, GetNull(RowFilter), GetNull(SortExpression), GetNull(Type)), Integer)
  End Function

  Public Overrides Sub UpdateMeasure(ByVal MeasureID As Integer, ByVal Code As String, ByVal ColumnFormatting As String, ByVal Description As String, ByVal ExtraColumns As String, ByVal Key As String, ByVal Name As String, ByVal Order As Integer, ByVal ReportId As Integer, ByVal RowFilter As String, ByVal SortExpression As String, ByVal Type As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_UpdateMeasure", MeasureID, GetNull(Code), GetNull(ColumnFormatting), GetNull(Description), GetNull(ExtraColumns), GetNull(Key), GetNull(Name), GetNull(Order), ReportId, GetNull(RowFilter), GetNull(SortExpression), GetNull(Type))
  End Sub

  Public Overrides Sub DeleteMeasure(ByVal MeasureID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_DeleteMeasure", MeasureID)
  End Sub

  Public Overrides Function GetMeasuresByReport(ByVal ReportId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_GetMeasuresByReport", ReportId), IDataReader)
  End Function

#End Region

#Region " Reports Methods "

  Public Overrides Function GetReport(ByVal ReportId As Integer, ByVal ModuleId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_GetReport", ReportId, ModuleId), IDataReader)
  End Function

  Public Overrides Function AddReport(ByVal LastModified As Date, ByVal LastModifiedBy As Integer, ByVal ModuleId As Integer, ByVal Summary As String, ByVal Title As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_AddReport", GetNull(LastModified), LastModifiedBy, ModuleId, GetNull(Summary), GetNull(Title)), Integer)
  End Function

  Public Overrides Sub UpdateReport(ByVal ReportId As Integer, ByVal LastModified As Date, ByVal LastModifiedBy As Integer, ByVal ModuleId As Integer, ByVal Summary As String, ByVal Title As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_UpdateReport", ReportId, GetNull(LastModified), LastModifiedBy, ModuleId, GetNull(Summary), GetNull(Title))
  End Sub

  Public Overrides Sub DeleteReport(ByVal ReportId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_DeleteReport", ReportId)
  End Sub

  Public Overrides Function GetReportsByModule(ByVal ModuleID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_GetReportsByModule", ModuleID), IDataReader)
  End Function

#End Region

#Region " Generic Methods "
  Public Overrides Function GetRowSet(ByVal CommandText As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, CommandType.Text, Regex.Replace(CommandText, "(?i){objectqualifier}(?-i)", ObjectQualifier)), IDataReader)
  End Function

  Public Overrides Function GetScalar(ByVal CommandText As String) As Object
   Return SqlHelper.ExecuteScalar(ConnectionString, CommandType.Text, Regex.Replace(CommandText, "(?i){objectqualifier}(?-i)", ObjectQualifier))
  End Function
#End Region

#Region " Other Methods "

  Public Overrides Function GetUsersByModulePermission(ByVal ModuleId As Integer, ByVal PermissionKey As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "SiteReport_GetUsersByModulePermission", ModuleId, PermissionKey), IDataReader)
  End Function

#End Region

 End Class

End Namespace
