﻿Imports System
Imports DotNetNuke.Common
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.SiteReport.Business

Partial Public Class EditReport
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Variables "
 Private _ReportID As Integer = -1

 Public Property ReportID() As Integer
  Get
   Return _ReportID
  End Get
  Set(ByVal value As Integer)
   _ReportID = value
  End Set
 End Property
#End Region

#Region " Event Handlers "
 Private Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
  If Not (Request.Params("ReportId") Is Nothing) Then
   ReportID = Int32.Parse(Request.Params("ReportId"))
  End If
 End Sub

 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  If Not Me.IsPostBack Then

   If ReportID = -1 Then
    cmdAdd.Visible = False
    cmdDelete.Visible = False
    dgMeasures.Visible = False
   Else
    Dim r As ReportInfo = ReportsController.GetReport(ReportID, ModuleId)
    txtSummary.Text = r.Summary
    txtTitle.Text = r.Title
    cmdCreate.Visible = False
    BindList()
   End If

  End If

 End Sub

 Private Sub cmdAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdAdd.Click

  SaveReport()
  Response.Redirect(EditUrl("ReportId", ReportID.ToString, "EditMeasure"), False)

 End Sub

 Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdCancel.Click
  Response.Redirect(EditUrl("ListReports"), False)
 End Sub

 Private Sub cmdCreate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdCreate.Click

  SaveReport()
  cmdAdd.Visible = True
  cmdDelete.Visible = True
  cmdCreate.Visible = False
  Response.Redirect(EditUrl("ReportId", ReportID.ToString, "EditReport"), False)

 End Sub

 Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDelete.Click

  ReportsController.DeleteReport(ReportID)
  Response.Redirect(EditUrl("ListReports"), False)

 End Sub
#End Region

#Region " Private Methods "
 Private Sub SaveReport()
  Dim r As ReportInfo = Nothing
  If ReportID = -1 Then
   r = New ReportInfo
   r.ModuleId = Me.ModuleId
  Else
   r = ReportsController.GetReport(ReportID, ModuleId)
  End If
  With r
   .LastModified = Now
   .LastModifiedBy = Me.UserId
   .Summary = txtSummary.Text.Trim
   .Title = txtTitle.Text.Trim
  End With
  If ReportID = -1 Then
   ReportID = ReportsController.AddReport(r)
  Else
   ReportsController.UpdateReport(r)
  End If
 End Sub

 Private Sub BindList()
  DotNetNuke.Services.Localization.Localization.LocalizeDataGrid(dgMeasures, Me.LocalResourceFile)

  Dim dv As New DataView(DotNetNuke.Common.ConvertDataReaderToDataTable(Data.DataProvider.Instance().GetMeasuresByReport(ReportID)))
  With dv
   .Sort = "Order"
  End With

  With dgMeasures
   .DataSource = dv
   .DataBind()
  End With

 End Sub
#End Region

End Class