﻿Imports System
Imports System.Web.UI.WebControls
Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.SiteReport.Business

Partial Public Class Settings
 Inherits Entities.Modules.ModuleSettingsBase

#Region " Base Method Implementations "
 Public Overrides Sub LoadSettings()
  Try
   If Not Page.IsPostBack Then
    cmdStartCalendar.NavigateUrl = CType(DotNetNuke.Common.Utilities.Calendar.InvokePopupCal(txtDate), String)
    With ddInterval
     .Items.Add(New ListItem(GetString("Daily", Me.LocalResourceFile), "0"))
     .Items.Add(New ListItem(GetString("Weekly", Me.LocalResourceFile), "1"))
     .Items.Add(New ListItem(GetString("Monthly", Me.LocalResourceFile), "2"))
    End With
    Dim al As New ArrayList
    Try
     GetFileListRecursive(New IO.DirectoryInfo(Me.PortalSettings.HomeDirectoryMapPath), al, "*.xsl;*.xslt")
    Catch ex As Exception
    End Try
    With ddScreenStyleSheet
     .DataSource = al
     .DataBind()
     .Items.Insert(0, New ListItem("<" + Services.Localization.Localization.GetString("None_Specified") + ">", ""))
    End With
    With ddMailStyleSheet
     .DataSource = al
     .DataBind()
     .Items.Insert(0, New ListItem("<" + Services.Localization.Localization.GetString("None_Specified") + ">", ""))
    End With
    Dim i As Integer
    For i = 0 To 23
     ddTime.Items.Add(New ListItem(Format(i, "00") & ":00"))
    Next

    Dim Settings As New ModuleSettings(ModuleId)
    With Settings
     Try
      ddInterval.Items.FindByValue(CType(.Interval, Integer).ToString).Selected = True
     Catch ex As Exception
     End Try
     txtProcessing.Text = .Processing
     Try
      ddScreenStyleSheet.Items.FindByValue(.ScreenStyleSheet).Selected = True
      ddMailStyleSheet.Items.FindByValue(.MailStyleSheet).Selected = True
     Catch ex As Exception
     End Try
     txtDate.Text = .NextSend.ToShortDateString
     Try
      ddTime.Items.FindByText(Format(Hour(.NextSend), "00") & ":00").Selected = True
     Catch ex As Exception
     End Try
     chkSendAdmins.Checked = .SendAdmins
     txtEmailSQL.Text = .EmailSQL
    End With
   End If
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

 Public Overrides Sub UpdateSettings()
  Try

   Dim Settings As New ModuleSettings(ModuleId)
   With Settings
    .Interval = CType(ddInterval.SelectedValue, Interval)
    .Processing = txtProcessing.Text
    .ScreenStyleSheet = ddScreenStyleSheet.SelectedValue
    .MailStyleSheet = ddMailStyleSheet.SelectedValue
    .NextSend = CDate(txtDate.Text & " " & ddTime.SelectedItem.Text)
    .SendAdmins = chkSendAdmins.Checked
    .EmailSQL = txtEmailSQL.Text
    .SaveSettings(ModuleId)
   End With

   Response.Redirect(NavigateURL(), True)
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try
 End Sub

#End Region

End Class