﻿Imports System
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports Bring2mind.DNN.Modules.SiteReport.Business
Imports DotNetNuke
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization.Localization

Partial Public Class SiteReport
 Inherits Controls.PortalModuleBase
 Implements Entities.Modules.IActionable

#Region " Event Handlers "
 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  Try
   If Not Me.IsPostBack Then

    ddReport.DataSource = ReportsController.GetReportsByModule(ModuleId)
    ddReport.DataBind()
    ddReport.Items.Insert(0, New ListItem(GetString("PickReport", Me.LocalResourceFile), "-1"))

    Dim i As Integer
    For i = 0 To 6
     ddPeriod.Items.Add(New ListItem(GetString(CType(i, Periods).ToString, Me.LocalResourceFile), i.ToString))
    Next
    cmdStartCalendar.NavigateUrl = CType(DotNetNuke.Common.Utilities.Calendar.InvokePopupCal(txtStartDate), String)
    cmdEndCalendar.NavigateUrl = CType(DotNetNuke.Common.Utilities.Calendar.InvokePopupCal(txtEndDate), String)
    txtStartDate.Text = Now.AddDays(-7).ToShortDateString
    txtEndDate.Text = Now.ToShortDateString

   End If
  Catch exc As Exception
   ProcessModuleLoadException(Me, exc)
  End Try

 End Sub

 Private Sub cmdGenerate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdGenerate.Click

  If ddReport.SelectedValue = "-1" Then Exit Sub
  Dim reportId As Integer = Integer.Parse(ddReport.SelectedValue)
  Dim report As ReportInfo = ReportsController.GetReport(reportId, ModuleId)

  Dim StartTime As Date, EndTime As Date
  Dim i As Periods = CType(ddPeriod.SelectedValue, Periods)
  Select Case i
   Case Periods.Custom
    StartTime = CDate(txtStartDate.Text)
    EndTime = CDate(txtEndDate.Text & " 23:59:59")
   Case Periods.LastMonth
    StartTime = DateSerial(Year(Now.AddMonths(-1)), Month(Now.AddMonths(-1)), 1)
    EndTime = DateSerial(Year(Now), Month(Now), 1)
   Case Periods.LastWeek
    StartTime = Now.AddDays(-7 - Now.DayOfWeek)
    EndTime = Now.AddDays(Now.DayOfWeek)
   Case Periods.MonthToDate
    StartTime = DateSerial(Year(Now), Month(Now), 1)
    EndTime = Now
   Case Periods.Past24Hours
    StartTime = Now.AddHours(-24)
    EndTime = Now
   Case Periods.Past7Days
    StartTime = Now.AddDays(-7)
    EndTime = Now
   Case Else 'Periods.Yesterday
    StartTime = DateSerial(Year(Now.AddDays(-1)), Month(Now.AddDays(-1)), Day(Now.AddDays(-1)))
    EndTime = DateSerial(Year(Now), Month(Now), Day(Now))
  End Select
  Dim rep As New Report(Me.ModuleConfiguration, report, StartTime, EndTime, "portalalias=" & Me.PortalAlias.HTTPAlias)
  Dim xslf As String = Me.TemplateSourceDirectory & "\ScreenTrans.xsl"
  If Me.ModuleSettings.ScreenStyleSheet <> "" Then
   xslf = PortalSettings.HomeDirectoryMapPath & "\" & Me.ModuleSettings.ScreenStyleSheet
  End If
  With XmlResult
   .Document = rep.Report
   .TransformSource = xslf
  End With

  'rep.Report.Save(IO.Path.Combine(Server.MapPath(Me.TemplateSourceDirectory), "LatestReport.xml"))

 End Sub

 Private Sub ddPeriod_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddPeriod.SelectedIndexChanged
  Dim i As Periods = CType(ddPeriod.SelectedValue, Periods)
  txtStartDate.Enabled = (i = Periods.Custom)
  cmdStartCalendar.Enabled = (i = Periods.Custom)
  reqStartDate.Enabled = (i = Periods.Custom)
  txtEndDate.Enabled = (i = Periods.Custom)
  cmdEndCalendar.Enabled = (i = Periods.Custom)
  reqEndDate.Enabled = (i = Periods.Custom)
 End Sub
#End Region

#Region " Optional Interfaces "
 Public ReadOnly Property ModuleActions() As Entities.Modules.Actions.ModuleActionCollection Implements Entities.Modules.IActionable.ModuleActions
  Get
   Dim Actions As New Entities.Modules.Actions.ModuleActionCollection
   Actions.Add(GetNextActionID, GetString(Entities.Modules.Actions.ModuleActionType.EditContent, LocalResourceFile), Entities.Modules.Actions.ModuleActionType.EditContent, "", "", EditUrl("ListReports"), False, DotNetNuke.Security.SecurityAccessLevel.Edit, True, False)
   Return Actions
  End Get
 End Property
#End Region

End Class