﻿Imports System.IO
Imports System.Xml

Public Class FileList
 Inherits XmlDocument

#Region " Private Members "
 Private _settings As SimpleDownloadsSettings
 Private _basePath As String = ""
 Private _filePattern As String = ""
 Private _forbiddenExtensions As String = ";.rules;.asax;.ascx;.aspx;.master;.skin;.browser;.sitemap;.config;.cs;.csproj;.vb;.vbproj;.webinfo;.licx;.resx;.resources;.mdb;.vjsproj;.java;.jsl;.ldb;.ad;.dd;.ldd;.sd;.cd;.adprototype;.lddprototype;.sdm;.sdmdocument;.mdf;.ldf;.exclude;.refresh;"
#End Region

#Region " Contructors "
 Public Sub New(ByVal Settings As SimpleDownloadsSettings)
  MyBase.New()
  Me.Init()

  _settings = Settings
  _basePath = Settings.FilePath
  If Not _basePath.EndsWith("\") Then
   _basePath &= "\"
  End If
  _filePattern = Settings.FileTypes
  If _filePattern = "" Then
   _filePattern = "*.*"
  End If
  AddDirectory(Me.DocumentElement, "")

 End Sub
#End Region

#Region " Private Methods "
 Private Sub Init()
  Me.InnerXml = "<?xml version=""1.0""?><FileCollection></FileCollection>"
 End Sub

 Private Sub AddDirectory(ByRef node As XmlNode, ByVal path As String)
  Dim d As New DirectoryInfo(_basePath & path)
  For Each sd As DirectoryInfo In d.GetDirectories()
   Dim xSd As XmlNode = Me.CreateElement("Folder")
   node.AppendChild(xSd)
   AddAttribute(xSd, "Name", sd.Name)
   AddAttribute(xSd, "CreationTimeUtc", sd.CreationTimeUtc.ToString("u"))
   AddAttribute(xSd, "LastAccessTimeUtc", sd.LastAccessTimeUtc.ToString("u"))
   AddAttribute(xSd, "LastWriteTimeUtc", sd.LastWriteTimeUtc.ToString("u"))
   AddDirectory(xSd, path & sd.Name & "\")
   If xSd.ChildNodes.Count = 0 Then
    node.RemoveChild(xSd)
   End If
  Next
  For Each pat As String In _filePattern.Split(";"c)
   For Each f As FileInfo In d.GetFiles(pat)
    AddFile(node, path, f)
   Next
  Next
 End Sub

 Private Sub AddFile(ByRef node As XmlNode, ByVal path As String, ByVal f As FileInfo)
  If Not _settings.AllowAllTypes Then
   If _forbiddenExtensions.IndexOf(";" & f.Extension.ToLower & ";") > 0 Then
    Exit Sub
   End If
  End If
  Dim xf As XmlNode = Me.CreateElement("File")
  node.AppendChild(xf)
  AddAttribute(xf, "Name", f.Name)
  AddAttribute(xf, "Extension", f.Extension)
  AddAttribute(xf, "Length", f.Length.ToString)
  AddAttribute(xf, "LengthFormatted", FormatSize(f.Length))
  AddAttribute(xf, "AccessPath", HttpUtility.UrlEncode(path & f.Name))
  AddAttribute(xf, "CreationTimeUtc", f.CreationTimeUtc.ToString("u"))
  AddAttribute(xf, "LastAccessTimeUtc", f.LastAccessTimeUtc.ToString("u"))
  AddAttribute(xf, "LastWriteTimeUtc", f.LastWriteTimeUtc.ToString("u"))
 End Sub

 Private Sub AddAttribute(ByRef node As XmlNode, ByVal attributeName As String, ByVal attributeValue As String)
  Dim xA As XmlAttribute = Me.CreateAttribute(attributeName)
  xA.InnerText = attributeValue
  node.Attributes.Append(xA)
 End Sub

 Public Function FormatSize(ByVal Bts As Long) As String
  Const OneK As Integer = 1000
  If Bts > OneK ^ 3 Then
   Return (Bts / OneK ^ 3).ToString("0.0") & " GB"
  ElseIf Bts > OneK ^ 2 Then
   Return (Bts / OneK ^ 2).ToString("0.0") & " MB"
  ElseIf Bts > OneK Then
   Return (Bts / OneK).ToString("0.0") & " KB"
  Else
   Return Bts.ToString("0,000") & " B"
  End If
 End Function
#End Region

End Class
