﻿Imports System.Web.UI
Imports System.Xml
Imports System.Xml.Xsl
Imports System.Net
Imports System.IO

Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Services.Exceptions
Imports System.Web
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Entities.Modules

Public Class FileListControl
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Private Members "
 Private _xslDoc As String = ""
 Private _parameters As XsltArgumentList = Nothing
 Private _cachedOutput As String = ""
 Private _cacheTime As Integer = 0
 Private _cacheKey As String = ""
 Private _cacheFilename As String = ""
 Private _settings As SimpleDownloadsSettings
#End Region

#Region " Properties "
 Public Shadows Property Settings() As SimpleDownloadsSettings
  Get
   Return _settings
  End Get
  Set(ByVal value As SimpleDownloadsSettings)
   _settings = value
  End Set
 End Property

 Public Property XslDoc() As String
  Get
   Return _xslDoc
  End Get
  Set(ByVal value As String)
   _xslDoc = value
  End Set
 End Property

 Public Property Parameters() As XsltArgumentList
  Get
   Return _parameters
  End Get
  Set(ByVal value As XsltArgumentList)
   _parameters = value
  End Set
 End Property
#End Region

#Region " Caching and Rendering "
 Public Sub LoadUp()

  _cacheTime = Math.Abs(Me.ModuleConfiguration.CacheTime)
  If _cacheTime <> 0 Then
   If CacheMethod <> "D" Then
    ' load from memory
    _cachedOutput = Convert.ToString(DataCache.GetCache(CacheKey))
   Else
    ' load from disk 
    If File.Exists(CacheFileName) Then
     Dim cacheFile As New FileInfo(CacheFileName)
     If cacheFile.LastWriteTime.AddSeconds(Me.ModuleConfiguration.CacheTime) >= Now Then
      ' load from cache file
      Try
       Dim objStreamReader As StreamReader
       objStreamReader = cacheFile.OpenText()
       _cachedOutput = objStreamReader.ReadToEnd
       objStreamReader.Close()
      Catch ' locking error
       _cachedOutput = ""
      End Try
     End If
    End If
   End If
  End If

 End Sub

 Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)

  Try
   If _cacheTime <> 0 Then
    If _cachedOutput = "" Then
     ' if no cached output exists render child controls into a TextWriter and save the results
     Dim tempWriter As StringWriter = New StringWriter
     RenderOutput(New HtmlTextWriter(tempWriter))
     _cachedOutput = tempWriter.ToString()
    End If
    If _cachedOutput <> "" Then
     ' if cached content exists
     If CacheMethod <> "D" Then
      ' cache to memory
      DataCache.SetCache(CacheKey, _cachedOutput, DateTime.Now.AddSeconds(Me.ModuleConfiguration.CacheTime))
     Else
      ' cache to disk
      Try
       Dim blnUpdateCache As Boolean = False
       If File.Exists(CacheFileName) = False Then
        blnUpdateCache = True
       Else
        Dim cacheFile As New FileInfo(CacheFileName)
        If cacheFile.LastWriteTime.AddSeconds(Me.ModuleConfiguration.CacheTime) < Now Then
         blnUpdateCache = True
        End If
       End If
       If blnUpdateCache Then
        If Not Directory.Exists(ModuleController.CacheDirectory) Then
         Directory.CreateDirectory(ModuleController.CacheDirectory)
        End If
        Dim objStream As StreamWriter
        objStream = File.CreateText(CacheFileName)
        objStream.Write(_cachedOutput)
        objStream.Close()
       End If
      Catch
       ' error writing to disk
      End Try
     End If
     output.Write(_cachedOutput)
    Else ' no cached content
     RenderOutput(output)
    End If
   Else ' no caching
    RenderOutput(output)
   End If
  Catch ex As Exception
   output.Write(ex.Message)
   ProcessModuleLoadException(Me, ex)
  End Try

 End Sub

 Public Sub RenderOutput(ByVal output As System.Web.UI.HtmlTextWriter)

  ' Security check
  If Not Settings.AllowOutside Then
   If Not Settings.FilePath.StartsWith(PortalSettings.HomeDirectoryMapPath) Then
    Throw New Exception(String.Format("You are trying to access a path ('{0}') outside the home directory path. This has been disallowed by the host.", Settings.FilePath))
   End If
  End If

  Dim XmlDoc As XmlDocument = New FileList(Me.Settings)
  output.WriteBeginTag("div")
  output.WriteAttribute("class", "normal")
  output.Write(HtmlTextWriter.TagRightChar)
  Try
   Dim Xslt As XslCompiledTransform = GetXslTransform()
   Dim Xml As XmlReader = New XmlNodeReader(XmlDoc)
   If Not Xslt Is Nothing And Not Xml Is Nothing Then
    Xslt.Transform(Xml, Parameters, output)
   End If
  Catch exc As Exception    'Module failed to load
   ProcessModuleLoadException(Me, exc)
  Finally
   output.WriteEndTag("div")
  End Try

 End Sub

 Public Overridable Shadows Function CacheKey() As String
  If _cacheKey = "" Then
   _cacheKey = "Downloads:"
   _cacheKey += ModuleId.ToString
  End If
  Return _cacheKey
 End Function

 Public Shadows Function CacheFileName() As String
  If _cacheFilename = "" Then
   _cacheFilename = ModuleController.CacheDirectory() & "\" & DotNetNuke.Common.CleanFileName(CacheKey) & ".resources"
  End If
  Return _cacheFilename
 End Function
#End Region

#Region " Private Methods "
 Protected Function GetXslTransform() As XslCompiledTransform
  Dim trans As New XslCompiledTransform
  trans.Load(XslDoc)
  Return trans
 End Function
#End Region

End Class
