﻿Imports System.Xml
Imports System.Xml.Xsl

Imports DotNetNuke.Services.Exceptions

Partial Public Class SimpleDownloads
 Inherits ModuleBase

#Region " Page Events "
 Private Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

  If Me.Request.Params("file") IsNot Nothing Then
   Response.Redirect(ResolveUrl("~/DesktopModules/Bring2mind/SimpleDownloads/Download.aspx") & "?tabid=" & TabId.ToString & "&mid=" & ModuleId.ToString & "&file=" & Me.Request.Params("file"), False)
   Exit Sub
  End If

  Try
   Page.ClientScript.RegisterClientScriptInclude(GetType(ModuleBase), "jquery 1.2.6", "http://ajax.googleapis.com/ajax/libs/jquery/1.2.6/jquery.min.js")
   Page.ClientScript.RegisterClientScriptBlock(GetType(String), "jQueryFix", "var j = jQuery.noConflict();", True)
   Page.ClientScript.RegisterClientScriptInclude("jQuery Treeview 1.4", ResolveUrl("~/DesktopModules/Bring2mind/SimpleDownloads/jquery.treeview.min.js"))
   With ctlFileList
    .ModuleConfiguration = Me.ModuleConfiguration ' needed for caching
    .Parameters = GetParameterList()
    .Settings = Me.Settings
    .XslDoc = Server.MapPath(DotNetNuke.Common.ResolveUrl("~/DesktopModules/Bring2mind/SimpleDownloads/FileListTrans.Xsl"))
    .LoadUp()
   End With
  Catch ex As Exception
   ProcessModuleLoadException(Me, ex)
  End Try
  Me.ModuleConfiguration.CacheTime = 0 ' if not, the module recycles indefinitely

 End Sub
#End Region

#Region " Private Methods "
 Public Function GetParameterList() As XsltArgumentList
  Dim res As New XsltArgumentList
  res.AddParam("DownloadPath", "", ResolveUrl("~/DesktopModules/Bring2mind/SimpleDownloads/Download.aspx") & "?tabid=" & TabId.ToString & "&mid=" & ModuleId.ToString)
  res.AddParam("Locale", "", Threading.Thread.CurrentThread.CurrentUICulture.Name)
  Return res
 End Function
#End Region

End Class
