var gulp=require("gulp"),browserify=require("browserify"),source=require("vinyl-source-stream"),buffer=require("vinyl-buffer"),sourcemaps=require("gulp-sourcemaps"),babelify=require("babelify"),msbuild=require("gulp-msbuild"),assemblyInfo=require("gulp-dotnet-assembly-info"),plumber=require("gulp-plumber"),config=require("./package.json"),zip=require("gulp-zip"),filter=require("gulp-filter"),merge=require("merge2"),gutil=require("gulp-util"),markdown=require("gulp-markdown"),rename=require("gulp-rename"),manifest=require("gulp-dnn-manifest"),path=require("path"),concat=require("gulp-concat"),fs=require("fs"),dlls=["Bring2mind.DNN.Modules.DMX.Core8.dll","Bring2mind.DNN.Modules.DMX.Core.dll","Bring2mind.DNN.Modules.DMX.dll","Bring2mind.DNN.Modules.DMX.WebDAV.dll"],less=require("gulp-less"),lessPluginCleanCSS=require("less-plugin-clean-css"),cleancss=new lessPluginCleanCSS({advanced:true});gulp.task("less",function(){return gulp.src("css/src/less/module.less").pipe(less({paths:[path.join(__dirname,"less","includes")],plugins:[cleancss]})).pipe(gulp.dest("css/src"))});gulp.task("css",["less"],function(){gulp.src("node_modules/bootstrap/less/bootstrap.less").pipe(less({paths:[path.join(__dirname,"less","includes")],plugins:[cleancss]})).pipe(rename("bootstrap.min.css")).pipe(gulp.dest("css"));return gulp.src(["css/src/module.css"]).pipe(gulp.dest("."))});gulp.task("js",function(){return gulp.src(["node_modules/bootstrap/dist/js/bootstrap.min.js","node_modules/simple-ajax-uploader/SimpleAjaxUploader.min.js"]).pipe(gulp.dest("js"))});gulp.task("browserify",function(){var a=browserify({entries:["js/src/dmx.js"],debug:true});a.transform("babelify",{presets:["es2015","react"]});a.external("react");var c=a.bundle().on("error",function(b){console.log(b.message);this.emit("end")}).pipe(source("DMX.js")).pipe(buffer()).pipe(sourcemaps.init({loadMaps:true})).on("error",gutil.log);return merge(gulp.src("js/src/common.js"),gulp.src("js/src/jquery-resize.js"),gulp.src("js/src/pdfobject.js"),c).pipe(concat("dmx.js")).pipe(gulp.dest("js/"))});gulp.task("watch",function(){gulp.watch("js/src/**/*.js*",["browserify"]);gulp.watch("css/src/**/*.less",["css"])});gulp.task("assemblyInfo",function(){return gulp.src("**/AssemblyInfo.cs").pipe(assemblyInfo({title:config.dnn.friendlyName,description:config.description,version:config.version,fileVersion:config.version,company:config.dnn.owner.organization,copyright:function(a){return"Copyright "+new Date().getFullYear()+" by "+config.dnn.owner.organization}})).pipe(gulp.dest("."))});gulp.task("buildCore8",["assemblyInfo"],function(){return gulp.src("./SubProjects/Bring2mind.DNN.Modules.DMX.Core8/Bring2mind.DNN.Modules.DMX.Core8.csproj").pipe(msbuild({toolsVersion:14,targets:["Clean","Build"],errorOnFail:true,stdout:true,properties:{Configuration:"Release",OutputPath:"../../"+config.dnn.pathToAssemblies}}))});gulp.task("buildDMX",["assemblyInfo"],function(){return gulp.src("./Bring2mind.DMX.vbproj").pipe(msbuild({toolsVersion:14,targets:["Clean","Build"],errorOnFail:true,stdout:true,properties:{Configuration:"Release",OutputPath:config.dnn.pathToAssemblies}}))});gulp.task("build",["buildCore8","buildDMX"],function(){return null});gulp.task("packageInstall",["build"],function(){gutil.log("Starting packaging");console.log("Deleting files we don't need");console.log(config.dnn.pathToAssemblies);var b=fs.readdirSync(config.dnn.pathToAssemblies);b.forEach(function(e,f,d){if(path.extname(b[f])===".dll"){if(dlls.indexOf(e)==-1){console.log("Deleting "+e);fs.unlinkSync(config.dnn.pathToAssemblies+"/"+e)}}});var c=config.dnn.fullName+"_"+config.version;var a=filter(fileTest);return merge(gulp.src(["Providers/UploadProviders/RadUploadProvider/*.ascx"],{base:"./"}).pipe(a).pipe(zip("Resources.zip")),gulp.src("_Installation/License.txt"),manifest(config,"./_Installation/Bring2mind.DMX.dnn").pipe(rename("Bring2mind.DMX.dnn")),gulp.src([config.dnn.pathToAssemblies+"/*.dll"])).pipe(zip("Bring2mind_DMX_"+config.version+"_PatchDNN8.zip")).pipe(gulp.dest(config.dnn.packagesPath))});gulp.task("package",["packageInstall"],function(){return null});function fileTest(a){var c=false;for(var b=config.dnn.excludeFilter.length-1;b>=0;b--){c=c|a.relative.startsWith(config.dnn.excludeFilter[b])|a.relative.indexOf("/obj/")>-1}return !c}function startsWith(a,b){return a.indexOf(b)===0};