var _MouseX = 0;
var _MouseY = 0;
var CA_IE = document.all ? true : false;
var b_mode = document.compatMode == 'CSS1Compat' ? 'S' : 'Q';
var editEntryId;
var editParentId;
var lastSelectedNode;
var lastSearchedNode;
var lastSelectedItems;
var selectionChanged;
var selection;
var cbresult;
var gridSelectionTitles;
var treeSelectionTitle;
var autoSelect = false;
var draggedItemId;
var targetItemId;

$(document).ready(function () {
  $('div.VCBox').bind("contextmenu", function (e) {
    return false;
  });
  $(document).mousemove(function (e) {
    _MouseX = e.pageX;
    _MouseY = e.pageY;
  });
  loadEvent();
});


function GetConfirmationText(text, context) {
  if (context == 'Tree') {
    return text.replace('{0}', treeSelectionTitle);
  } else {
    return text.replace('{0}', gridSelectionTitles);
  }
};

function resolveUrl(url) {
  return appPath + url;
};

function itemThumbnail(thumbnail) {
  if (thumbnail == '' || thumbnail == null) {
    return '';
  } else {
    if (isNaN(thumbnail)) {
      return '<img src="' + thumbnailPath + thumbnail + '" alt="" class="thumbnail" />';
    } else {
      return '<img src="' + downloadUrl + '?PortalId=' + portalId + '&EntryId=' + thumbnail + '" alt="" class="thumbnail" />';
    }
  }
};

function attachThumbnailRollovers() {
  $('.thumbnail').parent().parent().hover(
    function (e) {
      $(this).children().children('.thumbnail').css({ left: e.pageX + 10 - $(window).scrollLeft(), top: e.pageY + 10 - $(window).scrollTop() }).fadeIn(300);
    },
    function () {
      $(this).children().children('.thumbnail').fadeOut(100);
    });
};

function Grid1_onSortChange(sender, eventArgs) {
  // console.log('Grid1_onSortChange');
  var desc = eventArgs.get_descending();
  var column = eventArgs.get_column();
  var columnIndexForIsFolder = 5;
  Grid1.sortMulti([columnIndexForIsFolder, !desc, column.ColumnNumber, desc]);
};

function resizeTree(sender, eventArgs) {
  // console.log('resizeTree');
  updateSizeBox();
  TreeviewRedraw();
};

function resizeDetails(sender, eventArgs) {
  // console.log('resizeDetails');
  updateSizeBox();
  DetailsRedraw();
};

function resizeGrid(sender, eventArgs) {
  // console.log('resizeGrid ');
  updateSizeBox();
  GridRedraw(isSplitterLoaded);
  if (!isSplitterLoaded) {
    FixGridColumnWidths();
    Grid1.Render();
  }
};

function updateSizeBox() {
  // console.log('updateSizeBox ');
  var res;
  var pane = Splitter1.get_panes()[0];
  res = pane.get_width() + '|';
  res = res + pane.get_height() + '|';
  pane = Splitter1.get_panes()[1].get_panes()[0];
  res = res + pane.get_width() + '|';
  res = res + pane.get_height() + '|';
  pane = Splitter1.get_panes()[1].get_panes()[1];
  res = res + pane.get_width() + '|';
  res = res + pane.get_height() + '|';
  res = res + lastSelectedNode + '|';
  res = res + lastSelectedItems + '|';
  document.getElementById(hidStuff).value = res;
  // console.log(res);
};

function LoadTreeViewContextMenu(sender, eventArgs) {
  // console.log('LoadTreeViewContextMenu');
  ContextMenuCallBack.Callback(eventArgs.get_node().get_id());
};

function LoadGridContextMenu(sender, eventArgs) {
  // console.log('LoadGridContextMenu');
  if (sender.getSelectedItems().length == 0) {
    sender.select(eventArgs.get_item(), false);
  } else {
    if (lastSelectedItems[0] != eventArgs.get_item().getMember('EntryId').get_value()) {
      sender.select(eventArgs.get_item(), false);
    }
  }
  var tvNode
  if (TreeView1.get_selectedNode()) {
    tvNode = TreeView1.get_selectedNode().get_id();
  } else {
    tvNode = 'ent0';
  }
  var itms = sender.getSelectedItems();
  var ids = new Array();
  for (i = 0; i < itms.length; i++) {
    ids[ids.length] = 'ent' + itms[i].getMember('EntryId').get_value();
  }
  ContextMenuCallBack.Callback(tvNode, ids);
};

function OnCallBackError(sender, eventArgs) {
  // simply do nothing
};

function tvCallbackComplete(sender, eventArgs) {
  // console.log('tvCallbackComplete');
  repairTreeClasses();
}

function TreeViewNodeSelect(sender, eventArgs) {
  // console.log('TreeViewNodeSelect');
  repairTreeClasses();
  if (lastSelectedNode != eventArgs.get_node().get_id()) {
    lastSelectedItems = null;
  }
  lastSelectedNode = eventArgs.get_node().get_id();
  treeSelectionTitle = eventArgs.get_node().get_text();
  MenuCallBack.Callback(eventArgs.get_node().get_id());
  setTimeout('GridRedraw(true)', 100);
  setTimeout('DetailsRedraw(true)', 200);
  updateSizeBox();
}

function GridItemSelect(sender, eventArgs) {
  // console.log('GridItemSelect');
  if (autoSelect) return;
  var tvNode;
  if (TreeView1.get_selectedNode()) {
    tvNode = TreeView1.get_selectedNode().get_id();
  } else {
    tvNode = 'ent0';
  }
  var itms = new Array();
  itms = sender.getSelectedItems();
  lastSelectedItems = new Array();
  for (i = 0; i < itms.length; i++) {
    lastSelectedItems[lastSelectedItems.length] = itms[i].getMember('EntryId').get_value();
  }
  if (itms.length == 1) {
    DetailsCallBack.Callback('ent' + itms[0].getMember('EntryId').get_value());
    MenuCallBack.Callback(tvNode, 'ent' + itms[0].getMember('EntryId').get_value());
    gridSelectionTitles = itms[0].getMember('Title').get_value();
    selection = ['ent' + itms[0].getMember('EntryId').get_value()];
  } else {
    var ids = new Array();
    gridSelectionTitles = '';
    for (i = 0; i < itms.length; i++) {
      ids[ids.length] = 'ent' + itms[i].getMember('EntryId').get_value();
      gridSelectionTitles = gridSelectionTitles + ', ' + itms[i].getMember('Title').get_value();
    }
    gridSelectionTitles = gridSelectionTitles.substring(2);
    selectionChanged = true;
    selection = ids;
    MenuCallBack.Callback(tvNode, ids);
  }
  updateSizeBox();
}

function MenuBeforeCallback(sender, eventArgs) {
  selectionChanged = false;
}

function MenuCallbackComplete(sender, eventArgs) {
  if (selectionChanged) {
    var tvNode;
    if (TreeView1.get_selectedNode()) {
      tvNode = TreeView1.get_selectedNode().get_id();
    } else {
      tvNode = 'ent0';
    }
    MenuCallBack.Callback(tvNode, selection);
  }
}

String.prototype.startsWith = function (s) { return this.indexOf(s) == 0; }

function GridItemDoubleClick(sender, eventArgs) {
  // console.log('GridItemDoubleClick');
  if (eventArgs.get_item().getMember('IsCollection').get_value()) {
    if (eventArgs.get_item().getMember('ControlToLoad').get_value() == 'Bring2mind/DMX/Views/AjaxThreePanel.ascx') {
      TreeView1.findNodeById('ent' + eventArgs.get_item().getMember('EntryId').get_value()).expand();
      TreeView1.findNodeById('ent' + eventArgs.get_item().getMember('EntryId').get_value()).select();
      if (Grid1) { Grid1.dispose() };
      GridCallBack.Callback('ent' + eventArgs.get_item().getMember('EntryId').get_value());
      DetailsCallBack.Callback(eventArgs.get_item().getMember('EntryId').get_value());
    } else {
      window.location = baseUrl + baseUrlSuffix + 'EntryId=' + eventArgs.get_item().getMember('EntryId').get_value();
    }
  } else {
    if (eventArgs.get_item().getMember('EntryType').get_value().startsWith('Hyperlink')) {
      window.open(appPath + 'DesktopModules/Bring2mind/DMX/API/Entries/Download?PortalId=' + portalId + '&EntryId=' + eventArgs.get_item().getMember('EntryId').get_value(), '', '');
    }
    if (eventArgs.get_item().getMember('EntryType').get_value().startsWith('File')) {
      window.open(baseUrl + baseUrlSuffix + 'Command=Core_Download&EntryId=' + eventArgs.get_item().getMember('EntryId').get_value(), '', '');
    }
  }
  updateSizeBox();
}

function CommandCallBackComplete(sender, eventArgs) {
  if (cbresult.result.isinerror == 'true') {
    $('#' + divFeedbackFormId).attr('class', 'NormalRed');
    $('#' + divFeedbackFormId).html(cbresult.result.message);
    dlgFeedback.Show();
    return;
  } else {
    if (cbresult.result.showpopup == 'true') {
      $('#' + divFeedbackFormId).attr('class', '');
      $('#' + divFeedbackFormId).html(cbresult.result.message);
      dlgFeedback.Show();
    }
  };
  var command = cbresult.result.command;
  var itemList = cbresult.result.argslist;

  var tvNode
  if (TreeView1.get_selectedNode()) {
    tvNode = TreeView1.get_selectedNode().get_id();
  } else {
    tvNode = 'ent0';
  }
  switch (command) {
    case 'CopyToCB':
      MenuCallBack.Callback(tvNode, itemList);
      break;
    case 'CutToCB':
      MenuCallBack.Callback(tvNode, itemList);
      break;
    case 'RemoveFromCB':
      MenuCallBack.Callback(tvNode, itemList);
      break;
    case 'ClearCB':
      MenuCallBack.Callback(tvNode, itemList);
      break;
    case 'Delete':
    case 'HardDelete':
      if (itemList == lastSelectedNode) {
        window.location = baseUrl;
      } else {
        var itms = new Array();
        itms = Grid1.getSelectedItems();
        for (i = 0; i < itms.length; i++) {
          var nId = 'ent' + itms[i].getMember('EntryId').get_value();
          var nod = TreeView1.findNodeById(nId);
          if (nod) { nod.remove() }
        }
        repairTreeClasses();
        MenuCallBack.Callback(tvNode, itemList);
        Grid1.dispose();
        GridCallBack.Callback(tvNode);
      }
      break;
    case 'Recover':
      if (lastSelectedNode == 'recyclebin') {
        MenuCallBack.Callback(tvNode, '');
        Grid1.dispose();
        GridCallBack.Callback(tvNode);
        DetailsCallBack.Callback('');
        lastSelectedItems = '';
      } else {
        window.location = baseUrl + baseUrlSuffix + 'EntryId=' + lastSelectedNode;
      }
      break;
    case 'Move':
      for (i = 0; i < selection.length; i++) {
        Grid1.deleteItem(Grid1.getItemFromKey(0, selection[i].substring(3)));
      }
      selection = null;
      setTimeout('GridRedraw(false);', 1000);
      if (typeof draggedItem != 'undefined' && draggedItem.getMember('EntryType').get_text() == 'Collection') {
        var drg = TreeView1.findNodeById(draggedItemId);
        var tr = TreeView1.findNodeById(targetItemId);
        if (drg) {
          drg.remove();
          if (tr) {
            tr.get_nodes().add(drg);
          }
        }
      }
      break;
    default:
      MenuCallBack.Callback(tvNode, itemList);
      Grid1.dispose();
      GridCallBack.Callback(tvNode);
  }
}

function GridItemsCommand(command, itemList) {
  // console.log('GridItemsCommand');
  CommandCallBack.Callback(command, itemList);
}

function CallView(entryId) {
  // console.log('CallView ' + entryId);
  ViewCallBack.Callback($(window).width(), $(window).height(), entryId)
}

function ViewCallBackComplete(sender, eventArgs) {
  // console.log('ViewCallBackComplete');
  var h = document.getElementById('dlgView').style.height;
  if (h.indexOf('px') > -1) {
    h = h.substring(0, h.indexOf('px'))
  }
  var dh = parseInt(h);
  var nh = dh - 42;
  dialogDiv = document.getElementById('dlgView_InnerSpan');
  dialogDiv.style.height = nh + 'px';
  dlgView.Show();
}

function editEntry(entryId, parentId, newVersion) {
  // console.log('editEntry');
  if (entryId == '-1') {
    EditCallBack.Callback('-1', parentId);
  } else {
    EditCallBack.Callback(entryId, newVersion);
  }
  editEntryId = entryId;
  editParentId = parentId;
  Dialog1.Show();
}

function closedialog() {
  // console.log('closedialog 1');
  Dialog1.close();
  Grid1.dispose();
  GridCallBack.Callback(editParentId);
  TreeviewCallBack.Callback(editParentId);
  if (editEntryId != '-1') {
    DetailsCallBack.Callback(editEntryId);
  }
}

function formatFileSize(size) {
  if (size > Math.pow(1024, 3)) {
    return parseInt(size / Math.pow(1024, 3)) + ' GB';
  } else {
    if (size > Math.pow(1024, 2)) {
      return parseInt(size / Math.pow(1024, 2)) + ' MB';
    } else {
      if (size > 1024) {
        return parseInt(size / 1024) + ' KB';
      } else {
        if (size == 0) {
          return '';
        } else {
          return size + ' B';
        }
      }
    }
  }
}


function handleWheel(grid, delta) {
  var pageSize = grid.PageSize;
  var offSet = grid.RecordOffset;
  var recordCount = grid.RecordCount;
  if (recordCount > pageSize) {
    var scrollBy = parseInt(delta * -1 * pageSize / 2);
    if (scrollBy + offSet > recordCount)
      grid.ScrollTo(recordCount - pageSize);
    else
      if (scrollBy + offSet < 0)
        grid.ScrollTo(0);
      else
        grid.ScrollBy(scrollBy);
  }
}

function wheel(e) {
  if (!e) e = window.event;
  var t = e.target || e.srcElement;
  t = Grid1;
  var delta = 0;
  if (e.wheelDelta) {
    delta = e.wheelDelta / 120;
    if (window.opera) delta = -delta;
  } else
    if (e.detail) delta = -e.detail / 3;
  if (delta) handleWheel(t, delta);
  if (e.preventDefault) e.preventDefault();
  e.returnValue = false;
}

function enableMouseWheel(grid) {
  var dom = document.getElementById(grid + "_dom");
  if (!dom) return;
  if (dom.addEventListener) {
    dom.removeEventListener("DOMMouseScroll", wheel, false);
    dom.addEventListener("DOMMouseScroll", wheel, false);
  } else
    dom.onmousewheel = wheel;
}

function enableSelectAll(grid) {
  var dom = document.getElementById(grid + "_dom");
  if (!dom) return;
  if (dom.addEventListener) {
    dom.removeEventListener("onkeydown", selectAll, false);
    dom.addEventListener("onkeydown", selectAll, false);
  } else if (dom.attachEvent) {
    dom.detachEvent("onkeydown", selectAll);
    dom.attachEvent("onkeydown", selectAll);
  } else
    dome.onkeydown = selectAll;
}

function selectAll(e) {
  if (!e) e = window.event;
  var t = e.target || e.srcElement;
  if (e.ctrlKey && isKeyA(e.keyCode)) {
    t = Grid1;
    if (t.RecordCount > 1000) return false;
    for (var r = 0; r < t.RecordCount; r++) {
      var row = t.Table.GetRow(r);
      if (!row.Selected) t.Select(row, true);
    }
    return false;
  }
  return true;
}

function isKeyA(keyCode) {
  return keyCode == 97 || keyCode == 65;
}

function TreeviewCallBackComplete(sender, eventArgs) {
  // console.log('tv cb complete');
  TreeviewRedraw(false)
}

function TreeviewRedraw(checkSelection) {
  // console.log('tv redraw');
  var sizes = document.getElementById(hidStuff).value.split('|');
  document.getElementById("TreeContainer").style.width = sizes[0] + 'px';
  document.getElementById("TreeContainer").style.height = sizes[1] + 'px';
  if (TreeView1) {
    TreeView1.render();
    if (checkSelection && lastSelectedNode) {
      var TheNode = TreeView1.findNodeById(lastSelectedNode);
      if (TheNode) {
        TheNode.expand();
        TheNode.select();
      }
    }
  }
  repairTreeClasses();
}

function repairTreeClasses() {
  // console.log('repairTreeClasses');
  $('table.TreeNode tbody tr td[vAlign=middle]:not([class])').attr('class', function () { return jQuery(this).parent().parent().parent().attr('class') });
  $('table.TreeNode tbody tr td[vAlign=middle]').removeClass('TreeNode');
  $('table.TreeNode').attr('class', 'TreeNode');
}

function GridCallBackComplete(sender, eventArgs) {
  // console.log('GridCallBackComplete');
  GridRedraw(false);
  FixGridColumnWidths();
  Grid1.render();
  if (lastSelectedItems) {
    autoSelect = true;
    for (i = 0; i < lastSelectedItems.length; i++) {
      selectGridRow(lastSelectedItems[i]);
    }
    autoSelect = false;
  }
  attachThumbnailRollovers();
}

function selectGridRow(selectId) {
  for (j = 0; j < Grid1.get_table().getRowCount(); j++) {
    if (Grid1.get_table().getRow(j).getMember('EntryId').get_value() == selectId) {
      Grid1.select(Grid1.get_table().getRow(j), true);
    }
  }
};

function gridRenderComplete(sender, eventArgs) {
  // console.log('gridRenderComplete');
  // if (CA_IE && b_mode == 'Q') {
  var sizes = document.getElementById(hidStuff).value.split('|');
  document.getElementById(Grid1.get_id() + '_dom').style.height = (sizes[3] - 29) + 'px';
  document.getElementById(Grid1.get_id() + '_VerticalScrollDiv').style.height = (sizes[3] - 57) + 'px';
  //}
  if (DmxAjaxUI.DragAndDrop != undefined) {
    if (DmxAjaxUI.DragAndDrop.hookDragAndDrop != undefined) {
      var n = (lastSelectedNode == undefined) ? -1 : lastSelectedNode.substring(3);
      DmxAjaxUI.DragAndDrop.hookDragAndDrop(n);
    }
  }
};

function GridRedraw(checkSelection) {
  // console.log('GridRedraw');
  var sizes = document.getElementById(hidStuff).value.split('|');
  GridCallBack.element.style.width = (sizes[2] - 2) + 'px';
  Grid1.element.style.width = (sizes[2] - 2) + 'px';
  GridCallBack.element.style.height = sizes[3] + 'px';
  document.getElementById(Grid1.get_id() + '_dom').style.height = (sizes[3] - 52) + 'px';
  if (checkSelection) {
    if (lastSelectedNode) {
      if (Grid1) {
        Grid1.dispose();
        GridCallBack.Callback(lastSelectedNode);
      }
    } else {
      FixGridColumnWidths();
      Grid1.render();
    }
  }
  attachThumbnailRollovers();
};

function FixGridColumnWidths() {
  var i;
  var col;
  var columns = Grid1.get_table().get_columns();
  for (i = 0; i < columns.length; i++) {
    col = columns[i];
    if (!col.get_fixedWidth())
      col.set_width(0);
  }
};

function DetailsCallBackComplete(sender, eventArgs) {
  DetailsRedraw(false)
}

function DetailsRedraw(checkSelection) {
  // console.log('DetailsRedraw');
  var sizes = document.getElementById(hidStuff).value.split('|');
  // DetailsCallBack.DomElement.style.width = sizes[4] + 'px';
  // DetailsCallBack.DomElement.style.height = sizes[5] + 'px';
  if (checkSelection) {
    if (lastSelectedItems) {
      var selItems = lastSelectedItems; //  Don't split this  .split(',');
      DetailsCallBack.Callback(selItems); // Don't split this [0]
    } else {
      if (lastSelectedNode) {
        DetailsCallBack.Callback(lastSelectedNode);
      } else {
        // TabStrip1.Render();
      }
    }
  }
}

function loadEvent() {
  // console.log('onLoad');
  var sizes = document.getElementById(hidStuff).value.split('|');
  if (sizes[6].length > 0) { if (sizes[6].indexOf('undefined') == -1) { lastSelectedNode = sizes[6]; } } // Check that the Value is not undefined
  if (sizes[7].length > 0) { if (sizes[7].indexOf('undefined') == -1) { lastSelectedItems = sizes[7].split(','); } } // Check that the Value is not undefined
}

function clearSearch() {
  txt1Search.value = '';
  txt2Search.value = '';
  txt3Search.value = '';
  txt4Search.value = '';
  txtQuickSearch.value = '';
  TabStrip2.selectTabById('tabQuickSearch');
}

function showSearch() {
  // console.log('showSearch');
  if (lastSelectedNode != 'searchresults') { lastSearchedNode = lastSelectedNode || -2 };
  switch (TabStrip2.getSelectedTab().get_value()) {
    case 'regularsearch':
      var scope = '';
      for (i = 0; i < rblScope.length; i++) {
        var el = rblScope[i];
        if (el.type == "radio" && el.checked) {
          scope = el.value;
          break;
        }
      }
      CommandCallBack.Callback('RegularSearch',
        dd1Field.options[dd1Field.selectedIndex].value, dd1Selection.options[dd1Selection.selectedIndex].value, txt1Search.value, chk1Exact.checked,
        dd2Field.options[dd2Field.selectedIndex].value, dd2Selection.options[dd2Selection.selectedIndex].value, txt2Search.value, chk2Exact.checked,
        dd3Field.options[dd3Field.selectedIndex].value, dd3Selection.options[dd3Selection.selectedIndex].value, txt3Search.value, chk3Exact.checked,
        dd4Field.options[dd4Field.selectedIndex].value, dd4Selection.options[dd4Selection.selectedIndex].value, txt4Search.value, chk4Exact.checked,
        ddCombination.options[ddCombination.selectedIndex].value, chkAllVersions.checked, scope, lastSearchedNode);
      break;
    default:
      if (txtQuickSearch.value == '') return;
      var fields = '';
      for (i = 0; i < rblFields.length; i++) {
        var el = rblFields[i];
        if (el.type == "radio" && el.checked) {
          fields = el.value;
          break;
        }
      }
      var scope = '';
      for (i = 0; i < rblScopeQ.length; i++) {
        var el = rblScopeQ[i];
        if (el.type == "radio" && el.checked) {
          scope = el.value;
          break;
        }
      }
      CommandCallBack.Callback('QuickSearch',
        txtQuickSearch.value, fields, scope, lastSearchedNode);
  }
  Grid1.dispose();
  setTimeout('GridCallBack.Callback(\'searchresults\');', 1500);
  setTimeout('TreeView1.selectNodeById(\'searchresults\');', 1000);
  Dialog2.Close();
}

function checkvalue() {
  alert(rblScope.length);
}

function GridLoad(sender, eventArgs) {
  // console.log('GridLoad ');
  enableMouseWheel(grid1clientId);
  enableSelectAll(grid1clientId);
  isGridLoaded = true;
}

function SplitterLoad(sender, eventArgs) {
  // console.log('SplitterLoad ');
  setTimeout('AfterSplitterLoad();', 1500);
}

function AfterSplitterLoad() {
  // console.log('AfterSplitterLoad');
  TreeviewRedraw(isPostBack);
  GridRedraw(isPostBack);
  DetailsRedraw(isPostBack);
  isSplitterLoaded = true;
}

function Dialog2_onShow() {
  // clearSearch();
  setTimeout('txtQuickSearch.focus();', 500);
}

function captureKeys(eventArgs) {
  eventArgs = eventArgs || window.event;
  if (eventArgs != undefined) {
    kCode = eventArgs.keyCode || eventArgs.which;
    if (eventArgs.ctrlKey && kCode == 70 || eventArgs.ctrlKey && eventArgs.shiftKey && kCode == 70) {
      Dialog2.Show();
      eventArgs.cancelBubble = true;
      eventArgs.returnValue = false;
    }
  }
}

function dragDropNode(sender, eventArgs) {
  // console.log('dragDropNode');
  draggedItemId = eventArgs.get_node().get_id();
  targetItemId = eventArgs.get_newParentNode().get_id();
  GridItemsCommand('Move', draggedItemId + ',' + targetItemId);
  setTimeout('GridRedraw(false);', 1000);
}

function dragDropGridItem(sender, eventArgs) {
  // console.log('dragDropGridItem');
  var targetControl = eventArgs.get_targetControl().get_id();
  var targetItem = eventArgs.get_target();
  if (selection == null) {
    selection = ['ent' + eventArgs.get_item().getMember('EntryId').get_value()];
  }
  if (endsWith(targetControl, 'Grid1')) {
    targetItemId = 'ent' + targetItem.getMember('EntryId').get_text();
  } else {
    targetItemId = targetItem.get_id();
  }
  if (targetItemId.substr(0, 3) == 'ent') {
    GridItemsCommand('Move', selection + ',' + targetItemId);
  } else {
    if (targetItemId.substr(0, 3) == 'cat') {
      GridItemsCommand('Move', selection + ',' + targetItemId);
      selection = null;
    } else {
      alert(noPermission);
    }
  }
}

function dglViewResize(sender, eventArgs) {
  $("#dlgViewContent").width($("#dlgView_InnerSpan").width() - 10);
  $("#dlgViewContent").height($("#dlgView_InnerSpan").height());
}

function DialogMaximize(dialogId) {
  $("#" + dialogId).width($(window).width()).height($(window).height()).offset({ left: 0, top: 0 });
  $("#dlgView_InnerSpan").height($(window).height() - $("#dlgView_HeaderSpan").height() - $("#dlgView_FooterSpan").height());
  $("#dlgViewContent").width($("#dlgView_InnerSpan").width() - 10);
  $("#dlgViewContent").height($("#dlgView_InnerSpan").height());
}

function showLink(link) {
  if (typeof $().modal == 'function') {
    $('#dmxShowLinkText').val(link);
    $('#dmxShowLink').modal('show');
    $('#dmxShowLinkLink').text(link).attr('href', link);
    $("#dmxShowLinkText").on("click", function () {
      $(this).select();
    });
    return false;
  } else {
    var newwin = window.open('', 'newwin', 'resizable=no,width=800,height=100');
    newwin.document.open();
    newwin.document.write("");
    newwin.document.write("<table width=90% align=center><tr><td>");
    newwin.document.write(link);
    newwin.document.write("<br><br><a href=# onClick=window.close();><b>Close</b></a>");
    newwin.document.write("</td></tr></table>");
    newwin.document.close();
    newwin.focus();
  }
}